/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.manager;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.stiltsoft.confluence.quiz.ao.entity.UserEntity;
import java.util.Iterator;
import java.util.List;

public class ConfluencePermissionHelper {
    private PermissionManager permissionManager;
    private PageManager pageManager;
    private UserAccessor userAccessor;

    public ConfluencePermissionHelper(PermissionManager permissionManager, PageManager pageManager, UserAccessor userAccessor) {
        this.permissionManager = permissionManager;
        this.pageManager = pageManager;
        this.userAccessor = userAccessor;
    }

    public boolean canEdit(ConversionContext ctx) {
        return ctx != null && !"preview".equals(ctx.getOutputType()) && this.currentUserHasEditPermission(ctx.getEntity());
    }

    public boolean canEdit(long id) {
        return this.currentUserHasEditPermission((ContentEntityObject)this.pageManager.getAbstractPage(id));
    }

    public boolean canEdit(ContentEntityObject page) {
        return this.currentUserHasEditPermission(page);
    }

    public boolean canRemove(ContentEntityObject page) {
        return this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.REMOVE, (Object)page);
    }

    public boolean canView(long id) {
        return this.hasViewPermission((ContentEntityObject)this.pageManager.getAbstractPage(id), AuthenticatedUserThreadLocal.get());
    }

    public boolean canView(ContentEntityObject page) {
        return this.hasViewPermission(page, AuthenticatedUserThreadLocal.get());
    }

    public boolean canView(ContentEntityObject page, ConfluenceUser user) {
        return this.hasViewPermission(page, user);
    }

    public boolean canCreatePage(Space space) {
        return this.permissionManager.hasCreatePermission((User)AuthenticatedUserThreadLocal.get(), (Object)space, Page.class);
    }

    public boolean canUseConfluence(UserEntity userEntity) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(new UserKey(userEntity.getKey()));
        return this.permissionManager.hasPermission((User)user, Permission.VIEW, PermissionManager.TARGET_APPLICATION);
    }

    public ConfluenceUser getAnyUserWhoCanViewPage(AbstractPage page) {
        ContentPermissionSet permissions;
        ConfluenceUser user = page.getCreator();
        if (page.hasContentPermissions() && (user = this.getAnyPermittedUser(permissions = page.getContentPermissionSet("View"))) == null) {
            permissions = page.getContentPermissionSet("Edit");
            user = this.getAnyPermittedUser(permissions);
        }
        return user;
    }

    private ConfluenceUser getAnyPermittedUser(ContentPermissionSet permissions) {
        ConfluenceUser user = null;
        if (permissions != null) {
            List userKeys = permissions.getUserKeys();
            if (!userKeys.isEmpty()) {
                user = this.userAccessor.getUserByKey((UserKey)userKeys.get(0));
            }
            if (user == null) {
                List groupNames = permissions.getGroupNames();
                for (String groupName : groupNames) {
                    Iterable users;
                    Iterator iterator;
                    Group group = this.userAccessor.getGroup(groupName);
                    if (group == null || !(iterator = (users = this.userAccessor.getMembers(group)).iterator()).hasNext()) continue;
                    return (ConfluenceUser)iterator.next();
                }
            }
        }
        return user;
    }

    private boolean hasViewPermission(ContentEntityObject page, ConfluenceUser user) {
        return this.permissionManager.hasPermission((User)user, Permission.VIEW, (Object)page);
    }

    private boolean currentUserHasEditPermission(ContentEntityObject page) {
        return page != null && page.isLatestVersion() && this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.EDIT, (Object)page);
    }
}

