/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.manager;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.service.PredefinedSearchBuilder;
import com.atlassian.confluence.search.service.SearchQueryParameters;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.sort.TitleSort;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.HtmlUtil;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuestionCategory;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizQuestionMap;
import com.stiltsoft.confluence.quiz.ao.service.quiz.QuestionCategoryService;
import com.stiltsoft.confluence.quiz.ao.service.quiz.QuizQuestionMapService;
import com.stiltsoft.confluence.quiz.entity.quiz.question.StructuredQuestions;
import com.stiltsoft.confluence.quiz.manager.ConfluencePermissionHelper;
import com.stiltsoft.confluence.quiz.utils.Labels;
import com.stiltsoft.confluence.quiz.utils.search.SearchQueryBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceContentSearcher {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceContentSearcher.class);
    private static final Set<ContentTypeEnum> CONTENT_TYPES = new HashSet<ContentTypeEnum>(Arrays.asList(ContentTypeEnum.PAGE, ContentTypeEnum.BLOG));
    private static final int OFFSET_ZERO = 0;
    private static final int LIMIT = 5000;
    private final SearchManager searchManager;
    private final QuizQuestionMapService quizQuestionMapService;
    private final PageManager pageManager;
    private final ConfluencePermissionHelper confluencePermissionHelper;
    private final QuestionCategoryService categoryService;
    private final SettingsManager settingsManager;
    private final LabelManager labelManager;
    private final PredefinedSearchBuilder predefinedSearchBuilder;

    public ConfluenceContentSearcher(SearchManager searchManager, QuizQuestionMapService quizQuestionMapService, PageManager pageManager, ConfluencePermissionHelper confluencePermissionHelper, QuestionCategoryService categoryService, SettingsManager settingsManager, LabelManager labelManager, PredefinedSearchBuilder predefinedSearchBuilder) {
        this.searchManager = searchManager;
        this.quizQuestionMapService = quizQuestionMapService;
        this.pageManager = pageManager;
        this.confluencePermissionHelper = confluencePermissionHelper;
        this.categoryService = categoryService;
        this.settingsManager = settingsManager;
        this.labelManager = labelManager;
        this.predefinedSearchBuilder = predefinedSearchBuilder;
    }

    public List<AbstractPage> findPages(String title, int limit, List<Long> restrictedIds) {
        List labels;
        if (title.trim().isEmpty()) {
            return Collections.emptyList();
        }
        AbstractPage page = this.getPageFromURL(title, restrictedIds);
        if (!(page == null || (labels = page.getLabels()).contains(this.labelManager.getLabel(Labels.course.toString())) || labels.contains(this.labelManager.getLabel(Labels.question.toString())) || labels.contains(this.labelManager.getLabel(Labels.quiz.toString())))) {
            return Collections.singletonList(page);
        }
        SearchQueryBuilder builder = new SearchQueryBuilder();
        builder.setTitle(title).and().not().startGroup().setLabel(Labels.course.toString()).or().setLabel(Labels.question.toString()).or().setLabel(Labels.quiz.toString()).endGroup();
        return this.searchWithoutRestricted(builder.build(), 0, limit, restrictedIds);
    }

    public List<AbstractPage> findQuizzes(long questionId) {
        ArrayList<AbstractPage> quizzes = new ArrayList<AbstractPage>();
        for (QuizQuestionMap map : this.quizQuestionMapService.getQuizzes(questionId)) {
            AbstractPage page = this.pageManager.getAbstractPage(map.getQuizId().longValue());
            if (page == null) {
                this.quizQuestionMapService.remove(map.getQuizId(), map.getQuestionId());
                continue;
            }
            if (page.isDeleted()) continue;
            quizzes.add(page);
        }
        return quizzes;
    }

    public List<AbstractPage> findQuizzes(String title, int limit) {
        return this.findQuizzes(title, limit, 0, new ArrayList<Long>());
    }

    public List<AbstractPage> findQuizzes(String title, int limit, List<Long> restrictedIds) {
        return this.findQuizzes(title, limit, 0, restrictedIds);
    }

    public List<AbstractPage> findAllQuizzes(int limit, int offset) {
        return this.findContentV2("", limit, offset, Collections.singletonList(Labels.quiz.toString()), Collections.singletonList("quiz-settings"), new ArrayList<Long>());
    }

    public StructuredQuestions findStructuredQuestions(long id, ConfluenceUser user) {
        StructuredQuestions structuredQuestions = new StructuredQuestions();
        for (QuestionCategory category : this.categoryService.getQuestionCategories(id)) {
            structuredQuestions.addCategory(category);
            for (QuizQuestionMap map : category.getQuizQuestionMap()) {
                AbstractPage page = this.pageManager.getAbstractPage(map.getQuestionId().longValue());
                if (page == null) {
                    this.quizQuestionMapService.remove(map.getQuizId(), map.getQuestionId());
                    continue;
                }
                if (page.isDeleted() || !this.confluencePermissionHelper.canView((ContentEntityObject)page, user)) continue;
                structuredQuestions.addQuestion(category, page);
            }
        }
        return structuredQuestions;
    }

    public StructuredQuestions findStructuredQuestions(List<String> labels, String spaceKey) {
        return new StructuredQuestions(this.findQuestions(labels, spaceKey));
    }

    public List<AbstractPage> findStructuredQuestions(String title, int limit, List<Long> restrictedIds) {
        return this.findStructuredQuestions(title, limit, 0, restrictedIds);
    }

    public List<AbstractPage> findQuestions(List<String> labels, String spaceKey) {
        SearchQueryBuilder builder = new SearchQueryBuilder();
        if (!labels.isEmpty()) {
            builder.orLabelsGroup(labels).and();
        }
        builder.setLabel(Labels.question.toString()).and().setMacro("quiz-answers");
        if (spaceKey != null) {
            builder.and().setSpace(spaceKey);
        }
        SearchQueryParameters searchQueryParameters = this.getSearchParams(builder.build());
        return this.searchV2(searchQueryParameters, 0, 5000);
    }

    public List<AbstractPage> findCourses(String title, int limit) {
        AbstractPage page = this.getPageFromURL(title, new ArrayList<Long>());
        if (page != null && page.getLabels().contains(this.labelManager.getLabel(Labels.course.toString())) && page.getBodyAsString().contains("ac:name=\"course\"")) {
            return Collections.singletonList(page);
        }
        return this.findContentV2(title, limit, 0, Collections.singletonList(Labels.course.toString()), Collections.singletonList("course"), new ArrayList<Long>());
    }

    private List<AbstractPage> findQuizzes(String title, int limit, int offset, List<Long> restrictedIds) {
        AbstractPage page = this.getPageFromURL(title, restrictedIds);
        if (page != null && page.getLabels().contains(this.labelManager.getLabel(Labels.quiz.toString())) && page.getBodyAsString().contains("ac:name=\"share-quiz\"") && page.getBodyAsString().contains("ac:name=\"quiz-settings\"")) {
            return Collections.singletonList(page);
        }
        return this.findContentV2(title, limit, offset, Collections.singletonList(Labels.quiz.toString()), Collections.singletonList("quiz-settings"), restrictedIds);
    }

    private List<AbstractPage> findStructuredQuestions(String title, int limit, int offset, List<Long> restrictedIds) {
        AbstractPage page = this.getPageFromURL(title, restrictedIds);
        if (page != null && page.getLabels().contains(this.labelManager.getLabel(Labels.question.toString())) && page.getBodyAsString().contains("ac:name=\"quiz-answers\"")) {
            return Collections.singletonList(page);
        }
        return this.findContentV2(title, limit, offset, Collections.singletonList(Labels.question.toString()), Collections.singletonList("quiz-answers"), restrictedIds);
    }

    private List<AbstractPage> findContentV2(String title, int limit, int offset, List<String> labels, List<String> macros, List<Long> restrictedIds) {
        SearchQueryBuilder builder = new SearchQueryBuilder();
        if (!labels.isEmpty()) {
            builder.orLabelsGroup(labels);
        }
        if (!macros.isEmpty()) {
            builder.and().orMacrosGroup(macros);
        }
        if (!title.trim().isEmpty()) {
            builder.and().startGroup().setTitle(title).endGroup();
        }
        return this.searchWithoutRestricted(builder.build(), offset, limit, restrictedIds);
    }

    private List<AbstractPage> filterSearchables(List<Searchable> searchables, List<Long> restrictedIds) {
        ArrayList<AbstractPage> cleanedResult = new ArrayList<AbstractPage>();
        for (Searchable searchable : searchables) {
            if (restrictedIds.contains(searchable.getId())) continue;
            cleanedResult.add((AbstractPage)searchable);
        }
        return cleanedResult;
    }

    private List<AbstractPage> searchWithoutRestricted(String query, int offset, int limit, List<Long> restrictedIds) {
        SearchQueryParameters searchParams = this.getSearchParams(query);
        List<Searchable> searchables = this.searchV2(searchParams, offset, limit);
        if (restrictedIds.isEmpty()) {
            return searchables;
        }
        ArrayList<AbstractPage> cleanedResult = new ArrayList<AbstractPage>(this.filterSearchables(searchables, restrictedIds));
        int updatedOffset = offset;
        while (cleanedResult.size() < limit && searchables.size() == limit) {
            searchables = this.searchV2(searchParams, updatedOffset += searchables.size(), limit);
            cleanedResult.addAll(this.filterSearchables(searchables, restrictedIds));
        }
        return cleanedResult;
    }

    private List<Searchable> searchV2(SearchQueryParameters params, int offset, int limit) {
        try {
            return this.searchManager.searchEntities(this.predefinedSearchBuilder.buildSiteSearch(params, offset, limit), SearchManager.EntityVersionPolicy.INDEXED_VERSION);
        }
        catch (Exception e) {
            log.error("Unable to execute content search query: ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private AbstractPage getPageFromURL(String url, List<Long> restrictedIds) {
        if (url.startsWith(this.settingsManager.getGlobalSettings().getBaseUrl())) {
            Page page = null;
            if (url.contains("/pages/viewpage.action?pageId=")) {
                long id = Long.parseLong(url.split("/pages/viewpage\\.action\\?pageId=")[1].split("&")[0].split("#")[0]);
                if (restrictedIds.contains(id)) {
                    return null;
                }
                page = this.pageManager.getPage(id);
            } else {
                String pageTitle;
                String spaceNTitle = url.split("/display/")[1];
                String spaceKey = spaceNTitle.split("/")[0];
                page = this.pageManager.getPage(spaceKey, pageTitle = HtmlUtil.urlDecode((String)spaceNTitle.split("/")[1].split("\\?")[0].split("#")[0]));
                if (page == null || restrictedIds.contains(page.getId())) {
                    return null;
                }
            }
            if (this.confluencePermissionHelper.canView((ContentEntityObject)page)) {
                return page;
            }
        }
        return null;
    }

    private SearchQueryParameters getSearchParams(String query) {
        SearchQueryParameters searchQueryParameters = new SearchQueryParameters();
        searchQueryParameters.setQuery(query);
        searchQueryParameters.setContentTypes(CONTENT_TYPES);
        searchQueryParameters.setSort((SearchSort)TitleSort.ASCENDING);
        return searchQueryParameters;
    }
}

