/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.manager;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import com.stiltsoft.confluence.quiz.ao.entity.UserEntity;
import com.stiltsoft.confluence.quiz.ao.entity.settings.AbstractPermission;
import com.stiltsoft.confluence.quiz.ao.entity.settings.GroupPermission;
import com.stiltsoft.confluence.quiz.ao.service.settings.CQPermissionService;
import com.stiltsoft.confluence.quiz.entity.MailParams;
import com.stiltsoft.confluence.quiz.manager.ConfluenceContentSearcher;
import com.stiltsoft.confluence.quiz.manager.ConfluencePermissionHelper;
import com.stiltsoft.confluence.quiz.manager.UserEntityService;

public class CQPermissionHelper {
    private UserAccessor userAccessor;
    private UserEntityService userEntityService;
    private CQPermissionService cqPermissionService;
    private ConfluencePermissionHelper confluencePermissionHelper;
    private ConfluenceContentSearcher confluenceContentSearcher;

    public CQPermissionHelper(UserAccessor userAccessor, UserEntityService userEntityService, CQPermissionService cqPermissionService, ConfluencePermissionHelper confluencePermissionHelper, ConfluenceContentSearcher confluenceContentSearcher) {
        this.userAccessor = userAccessor;
        this.userEntityService = userEntityService;
        this.cqPermissionService = cqPermissionService;
        this.confluencePermissionHelper = confluencePermissionHelper;
        this.confluenceContentSearcher = confluenceContentSearcher;
    }

    public boolean isUserAuthorized(MailParams mp) {
        boolean isUserValid = this.userEntityService.getUserId(mp.getKey()) == mp.getUid().intValue();
        return isUserValid && this.isUserAuthorized(this.userEntityService.getUser(mp.getUid()), mp.getKey());
    }

    public boolean isLearningAdministrator() {
        return this.hasGlobalPermission(AuthenticatedUserThreadLocal.get());
    }

    public boolean isLearningAdministrator(ConfluenceUser user) {
        return this.hasGlobalPermission(user);
    }

    public boolean isUserHasAccessToCQEntities() {
        boolean hasAccess = false;
        if (!this.confluenceContentSearcher.findQuizzes("", 1).isEmpty()) {
            hasAccess = true;
        } else if (!this.confluenceContentSearcher.findCourses("", 1).isEmpty()) {
            hasAccess = true;
        }
        return hasAccess;
    }

    private boolean hasGlobalPermission(ConfluenceUser user) {
        if (user == null) {
            return false;
        }
        if (this.cqPermissionService.hasUserPermission(user.getKey().getStringValue(), AbstractPermission.CREATE)) {
            return true;
        }
        for (GroupPermission permission : this.cqPermissionService.getGroupPermissions(AbstractPermission.CREATE)) {
            if (!this.userAccessor.hasMembership(this.userAccessor.getGroup(permission.getGroup()), (User)user)) continue;
            return true;
        }
        return false;
    }

    private boolean isUserAuthorized(UserEntity userEntity, String userKey) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            if (userEntity.getExternal().booleanValue()) {
                return true;
            }
            return !this.confluencePermissionHelper.canUseConfluence(userEntity);
        }
        return userEntity.getExternal() == false && user.getKey().getStringValue().equals(userKey);
    }
}

