/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.manager;

import com.atlassian.confluence.plugins.createcontent.rest.BlueprintWebItemService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.i18n.DocumentationBeanFactory;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintManager {
    private static final Logger log = LoggerFactory.getLogger(BlueprintManager.class);
    private SpaceManager spaceManager;
    private BlueprintWebItemService blueprintWebItemService;
    private I18NBeanFactory i18NBeanFactory;
    private DocumentationBeanFactory documentationBeanFactory;

    public BlueprintManager(SpaceManager spaceManager, BlueprintWebItemService blueprintWebItemService, I18NBeanFactory i18NBeanFactory, DocumentationBeanFactory documentationBeanFactory) {
        this.spaceManager = spaceManager;
        this.blueprintWebItemService = blueprintWebItemService;
        this.i18NBeanFactory = i18NBeanFactory;
        this.documentationBeanFactory = documentationBeanFactory;
    }

    public String getBlueprintId(String blueprintKey, String spaceKey) {
        try {
            Space space = this.spaceManager.getSpace(spaceKey);
            List entities = this.blueprintWebItemService.getCreateContentWebItems(space, this.i18NBeanFactory.getI18NBean(), this.documentationBeanFactory.getDocumentationBean(), AuthenticatedUserThreadLocal.get());
            for (Object entity : entities) {
                if (!blueprintKey.equals(entity.getClass().getMethod("getBlueprintModuleCompleteKey", new Class[0]).invoke(entity, new Object[0]))) continue;
                return entity.getClass().getMethod("getContentBlueprintId", new Class[0]).invoke(entity, new Object[0]).toString();
            }
        }
        catch (Exception e) {
            log.error("Failed to get blueprint id", (Throwable)e);
        }
        return null;
    }
}

