/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.mail;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DataSourceFactory;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.mail.template.PreRenderedMailNotificationQueueItem;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultUser;
import com.stiltsoft.confluence.quiz.ao.entity.UserEntity;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseStateEntity;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizStateEntity;
import com.stiltsoft.confluence.quiz.ao.service.quiz.QuizService;
import com.stiltsoft.confluence.quiz.entity.DueDateChanges;
import com.stiltsoft.confluence.quiz.entity.MailParams;
import com.stiltsoft.confluence.quiz.entity.course.CourseEnrollWrapper;
import com.stiltsoft.confluence.quiz.entity.quiz.QuizFinishedStatus;
import com.stiltsoft.confluence.quiz.entity.quiz.QuizParams;
import com.stiltsoft.confluence.quiz.entity.quiz.answer.Answer;
import com.stiltsoft.confluence.quiz.manager.UserEntityService;
import com.stiltsoft.confluence.quiz.utils.QuizEncrypter;
import com.stiltsoft.confluence.quiz.utils.QuizSettingsNumberHelper;
import java.util.Map;
import javax.activation.DataSource;

public class MailSender {
    private MultiQueueTaskManager taskManager;
    private I18NBeanFactory i18NBeanFactory;
    private LocaleManager localeManager;
    private DataSourceFactory dataSourceFactory;
    private WikiStyleRenderer wikiStyleRenderer;
    private QuizService quizService;
    private UserEntityService userEntityService;
    private UserAccessor userAccessor;

    public MailSender(MultiQueueTaskManager taskManager, I18NBeanFactory i18NBeanFactory, LocaleManager localeManager, WikiStyleRenderer wikiStyleRenderer, QuizService quizService, UserEntityService userEntityService, UserAccessor userAccessor) {
        this.taskManager = taskManager;
        this.i18NBeanFactory = i18NBeanFactory;
        this.localeManager = localeManager;
        this.userEntityService = userEntityService;
        this.userAccessor = userAccessor;
        this.dataSourceFactory = (DataSourceFactory)ContainerManager.getComponent((String)"dataSourceFactory");
        this.wikiStyleRenderer = wikiStyleRenderer;
        this.quizService = quizService;
    }

    public void send(String email, String userKey, Page page, int userId, ConfluenceUser author, int authorId, String text, int recordId, boolean isTake, String dueDate) throws Exception {
        if (email == null) {
            return;
        }
        Map context = MacroUtils.defaultVelocityContext();
        I18NBean i18n = this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)author));
        context.put("param", GeneralUtil.urlEncode((String)QuizEncrypter.encrypt(new MailParams(page.getId(), userId, authorId, userKey, recordId))));
        context.put("author", author);
        context.put("page", page);
        context.put("pageContext", new PageContext((ContentEntityObject)page));
        context.put("text", text);
        context.put("isTake", isTake);
        context.put("dueDate", dueDate);
        context.put("i18n", i18n);
        context.put("wikiStyleRenderer", this.wikiStyleRenderer);
        DataSource avatar = this.dataSourceFactory.getAvatar((User)author);
        context.put("avatar", avatar.getName());
        String subject = i18n.getText("quiz.mail.test.title") + " " + page.getTitle();
        PreRenderedMailNotificationQueueItem item = PreRenderedMailNotificationQueueItem.with((User)new DefaultUser("", "", email), (String)"quiz-invite-mail.vm", (String)subject).andContext(context).andRelatedBodyPart(avatar).andSender((User)author).andReplyTo(author.getEmail()).build();
        item.render();
        this.taskManager.addTask("mail", (Task)item);
    }

    public void sendAttemptsAdded(QuizStateEntity entity, Page page, ConfluenceUser author, int attempts) throws Exception {
        UserEntity userEntity = this.userEntityService.getUser(entity.getUserId());
        String email = this.getEmail(userEntity, this.getConfluenceUser(userEntity));
        if (email == null) {
            return;
        }
        Map context = MacroUtils.defaultVelocityContext();
        I18NBean i18n = this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)author));
        context.put("param", GeneralUtil.urlEncode((String)QuizEncrypter.encrypt(new MailParams(page.getId(), entity.getUserId(), entity.getAuthor(), userEntity.getKey(), this.getSessionId(entity.getSessionId(), entity.getID())))));
        context.put("author", author);
        context.put("attempts", attempts > 2000000000 ? i18n.getText("quiz.mail.test.added-attempts.unlim") : Integer.valueOf(attempts));
        context.put("page", page);
        context.put("pageContext", new PageContext((ContentEntityObject)page));
        context.put("i18n", i18n);
        context.put("wikiStyleRenderer", this.wikiStyleRenderer);
        DataSource avatar = this.dataSourceFactory.getAvatar((User)author);
        context.put("avatar", avatar.getName());
        String subject = i18n.getText("quiz.mail.test.title") + " " + page.getTitle();
        PreRenderedMailNotificationQueueItem item = PreRenderedMailNotificationQueueItem.with((User)new DefaultUser("", "", email), (String)"attempts-added.vm", (String)subject).andContext(context).andRelatedBodyPart(avatar).andSender((User)author).andReplyTo(author.getEmail()).build();
        item.render();
        this.taskManager.addTask("mail", (Task)item);
    }

    public void sendCourseDueDateUpdated(CourseEnrollWrapper courseEnrollWrapper, Page page, ConfluenceUser author, DueDateChanges dueDateChanges) throws Exception {
        this.addDueDateUpdatedMailTask(courseEnrollWrapper.getUserId(), null, courseEnrollWrapper.getID(), courseEnrollWrapper.getAuthor(), page, author, dueDateChanges, "quiz.course.mail.test.title", "course-due-date-updated.vm");
    }

    public void sendDueDateUpdated(QuizStateEntity entity, Page page, ConfluenceUser author, DueDateChanges dueDateChanges) throws Exception {
        this.addDueDateUpdatedMailTask(entity.getUserId(), entity.getSessionId(), entity.getID(), entity.getAuthor(), page, author, dueDateChanges, "quiz.mail.test.title", "due-date-updated.vm");
    }

    public void sendReviewed(String email, String userKey, Page page, ConfluenceUser author, QuizStateEntity entity, int prevReview, Page coursePage, QuizParams params) throws Exception {
        if (email == null) {
            return;
        }
        Map context = MacroUtils.defaultVelocityContext();
        I18NBean i18n = this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)author));
        boolean fromCourse = entity.getCourseId() != null;
        context.put("fromCourse", fromCourse);
        context.put("param", GeneralUtil.urlEncode((String)QuizEncrypter.encrypt(new MailParams(page.getId(), entity.getUserId(), entity.getAuthor(), userKey, entity.getID()))));
        context.put("author", author);
        context.put("page", page);
        context.put("coursePage", coursePage);
        context.put("isRetake", this.quizService.canRetake(entity));
        context.put("prevReview", prevReview);
        context.put("total", entity.getTotal());
        context.put("target", entity.getTarget());
        context.put("correct", entity.getCorrect());
        context.put("showAnswers", params.isShowAnswers() && entity.getAnswers() > 0);
        context.put("percent", QuizSettingsNumberHelper.getLocalizedRate(entity.getCorrect(), entity.getTotal()) + "%");
        context.put("i18n", i18n);
        if (fromCourse) {
            context.put("courseParam", GeneralUtil.urlEncode((String)QuizEncrypter.encrypt(new MailParams(coursePage.getId(), entity.getUserId(), entity.getAuthor(), userKey, entity.getCourseRecord()))));
        }
        DataSource avatar = this.dataSourceFactory.getAvatar((User)author);
        context.put("avatar", avatar.getName());
        String subject = i18n.getText(fromCourse ? "quiz.course.mail.test.title" : "quiz.mail.test.title") + " " + (fromCourse ? coursePage.getTitle() : page.getTitle());
        PreRenderedMailNotificationQueueItem item = PreRenderedMailNotificationQueueItem.with((User)new DefaultUser("", "", email), (String)"reviewed-mail.vm", (String)subject).andContext(context).andRelatedBodyPart(avatar).andSender((User)author).andReplyTo(author.getEmail()).build();
        item.render();
        this.taskManager.addTask("mail", (Task)item);
    }

    public void sendCompleted(String email, String userKey, Page page, QuizStateEntity entity, ConfluenceUser user, ConfluenceUser author, QuizParams params) throws Exception {
        if (email == null) {
            return;
        }
        Map context = MacroUtils.defaultVelocityContext();
        I18NBean i18n = this.i18NBeanFactory.getI18NBean(user != null ? this.localeManager.getLocale((User)user) : this.localeManager.getSiteDefaultLocale());
        context.put("param", GeneralUtil.urlEncode((String)QuizEncrypter.encrypt(new MailParams(page.getId(), entity.getUserId(), entity.getAuthor(), userKey, entity.getID()))));
        context.put("page", page);
        context.put("isRetake", this.quizService.canRetake(entity));
        context.put("total", entity.getTotal());
        context.put("target", entity.getTarget());
        context.put("correct", entity.getCorrect());
        context.put("showAnswers", params.isShowAnswers() && entity.getAnswers() > 0);
        context.put("percent", QuizSettingsNumberHelper.getLocalizedRate(entity.getCorrect(), entity.getTotal()) + "%");
        context.put("i18n", i18n);
        DataSource avatar = this.dataSourceFactory.getAvatar((User)author);
        context.put("avatar", avatar.getName());
        String subject = i18n.getText("quiz.mail.test.title") + " " + page.getTitle();
        PreRenderedMailNotificationQueueItem item = PreRenderedMailNotificationQueueItem.with((User)new DefaultUser("", "", email), (String)"completed-mail.vm", (String)subject).andContext(context).andRelatedBodyPart(avatar).andSender((User)author).andReplyTo(author.getEmail()).build();
        item.render();
        this.taskManager.addTask("mail", (Task)item);
    }

    public void sendReviewedAuthors(String userName, ConfluenceUser reviewer, ConfluenceUser author, Page page, QuizStateEntity entity, int prevReview, Page coursePage) {
        if (author.getEmail() == null) {
            return;
        }
        Map context = MacroUtils.defaultVelocityContext();
        I18NBean i18n = this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)author));
        boolean fromCourse = entity.getCourseId() != null;
        context.put("fromCourse", fromCourse);
        context.put("author", author);
        context.put("reviewer", reviewer);
        context.put("userName", userName);
        context.put("page", page);
        context.put("coursePage", coursePage);
        context.put("userId", entity.getUserId());
        context.put("recordId", entity.getID());
        context.put("attempt", entity.getStartDate());
        context.put("prevReview", prevReview);
        context.put("total", entity.getTotal());
        context.put("target", entity.getTarget());
        context.put("correct", entity.getCorrect());
        context.put("percent", QuizSettingsNumberHelper.getLocalizedRate(entity.getCorrect(), entity.getTotal()));
        context.put("i18n", i18n);
        DataSource avatar = this.dataSourceFactory.getAvatar((User)reviewer);
        context.put("avatar", avatar.getName());
        String subject = i18n.getText(fromCourse ? "quiz.course.mail.test.title" : "quiz.mail.test.title") + " " + (fromCourse ? coursePage.getTitle() : page.getTitle());
        PreRenderedMailNotificationQueueItem item = PreRenderedMailNotificationQueueItem.with((User)author, (String)"reviewed-authors-mail.vm", (String)subject).andContext(context).andRelatedBodyPart(avatar).andSender((User)reviewer).andReplyTo(reviewer.getEmail()).build();
        item.render();
        this.taskManager.addTask("mail", (Task)item);
    }

    public void sendAnsweredAuthors(String userName, String email, ConfluenceUser student, ConfluenceUser author, Page page, int userId, int recordId, long attempt, int total, int target, int correct, QuizFinishedStatus status) {
        if (author.getEmail() == null) {
            return;
        }
        Map context = MacroUtils.defaultVelocityContext();
        I18NBean i18n = this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)author));
        context.put("userName", userName);
        context.put("page", page);
        context.put("userId", userId);
        context.put("recordId", recordId);
        context.put("attempt", attempt);
        context.put("total", total);
        context.put("target", target);
        context.put("correct", correct);
        context.put("status", status);
        context.put("percent", QuizSettingsNumberHelper.getLocalizedRate(correct, total));
        context.put("i18n", i18n);
        String subject = i18n.getText("quiz.mail.test.title") + " " + page.getTitle();
        PreRenderedMailNotificationQueueItem.Builder builder = PreRenderedMailNotificationQueueItem.with((User)author, (String)"answered-mail.vm", (String)subject);
        if (student != null) {
            DataSource avatar = this.dataSourceFactory.getAvatar((User)student);
            context.put("avatar", avatar.getName());
            builder.andRelatedBodyPart(avatar).andSender((User)student).andReplyTo(email);
        }
        PreRenderedMailNotificationQueueItem item = builder.andContext(context).build();
        item.render();
        this.taskManager.addTask("mail", (Task)item);
    }

    public void sendWaitingReviewAuthors(String userName, String email, ConfluenceUser student, ConfluenceUser author, Page quizPage, QuizStateEntity entity, Page coursePage) {
        if (author.getEmail() == null) {
            return;
        }
        Map context = MacroUtils.defaultVelocityContext();
        I18NBean i18n = this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)author));
        boolean fromCourse = entity.getCourseId() != null;
        context.put("userName", userName);
        context.put("page", quizPage);
        context.put("coursePage", coursePage);
        context.put("userId", entity.getUserId());
        context.put("recordId", entity.getID());
        context.put("attempt", entity.getStartDate());
        context.put("review", entity.getReview());
        context.put("fromCourse", fromCourse);
        context.put("i18n", i18n);
        String subject = i18n.getText(fromCourse ? "quiz.course.mail.test.title" : "quiz.mail.test.title") + " " + (fromCourse ? coursePage.getTitle() : quizPage.getTitle());
        PreRenderedMailNotificationQueueItem.Builder builder = PreRenderedMailNotificationQueueItem.with((User)author, (String)"waiting-review-mail.vm", (String)subject);
        if (student != null) {
            DataSource avatar = this.dataSourceFactory.getAvatar((User)student);
            context.put("avatar", avatar.getName());
            builder.andRelatedBodyPart(avatar).andSender((User)student).andReplyTo(email);
        }
        PreRenderedMailNotificationQueueItem item = builder.andContext(context).build();
        item.render();
        this.taskManager.addTask("mail", (Task)item);
    }

    public void sendRemind(Answer answer, ConfluenceUser author, String textHtml, AbstractPage page) {
        String email;
        String string = email = answer.getStudent() == null ? answer.getEmail() : answer.getStudent().getEmail();
        if (email == null) {
            return;
        }
        Map context = MacroUtils.defaultVelocityContext();
        I18NBean i18n = this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)author));
        context.put("param", answer.getUrl());
        context.put("author", author);
        context.put("page", page);
        context.put("textHtml", textHtml);
        context.put("i18n", i18n);
        DataSource avatar = this.dataSourceFactory.getAvatar((User)author);
        context.put("avatar", avatar.getName());
        String subject = i18n.getText("quiz.mail.test.title") + " " + page.getTitle();
        PreRenderedMailNotificationQueueItem item = PreRenderedMailNotificationQueueItem.with((User)new DefaultUser("", "", email), (String)"quiz-remind-mail.vm", (String)subject).andContext(context).andRelatedBodyPart(avatar).andSender((User)author).andReplyTo(author.getEmail()).build();
        item.render();
        this.taskManager.addTask("mail", (Task)item);
    }

    public void sendCourseRemind(CourseStateEntity entity, AbstractPage page, String textHtml) throws Exception {
        ConfluenceUser participant;
        UserEntity participantUserEntity = this.userEntityService.getUser(entity.getUserId());
        String email = this.getEmail(participantUserEntity, participant = this.getConfluenceUser(participantUserEntity));
        if (email == null) {
            return;
        }
        Map context = MacroUtils.defaultVelocityContext();
        I18NBean i18n = this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)participant));
        UserEntity authorUserEntity = this.userEntityService.getUser(entity.getAuthor());
        ConfluenceUser author = this.getConfluenceUser(authorUserEntity);
        context.put("param", GeneralUtil.urlEncode((String)QuizEncrypter.encrypt(new MailParams(page.getId(), entity.getUserId(), entity.getAuthor(), participantUserEntity.getKey(), entity.getID()))));
        context.put("author", author);
        context.put("page", page);
        context.put("textHtml", textHtml);
        context.put("i18n", i18n);
        DataSource avatar = this.dataSourceFactory.getAvatar((User)author);
        context.put("avatar", avatar.getName());
        String subject = i18n.getText("quiz.course.mail.test.title") + " " + page.getTitle();
        PreRenderedMailNotificationQueueItem item = PreRenderedMailNotificationQueueItem.with((User)new DefaultUser("", "", email), (String)"quiz-course-reminder-mail.vm", (String)subject).andContext(context).andRelatedBodyPart(avatar).andSender((User)author).andReplyTo(author == null ? "" : author.getEmail()).build();
        item.render();
        this.taskManager.addTask("mail", (Task)item);
    }

    public void sendCourse(String email, String userKey, AbstractPage page, int userId, ConfluenceUser author, int authorId, String desc, int recordId, String dueDate) throws Exception {
        if (email == null) {
            return;
        }
        Map context = MacroUtils.defaultVelocityContext();
        I18NBean i18n = this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)author));
        context.put("param", GeneralUtil.urlEncode((String)QuizEncrypter.encrypt(new MailParams(page.getId(), userId, authorId, userKey, recordId))));
        context.put("author", author);
        context.put("page", page);
        context.put("pageContext", new PageContext((ContentEntityObject)page));
        context.put("text", desc);
        context.put("i18n", i18n);
        context.put("dueDate", dueDate);
        context.put("wikiStyleRenderer", this.wikiStyleRenderer);
        DataSource avatar = this.dataSourceFactory.getAvatar((User)author);
        context.put("avatar", avatar.getName());
        String subject = i18n.getText("quiz.course.mail.test.title") + " " + page.getTitle();
        PreRenderedMailNotificationQueueItem item = PreRenderedMailNotificationQueueItem.with((User)new DefaultUser("", "", email), (String)"quiz-course-invite-mail.vm", (String)subject).andContext(context).andRelatedBodyPart(avatar).andSender((User)author).andReplyTo(author.getEmail()).build();
        item.render();
        this.taskManager.addTask("mail", (Task)item);
    }

    private void addDueDateUpdatedMailTask(int userId, Integer sessionId, int entityId, int entityAuthor, Page page, ConfluenceUser author, DueDateChanges dueDateChanges, String subjectTitleKey, String templateName) throws Exception {
        UserEntity userEntity = this.userEntityService.getUser(userId);
        String email = this.getEmail(userEntity, this.getConfluenceUser(userEntity));
        if (email == null) {
            return;
        }
        I18NBean i18n = this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)author));
        Map context = MacroUtils.defaultVelocityContext();
        context.put("param", GeneralUtil.urlEncode((String)QuizEncrypter.encrypt(new MailParams(page.getId(), userId, entityAuthor, userEntity.getKey(), this.getSessionId(sessionId, entityId)))));
        context.put("author", author);
        context.put("dueDateChanges", dueDateChanges);
        context.put("page", page);
        context.put("pageContext", new PageContext((ContentEntityObject)page));
        context.put("i18n", i18n);
        context.put("wikiStyleRenderer", this.wikiStyleRenderer);
        DataSource avatar = this.dataSourceFactory.getAvatar((User)author);
        context.put("avatar", avatar.getName());
        String subject = i18n.getText(subjectTitleKey) + " " + page.getTitle();
        PreRenderedMailNotificationQueueItem item = PreRenderedMailNotificationQueueItem.with((User)new DefaultUser("", "", email), (String)templateName, (String)subject).andContext(context).andRelatedBodyPart(avatar).andSender((User)author).andReplyTo(author.getEmail()).build();
        item.render();
        this.taskManager.addTask("mail", (Task)item);
    }

    private int getSessionId(Integer sessionId, Integer id) {
        return sessionId == null ? id : sessionId;
    }

    private ConfluenceUser getConfluenceUser(UserEntity entity) {
        return entity.getExternal() != false ? null : this.userAccessor.getExistingUserByKey(new UserKey(entity.getKey()));
    }

    private String getEmail(UserEntity entity, ConfluenceUser user) {
        return user == null ? entity.getKey() : user.getEmail();
    }
}

