/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.stiltsoft.confluence.quiz.entity.quiz.QuizParams;
import com.stiltsoft.confluence.quiz.macro.QuizzesMacro;
import com.stiltsoft.confluence.quiz.manager.LicenseManager;
import com.stiltsoft.confluence.quiz.manager.QuizMacroManager;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TakeQuizButtonMacro
extends BaseMacro
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(QuizzesMacro.class);
    private LicenseManager licenseManager;
    private QuizMacroManager quizMacroManager;
    private PageManager pageManager;

    public TakeQuizButtonMacro(LicenseManager licenseManager, QuizMacroManager quizMacroManager, PageManager pageManager) {
        this.licenseManager = licenseManager;
        this.quizMacroManager = quizMacroManager;
        this.pageManager = pageManager;
    }

    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException {
        Map velocityContext = MacroUtils.defaultVelocityContext();
        AbstractPage page = this.pageManager.getAbstractPage(Long.parseLong(params.get("quizid")));
        try {
            QuizParams quizParams = this.quizMacroManager.getQuizParams((ContentEntityObject)page);
            velocityContext.put("anonymous", quizParams.isAnonymous());
            velocityContext.put("anonymousConfirmation", quizParams.isAnonymousConfirmation());
        }
        catch (XhtmlException e) {
            log.error("Failed to get quiz params: quizId=" + page.getId(), (Throwable)e);
        }
        velocityContext.put("quiz", params.get("quizid"));
        velocityContext.put("newTab", Boolean.valueOf(params.get("new-tab")));
        velocityContext.put("author", params.get("author"));
        velocityContext.put("licensed", this.licenseManager.isActive());
        velocityContext.put("mobile", "mobile".equals(conversionContext.getOutputDeviceType()));
        return VelocityUtils.getRenderedTemplate((String)"/vm/quiz/settings/take-quiz-btn.vm", (Map)velocityContext);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.ALL;
    }

    public String execute(Map map, String s, RenderContext renderContext) throws MacroException {
        try {
            return this.execute((Map<String, String>)map, s, (ConversionContext)null);
        }
        catch (MacroExecutionException e) {
            throw new MacroException((Throwable)e);
        }
    }
}

