/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.macro;

import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.stiltsoft.confluence.quiz.manager.CQPermissionHelper;
import com.stiltsoft.confluence.quiz.manager.LicenseManager;
import java.util.Map;

public class ShareQuizMacro
extends BaseMacro
implements Macro {
    private AccessModeCompatService accessModeCompatService;
    private LicenseManager licenseManager;
    private CQPermissionHelper cqPermissionHelper;

    public ShareQuizMacro(LicenseManager licenseManager, AccessModeCompatService accessModeCompatService, CQPermissionHelper cqPermissionHelper) {
        this.licenseManager = licenseManager;
        this.accessModeCompatService = accessModeCompatService;
        this.cqPermissionHelper = cqPermissionHelper;
    }

    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException {
        Map velocityContext = MacroUtils.defaultVelocityContext();
        if (!this.cqPermissionHelper.isLearningAdministrator()) {
            return VelocityUtils.getRenderedTemplate((String)"/vm/messages/learning-admin-restriction.vm", (Map)velocityContext);
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        velocityContext.put("licensed", this.licenseManager.isActive());
        velocityContext.put("readOnlyMode", this.accessModeCompatService.isReadOnlyAccessModeEnabled());
        velocityContext.put("quiz", conversionContext.getEntity().getId());
        velocityContext.put("author", user == null ? "" : user.getKey().getStringValue());
        return VelocityUtils.getRenderedTemplate((String)"/vm/quiz/settings/share-quiz.vm", (Map)velocityContext);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.ALL;
    }

    public String execute(Map map, String s, RenderContext renderContext) throws MacroException {
        try {
            return this.execute((Map<String, String>)map, s, (ConversionContext)null);
        }
        catch (MacroExecutionException e) {
            throw new MacroException((Throwable)e);
        }
    }
}

