/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.macro;

import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.stiltsoft.confluence.quiz.entity.quiz.QuizParams;
import com.stiltsoft.confluence.quiz.manager.ConfluenceContentSearcher;
import com.stiltsoft.confluence.quiz.manager.LicenseManager;
import com.stiltsoft.confluence.quiz.manager.QuizMacroManager;
import com.stiltsoft.confluence.quiz.utils.DurationHelper;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuizzesMacro
extends BaseMacro
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(QuizzesMacro.class);
    private PageManager pageManager;
    private QuizMacroManager quizMacroManager;
    private LicenseManager licenseManager;
    private ConfluenceContentSearcher confluenceContentSearcher;
    private AccessModeCompatService accessModeCompatService;

    public QuizzesMacro(PageManager pageManager, QuizMacroManager quizMacroManager, LicenseManager licenseManager, ConfluenceContentSearcher confluenceContentSearcher, AccessModeCompatService accessModeCompatService) {
        this.pageManager = pageManager;
        this.quizMacroManager = quizMacroManager;
        this.licenseManager = licenseManager;
        this.confluenceContentSearcher = confluenceContentSearcher;
        this.accessModeCompatService = accessModeCompatService;
    }

    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException {
        Map velocityContext = MacroUtils.defaultVelocityContext();
        LinkedHashMap<AbstractPage, QuizParams> quizzes = new LinkedHashMap<AbstractPage, QuizParams>();
        for (String id : StringUtils.defaultString((String)params.get("quizzes")).split(",")) {
            QuizParams quizParams;
            AbstractPage page = this.pageManager.getAbstractPage(Long.parseLong(id));
            if (page == null || page.isDeleted()) continue;
            try {
                quizParams = this.quizMacroManager.getQuizParams((ContentEntityObject)page);
                if (quizParams.getCount() == Integer.MAX_VALUE) {
                    List<AbstractPage> searchables = this.confluenceContentSearcher.findStructuredQuestions(page.getId(), page.getCreator()).getQuestions();
                    quizParams.setCount(searchables.size());
                }
            }
            catch (Exception e) {
                quizParams = new QuizParams();
                log.error("Failed to get quiz params: quizId=" + page.getId(), (Throwable)e);
            }
            quizzes.put(page, quizParams);
        }
        velocityContext.put("quizzes", quizzes);
        velocityContext.put("author", params.get("author"));
        velocityContext.put("licensed", this.licenseManager.isActive());
        velocityContext.put("readOnlyMode", this.accessModeCompatService.isReadOnlyAccessModeEnabled());
        velocityContext.put("durationHelper", new DurationHelper());
        velocityContext.put("mobile", "mobile".equals(conversionContext.getOutputDeviceType()));
        return VelocityUtils.getRenderedTemplate((String)"/vm/quiz/report/quizzes.vm", (Map)velocityContext);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.ALL;
    }

    public String execute(Map map, String s, RenderContext renderContext) throws MacroException {
        try {
            return this.execute((Map<String, String>)map, s, (ConversionContext)null);
        }
        catch (MacroExecutionException e) {
            throw new MacroException((Throwable)e);
        }
    }
}

