/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.user.User;
import com.stiltsoft.confluence.quiz.entity.UserRestEntity;
import com.stiltsoft.confluence.quiz.manager.CQPermissionHelper;
import com.stiltsoft.confluence.quiz.manager.ConfluencePermissionHelper;
import com.stiltsoft.confluence.quiz.utils.DueDateHelper;
import com.stiltsoft.confluence.quiz.utils.DurationHelper;
import com.stiltsoft.confluence.quiz.utils.QuizSettingsNumberHelper;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class QuizSettingsMacro
extends BaseMacro
implements Macro {
    public static final String ATTEMPTS = "attempts";
    public static final String DUE_DATE = "due-date";
    public static final String DUE_DAYS = "due-days";
    public static final String ENROLLMENT_REMINDER = "enrollment-reminder";
    public static final String DUE_DATE_REMINDER = "duedate-reminder";
    public static final String QUIZ_SETTINGS = "quiz-settings";
    public static final String EMPTY_STRING = "";
    private ConfluencePermissionHelper confluencePermissionHelper;
    private UserAccessor userAccessor;
    private PageManager pageManager;
    private DueDateHelper dueDateHelper;
    private WikiStyleRenderer wikiStyleRenderer;
    private SoyTemplateRenderer soyTemplateRenderer;
    private CQPermissionHelper cqPermissionHelper;

    public QuizSettingsMacro(ConfluencePermissionHelper confluencePermissionHelper, UserAccessor userAccessor, PageManager pageManager, DueDateHelper dueDateHelper, WikiStyleRenderer wikiStyleRenderer, SoyTemplateRenderer soyTemplateRenderer, CQPermissionHelper cqPermissionHelper) {
        this.confluencePermissionHelper = confluencePermissionHelper;
        this.userAccessor = userAccessor;
        this.pageManager = pageManager;
        this.dueDateHelper = dueDateHelper;
        this.wikiStyleRenderer = wikiStyleRenderer;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.cqPermissionHelper = cqPermissionHelper;
    }

    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException {
        Map velocityContext = MacroUtils.defaultVelocityContext();
        if (!this.cqPermissionHelper.isLearningAdministrator()) {
            return VelocityUtils.getRenderedTemplate((String)"/vm/messages/learning-admin-restriction.vm", (Map)velocityContext);
        }
        String[] keys = StringUtils.defaultString((String)params.get("authors")).split(",");
        ArrayList<UserRestEntity> authors = new ArrayList<UserRestEntity>();
        for (String key : keys) {
            if (key.isEmpty()) continue;
            ConfluenceUser user = this.userAccessor.getUserByKey(new UserKey(key));
            authors.add(new UserRestEntity(key, user.getName(), user.getFullName(), this.userAccessor.getUserProfilePicture((User)user).getDownloadPath()));
        }
        Long dueDate = this.dueDateHelper.getCurrentUserDueDate(StringUtils.defaultString((String)params.get(DUE_DATE)), EMPTY_STRING);
        String userDueDate = this.dueDateHelper.formatDueDate(dueDate);
        int timeLimit = QuizSettingsNumberHelper.getTimeLimit(params.get("timelimit"));
        velocityContext.put("authors", authors);
        velocityContext.put("count", StringUtils.defaultString((String)params.get("count")).trim());
        velocityContext.put("target", StringUtils.defaultString((String)params.get("target")).trim());
        velocityContext.put("timelimit", timeLimit / 1000);
        velocityContext.put("timelimitString", DurationHelper.formatDuration(timeLimit));
        velocityContext.put(ATTEMPTS, StringUtils.defaultString((String)params.get(ATTEMPTS)).trim());
        velocityContext.put("retakeOnFail", Boolean.valueOf(params.get("retake-on-fail")));
        velocityContext.put("dueDate", StringUtils.defaultString((String)params.get(DUE_DATE)).trim());
        velocityContext.put("userDueDate", StringUtils.defaultString((String)userDueDate).trim());
        velocityContext.put("dueDays", StringUtils.defaultString((String)params.get(DUE_DAYS)).trim());
        velocityContext.put("showRes", Boolean.valueOf(params.get("show-res")));
        velocityContext.put("showFeedback", Boolean.valueOf(params.get("show-feedback")));
        velocityContext.put("showAnswers", Boolean.valueOf(params.get("show-answers")));
        velocityContext.put("skip", Boolean.valueOf(params.get("skip")));
        velocityContext.put("resubmit", Boolean.valueOf(params.get("resubmit")));
        velocityContext.put("random", params.get("random") == null ? true : Boolean.valueOf(params.get("random")));
        velocityContext.put("anonymous", Boolean.valueOf(params.get("anonymous")));
        velocityContext.put("disableUserNotification", Boolean.valueOf(params.get("disable-user-notification")));
        velocityContext.put("disableTakeNotification", Boolean.valueOf(params.get("disable-take-notification")));
        velocityContext.put("anonymousConfirmation", Boolean.valueOf(params.get("anonymous-confirmation")));
        velocityContext.put("skipStartPage", Boolean.valueOf(params.get("skip-start-page")));
        velocityContext.put("isEmail", "email".equals(conversionContext.getOutputDeviceType()));
        velocityContext.put("isEditable", this.confluencePermissionHelper.canEdit(conversionContext.getEntity()));
        velocityContext.put("enrollmentReminder", StringUtils.defaultString((String)params.get(ENROLLMENT_REMINDER)).trim());
        velocityContext.put("duedateReminder", StringUtils.defaultString((String)params.get(DUE_DATE_REMINDER)).trim());
        velocityContext.put("soyRenderer", this.soyTemplateRenderer);
        String desc = StringUtils.defaultString((String)params.get("desc"));
        velocityContext.put("desc", desc);
        velocityContext.put("descHtml", this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)conversionContext.getEntity().toPageContext(), desc));
        this.setPage(velocityContext, params, "success");
        this.setPage(velocityContext, params, "fail");
        this.setPage(velocityContext, params, "review");
        this.setPage(velocityContext, params, "start");
        return VelocityUtils.getRenderedTemplate((String)"/vm/quiz/settings/quiz-settings.vm", (Map)velocityContext);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.ALL;
    }

    public String execute(Map map, String s, RenderContext renderContext) throws MacroException {
        try {
            return this.execute((Map<String, String>)map, s, (ConversionContext)null);
        }
        catch (MacroExecutionException e) {
            throw new MacroException((Throwable)e);
        }
    }

    private void setPage(Map<String, Object> velocityContext, Map<String, String> params, String pagePrefix) {
        String pageId = StringUtils.defaultString((String)params.get(pagePrefix + "-page-id"));
        String pageTitle = StringUtils.defaultString((String)params.get(pagePrefix + "-page"));
        if (!pageId.isEmpty()) {
            AbstractPage page = this.pageManager.getAbstractPage(Long.valueOf(pageId).longValue());
            if (page == null || page.isDeleted()) {
                pageId = EMPTY_STRING;
                pageTitle = EMPTY_STRING;
            } else {
                pageTitle = page.getDisplayTitle();
            }
        }
        velocityContext.put(pagePrefix + "Page", pageTitle);
        velocityContext.put(pagePrefix + "PageId", pageId);
    }
}

