/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.stiltsoft.confluence.quiz.entity.quiz.question.QuestionsStats;
import com.stiltsoft.confluence.quiz.manager.CQPermissionHelper;
import com.stiltsoft.confluence.quiz.manager.ConfluencePermissionHelper;
import com.stiltsoft.confluence.quiz.manager.LicenseManager;
import com.stiltsoft.confluence.quiz.manager.QuestionStatsHelper;
import java.util.Map;

public class QuizQuestionsReportMacro
extends BaseMacro
implements Macro {
    private LicenseManager licenseManager;
    private CQPermissionHelper cqPermissionHelper;
    private ConfluencePermissionHelper confluencePermissionHelper;
    private QuestionStatsHelper statsHelper;
    private SoyTemplateRenderer soyTemplateRenderer;

    public QuizQuestionsReportMacro(QuestionStatsHelper statsHelper, LicenseManager licenseManager, CQPermissionHelper cqPermissionHelper, ConfluencePermissionHelper confluencePermissionHelper, SoyTemplateRenderer soyTemplateRenderer) {
        this.statsHelper = statsHelper;
        this.licenseManager = licenseManager;
        this.cqPermissionHelper = cqPermissionHelper;
        this.confluencePermissionHelper = confluencePermissionHelper;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    public String execute(Map<String, String> params, String body, ConversionContext ctx) throws MacroExecutionException {
        Map velocityContext = MacroUtils.defaultVelocityContext();
        if (!this.cqPermissionHelper.isLearningAdministrator()) {
            return VelocityUtils.getRenderedTemplate((String)"/vm/messages/learning-admin-restriction.vm", (Map)velocityContext);
        }
        boolean isIndex = params.get("index") != null;
        QuestionsStats data = this.statsHelper.getStats(ctx.getEntity(), isIndex, ctx.getSpaceKey());
        velocityContext.put("soyRenderer", this.soyTemplateRenderer);
        velocityContext.put("licensed", this.licenseManager.isActive());
        velocityContext.put("data", data);
        velocityContext.put("isIndex", isIndex);
        velocityContext.put("isEditable", this.confluencePermissionHelper.canEdit(ctx));
        velocityContext.put("freeText", "Free text");
        return VelocityUtils.getRenderedTemplate((String)"/vm/quiz/report/quiz-questions-macro.vm", (Map)velocityContext);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.ALL;
    }

    public String execute(Map map, String s, RenderContext renderContext) throws MacroException {
        try {
            return this.execute((Map<String, String>)map, s, (ConversionContext)null);
        }
        catch (MacroExecutionException e) {
            throw new MacroException((Throwable)e);
        }
    }
}

