/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.stiltsoft.confluence.quiz.entity.quiz.answer.AnswersReport;
import com.stiltsoft.confluence.quiz.manager.ConfluencePermissionHelper;
import com.stiltsoft.confluence.quiz.manager.LicenseManager;
import com.stiltsoft.confluence.quiz.manager.QuizAnswersHelper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuizAnswersReportMacro
extends BaseMacro
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(QuizAnswersReportMacro.class);
    private QuizAnswersHelper quizAnswersHelper;
    private ConfluencePermissionHelper confluencePermissionHelper;
    private LicenseManager licenseManager;

    public QuizAnswersReportMacro(QuizAnswersHelper quizAnswersHelper, ConfluencePermissionHelper confluencePermissionHelper, LicenseManager licenseManager) {
        this.quizAnswersHelper = quizAnswersHelper;
        this.confluencePermissionHelper = confluencePermissionHelper;
        this.licenseManager = licenseManager;
    }

    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException {
        Map velocityContext = MacroUtils.defaultVelocityContext();
        ContentEntityObject ceo = conversionContext.getEntity();
        long pagId = ceo.getId();
        AnswersReport report = this.quizAnswersHelper.buildReport(params, ceo);
        boolean isQuizAdministration = report.getQuizIds().contains(pagId);
        velocityContext.put("licensed", this.licenseManager.isActive());
        velocityContext.put("report", report);
        velocityContext.put("viewable", this.confluencePermissionHelper.canView(ceo) && isQuizAdministration);
        velocityContext.put("shouldHideCourseQuizzes", Boolean.valueOf(params.get("hide-from-course")));
        velocityContext.put("editable", this.confluencePermissionHelper.canEdit(ceo) && isQuizAdministration);
        velocityContext.put("freeText", "Free text");
        velocityContext.put("singleChoice", "Single choice");
        velocityContext.put("multipleChoice", "Multiple choice");
        velocityContext.put("isPreview", "preview".equals(conversionContext.getOutputType()));
        velocityContext.put("pageId", pagId);
        velocityContext.put("pageVersion", ceo.getVersion());
        velocityContext.put("export", Boolean.valueOf(params.get("export")) != false || isQuizAdministration && !"3".equals(params.get("v")));
        MacroDefinition macroDefinition = (MacroDefinition)conversionContext.getProperty("macroDefinition");
        velocityContext.put("macroId", macroDefinition.getMacroId().map(MacroId::getId).getOrElse((Object)""));
        return VelocityUtils.getRenderedTemplate((String)"/vm/quiz/report/quiz-answers-report.vm", (Map)velocityContext);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.ALL;
    }

    public String execute(Map map, String s, RenderContext renderContext) throws MacroException {
        try {
            return this.execute((Map<String, String>)map, s, (ConversionContext)null);
        }
        catch (MacroExecutionException e) {
            throw new MacroException((Throwable)e);
        }
    }
}

