/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.stiltsoft.confluence.quiz.manager.BlueprintManager;
import com.stiltsoft.confluence.quiz.manager.CQPermissionHelper;
import com.stiltsoft.confluence.quiz.manager.ConfluencePermissionHelper;
import com.stiltsoft.confluence.quiz.manager.LicenseManager;
import com.stiltsoft.confluence.quiz.manager.QuizMacroManager;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateQuestionMacro
extends BaseMacro
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(CreateQuestionMacro.class);
    private LicenseManager licenseManager;
    private CQPermissionHelper cqPermissionHelper;
    private ConfluencePermissionHelper confluencePermissionHelper;
    private QuizMacroManager quizMacroManager;
    private BlueprintManager blueprintManager;

    public CreateQuestionMacro(LicenseManager licenseManager, CQPermissionHelper cqPermissionHelper, ConfluencePermissionHelper confluencePermissionHelper, QuizMacroManager quizMacroManager, BlueprintManager blueprintManager) {
        this.licenseManager = licenseManager;
        this.cqPermissionHelper = cqPermissionHelper;
        this.confluencePermissionHelper = confluencePermissionHelper;
        this.quizMacroManager = quizMacroManager;
        this.blueprintManager = blueprintManager;
    }

    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException {
        Map velocityContext = MacroUtils.defaultVelocityContext();
        if (!this.cqPermissionHelper.isLearningAdministrator()) {
            return VelocityUtils.getRenderedTemplate((String)"/vm/messages/learning-admin-restriction.vm", (Map)velocityContext);
        }
        velocityContext.put("licensed", this.licenseManager.isActive());
        velocityContext.put("bpId", this.blueprintManager.getBlueprintId("com.stiltsoft.confluence.quiz:question-blueprint", conversionContext.getSpaceKey()));
        velocityContext.put("spaceKey", conversionContext.getSpaceKey());
        velocityContext.put("isEmail", "email".equals(conversionContext.getOutputDeviceType()));
        velocityContext.put("isEditable", this.confluencePermissionHelper.canEdit(conversionContext.getEntity()));
        velocityContext.put("quizId", conversionContext.getEntity().getId());
        try {
            velocityContext.put("isIndex", Boolean.valueOf(params.get("index")) != false || this.quizMacroManager.getQuizParams(conversionContext.getEntity()).isEmpty());
        }
        catch (XhtmlException e) {
            log.error("Failed to get Quiz settings", (Throwable)e);
        }
        return VelocityUtils.getRenderedTemplate((String)"/vm/quiz/settings/create-question.vm", (Map)velocityContext);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.ALL;
    }

    public String execute(Map map, String s, RenderContext renderContext) throws MacroException {
        try {
            return this.execute((Map<String, String>)map, s, (ConversionContext)null);
        }
        catch (MacroExecutionException e) {
            throw new MacroException((Throwable)e);
        }
    }
}

