/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseStateEntityService;
import com.stiltsoft.confluence.quiz.entity.course.CourseParticipantStats;
import com.stiltsoft.confluence.quiz.manager.CourseReportHelper;
import com.stiltsoft.confluence.quiz.utils.MacroParameterResolver;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CourseResultsReportMacro
extends BaseMacro
implements Macro {
    private static final int LIMIT = 1000;
    private static final int START = 0;
    private CourseReportHelper courseReportHelper;
    private MacroParameterResolver macroParameterResolver;
    private PageManager pageManager;
    private CourseStateEntityService courseStateEntityService;
    private SoyTemplateRenderer soyRenderer;

    public CourseResultsReportMacro(CourseReportHelper courseReportHelper, MacroParameterResolver macroParameterResolver, PageManager pageManager, CourseStateEntityService courseStateEntityService, SoyTemplateRenderer soyTemplateRenderer) {
        this.courseReportHelper = courseReportHelper;
        this.macroParameterResolver = macroParameterResolver;
        this.pageManager = pageManager;
        this.courseStateEntityService = courseStateEntityService;
        this.soyRenderer = soyTemplateRenderer;
    }

    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException {
        Map velocityContext = MacroUtils.defaultVelocityContext();
        List<Long> allCourseIds = this.macroParameterResolver.resolveCoursesIds(params);
        List<AbstractPage> existPages = new ArrayList<AbstractPage>();
        List<CourseParticipantStats> stats = new ArrayList<CourseParticipantStats>();
        if (!allCourseIds.isEmpty()) {
            List<Integer> studentIds;
            existPages = this.getExistPages(allCourseIds);
            List<Long> existCourseIds = this.getPageIds(existPages);
            velocityContext.put("isLimitReport", this.courseStateEntityService.countStates(existCourseIds, studentIds = this.macroParameterResolver.resolveStudentsIds(params)) > 1000);
            stats = this.courseReportHelper.getParticipantStats(existCourseIds, studentIds, 0, 1000);
        }
        Map<Long, String> courseNamesByCourseIds = this.getCourseNamesByCourseIds(existPages);
        stats.sort(this.getComparatorSortByCourseNameAndUserName(courseNamesByCourseIds));
        velocityContext.put("courseNamesByCourseIds", courseNamesByCourseIds);
        velocityContext.put("participantStats", stats);
        velocityContext.put("soyRenderer", this.soyRenderer);
        return VelocityUtils.getRenderedTemplate((String)"/vm/course/course-results-report.vm", (Map)velocityContext);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.ALL;
    }

    public String execute(Map map, String s, RenderContext renderContext) throws MacroException {
        try {
            return this.execute((Map<String, String>)map, s, (ConversionContext)null);
        }
        catch (MacroExecutionException e) {
            throw new MacroException((Throwable)e);
        }
    }

    private List<AbstractPage> getExistPages(List<Long> courseIds) {
        return this.pageManager.getAbstractPages(courseIds).stream().filter(this::isExistPage).collect(Collectors.toList());
    }

    private List<Long> getPageIds(List<AbstractPage> pages) {
        return pages.stream().map(EntityObject::getId).collect(Collectors.toList());
    }

    private Map<Long, String> getCourseNamesByCourseIds(List<AbstractPage> pages) {
        return pages.stream().collect(Collectors.toMap(EntityObject::getId, ContentEntityObject::getTitle));
    }

    private Comparator<CourseParticipantStats> getComparatorSortByCourseNameAndUserName(final Map<Long, String> courseIdCourseNameMap) {
        return new Comparator<CourseParticipantStats>(){

            @Override
            public int compare(CourseParticipantStats first, CourseParticipantStats second) {
                String secondCourseName;
                String firstCourseName = (String)courseIdCourseNameMap.get(first.getCourseId());
                int comparingCourseNames = firstCourseName.compareTo(secondCourseName = (String)courseIdCourseNameMap.get(second.getCourseId()));
                if (comparingCourseNames == 0) {
                    return CourseResultsReportMacro.this.getStudentName(first).compareTo(CourseResultsReportMacro.this.getStudentName(second));
                }
                return comparingCourseNames;
            }
        };
    }

    private String getStudentName(CourseParticipantStats courseParticipantStats) {
        if (courseParticipantStats.getStudent() != null) {
            return courseParticipantStats.getStudent().getName();
        }
        return StringUtils.defaultString((String)courseParticipantStats.getName());
    }

    private boolean isExistPage(AbstractPage page) {
        return page != null && !page.isDeleted();
    }
}

