/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.macro;

import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.Lists;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseModule;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseSection;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseSettings;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseCategoryService;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseModuleService;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseSectionService;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseSettingsService;
import com.stiltsoft.confluence.quiz.ao.service.course.DefaultCourseModuleService;
import com.stiltsoft.confluence.quiz.ao.service.quiz.QuizQuestionMapService;
import com.stiltsoft.confluence.quiz.entity.course.Module;
import com.stiltsoft.confluence.quiz.entity.quiz.QuizParams;
import com.stiltsoft.confluence.quiz.manager.BlueprintManager;
import com.stiltsoft.confluence.quiz.manager.CQPermissionHelper;
import com.stiltsoft.confluence.quiz.manager.ConfluencePermissionHelper;
import com.stiltsoft.confluence.quiz.manager.CourseReportHelper;
import com.stiltsoft.confluence.quiz.manager.LicenseManager;
import com.stiltsoft.confluence.quiz.manager.QuizMacroManager;
import com.stiltsoft.confluence.quiz.utils.DueDateHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CourseMacro
extends BaseMacro
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(CourseMacro.class);
    private CourseSectionService sectionService;
    private LicenseManager licenseManager;
    private PageManager pageManager;
    private CourseSettingsService settingsService;
    private SoyTemplateRenderer soyTemplateRenderer;
    private ConfluencePermissionHelper confluencePermissionHelper;
    private CourseReportHelper reportHelper;
    private AccessModeCompatService accessModeCompatService;
    private QuizQuestionMapService quizQuestionMapService;
    private BlueprintManager blueprintManager;
    private QuizMacroManager quizMacroManager;
    private CourseModuleService moduleService;
    private CourseCategoryService categoryService;
    private DueDateHelper dueDateHelper;
    private CQPermissionHelper cqPermissionHelper;

    public CourseMacro(CourseSectionService sectionService, LicenseManager licenseManager, PageManager pageManager, CourseSettingsService settingsService, SoyTemplateRenderer soyTemplateRenderer, ConfluencePermissionHelper confluencePermissionHelper, CourseReportHelper reportHelper, AccessModeCompatService accessModeCompatService, QuizQuestionMapService quizQuestionMapService, BlueprintManager blueprintManager, CourseModuleService moduleService, QuizMacroManager quizMacroManager, CourseCategoryService categoryService, DueDateHelper dueDateHelper, CQPermissionHelper cqPermissionHelper) {
        this.sectionService = sectionService;
        this.licenseManager = licenseManager;
        this.pageManager = pageManager;
        this.settingsService = settingsService;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.confluencePermissionHelper = confluencePermissionHelper;
        this.reportHelper = reportHelper;
        this.accessModeCompatService = accessModeCompatService;
        this.quizQuestionMapService = quizQuestionMapService;
        this.blueprintManager = blueprintManager;
        this.quizMacroManager = quizMacroManager;
        this.moduleService = moduleService;
        this.categoryService = categoryService;
        this.dueDateHelper = dueDateHelper;
        this.cqPermissionHelper = cqPermissionHelper;
    }

    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException {
        Map ctx = MacroUtils.defaultVelocityContext();
        if (!this.cqPermissionHelper.isLearningAdministrator()) {
            return VelocityUtils.getRenderedTemplate((String)"/vm/messages/learning-admin-restriction.vm", (Map)ctx);
        }
        AbstractPage course = (AbstractPage)conversionContext.getEntity();
        long courseId = course.getId();
        boolean isEmpty = true;
        CourseSection[] sections = this.sectionService.getTx(courseId);
        HashMap moduleMap = new HashMap();
        for (CourseSection section : sections) {
            ArrayList<Module> modules = new ArrayList<Module>();
            for (CourseModule courseModule : section.getCourseModules()) {
                AbstractPage page = this.pageManager.getAbstractPage(courseModule.getModuleId().longValue());
                if (page == null) {
                    this.moduleService.removeTx(courseId, courseModule.getID());
                    continue;
                }
                if (page.isDeleted() || !this.confluencePermissionHelper.canView((ContentEntityObject)page)) continue;
                Module module = new Module(courseModule.getID(), courseModule.getModuleId(), courseModule.getType(), page.getTitle());
                if (module.getType().equals(DefaultCourseModuleService.QUIZ_MODULE)) {
                    module.setEmptyQuiz(this.quizQuestionMapService.getQuestionsCount(module.getPageId()) == 0);
                    if (!module.getEmptyQuiz().booleanValue()) {
                        QuizParams quizParams = null;
                        try {
                            quizParams = this.quizMacroManager.getQuizParams((ContentEntityObject)page);
                            module.setQuizAttempts(quizParams.getAttempts());
                        }
                        catch (XhtmlException e) {
                            log.error("Failed to get number of quiz attempts", (Throwable)e);
                        }
                    }
                }
                modules.add(module);
                isEmpty = false;
            }
            moduleMap.put(section.getID(), modules);
        }
        boolean isPreview = "preview".equals(conversionContext.getOutputType());
        CourseSettings settings = this.settingsService.getOrCreate(courseId);
        Long dueDate = this.dueDateHelper.getCurrentUserDueDate(settings.getDueDate(), "");
        String userDueDate = this.dueDateHelper.formatDueDate(dueDate);
        ctx.put("bpId", this.blueprintManager.getBlueprintId("com.stiltsoft.confluence.quiz:quiz-blueprint", conversionContext.getSpaceKey()));
        ctx.put("settings", settings);
        ctx.put("isEmpty", isEmpty);
        ctx.put("page", course);
        ctx.put("moduleMap", moduleMap);
        ctx.put("sections", sections);
        ctx.put("isLicensed", this.licenseManager.isActive());
        ctx.put("readOnlyMode", this.accessModeCompatService.isReadOnlyAccessModeEnabled());
        ctx.put("isEditable", this.confluencePermissionHelper.canEdit(conversionContext));
        ctx.put("moduleStats", this.reportHelper.getModulesStats(courseId));
        ctx.put("isPreview", isPreview);
        ctx.put("categories", this.categoryService.getCategories());
        ctx.put("selectedCategories", Lists.newArrayList((Object[])settings.getCourseCategories()));
        ctx.put("dueDate", StringUtils.defaultString((String)settings.getDueDate()));
        ctx.put("dueDays", StringUtils.defaultString((String)settings.getDueDays()));
        ctx.put("userDueDate", StringUtils.defaultString((String)userDueDate).trim());
        ctx.put("soyRenderer", this.soyTemplateRenderer);
        return VelocityUtils.getRenderedTemplate((String)"/vm/course/course-macro.vm", (Map)ctx);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.ALL;
    }

    public String execute(Map map, String s, RenderContext renderContext) throws MacroException {
        try {
            return this.execute((Map<String, String>)map, s, (ConversionContext)null);
        }
        catch (MacroExecutionException e) {
            throw new MacroException((Throwable)e);
        }
    }
}

