/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.FormatConverter;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnswersMacro
extends BaseMacro
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(AnswersMacro.class);
    private static final Pattern INPUT = Pattern.compile("<input class=\"quiz-answer\" type=\"radio\" name=\"quiz-answer\" id=\"([0-9a-f]+)\"");
    private static final int INPUT_MATCHER_GROUP = 0;
    private FormatConverter converter;

    public AnswersMacro(FormatConverter converter) {
        this.converter = converter;
    }

    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException {
        Map velocityContext = MacroUtils.defaultVelocityContext();
        String questionType = params.get("type");
        String answers = params.get("answers");
        if ("Free text".equals(questionType)) {
            velocityContext.put("isFreeText", true);
        } else {
            if (conversionContext != null && "preview".equals(conversionContext.getOutputType()) && !body.contains("<input class=\"quiz-answer\"")) {
                for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
                    if (element.getClassName().endsWith(".UnmarshalMarshalFragmentTransformer")) break;
                    if (!element.getClassName().endsWith(".DefaultXhtmlContent")) continue;
                    try {
                        body = this.converter.convertToViewFormat(this.converter.convertToStorageFormat(body, (RenderContext)conversionContext.getPageContext()), (RenderContext)conversionContext.getPageContext());
                    }
                    catch (XhtmlException e) {
                        log.error("Couldn't render answers for preview", (Throwable)e);
                    }
                    break;
                }
            }
            if ("Free text (checked automatically)".equals(questionType)) {
                body = body.replaceAll("<input class=\"quiz-answer\" type=\"radio\".*?>", "");
                velocityContext.put("body", body);
                velocityContext.put("isAutoCheckedFreeText", true);
            } else {
                boolean isCheckbox = "Multiple choice".equals(questionType);
                ArrayList<Integer> correctAnswers = new ArrayList<Integer>();
                if (answers != null && !answers.isEmpty()) {
                    for (String answer : answers.split(",")) {
                        if (!(answer = answer.trim()).matches("\\d+")) continue;
                        correctAnswers.add(Integer.parseInt(answer));
                    }
                } else if (!isCheckbox) {
                    correctAnswers.add(1);
                }
                Matcher matcher = INPUT.matcher(body);
                int i = 1;
                while (matcher.find()) {
                    if (correctAnswers.contains(i)) {
                        body = body.replace(matcher.group(0), matcher.group(0) + " checked=\"checked\"");
                        if (!isCheckbox) break;
                    }
                    ++i;
                }
                if (isCheckbox) {
                    body = body.replace("<input class=\"quiz-answer\" type=\"radio\"", "<input class=\"quiz-answer\" type=\"checkbox\"");
                }
                velocityContext.put("body", body);
                velocityContext.put("isFreeText", false);
            }
        }
        return VelocityUtils.getRenderedTemplate((String)"/vm/quiz/question/answers.vm", (Map)velocityContext);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public boolean hasBody() {
        return true;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.ALL;
    }

    public String execute(Map map, String s, RenderContext renderContext) throws MacroException {
        try {
            return this.execute((Map<String, String>)map, s, (ConversionContext)null);
        }
        catch (MacroExecutionException e) {
            throw new MacroException((Throwable)e);
        }
    }
}

