/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.entity.quiz.question;

import com.atlassian.confluence.pages.AbstractPage;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuestionCategory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class StructuredQuestions {
    private Map<QuestionCategory, List<AbstractPage>> questionCategoryListMap = new LinkedHashMap<QuestionCategory, List<AbstractPage>>();

    public StructuredQuestions() {
    }

    public StructuredQuestions(List<AbstractPage> pages) {
        this();
        this.questionCategoryListMap.put(null, pages);
    }

    public void addCategory(QuestionCategory category) {
        this.questionCategoryListMap.put(category, new ArrayList());
    }

    public void addQuestion(QuestionCategory category, AbstractPage question) {
        this.questionCategoryListMap.get(category).add(question);
    }

    public Set<QuestionCategory> getCategories() {
        return this.questionCategoryListMap.keySet();
    }

    public Map<QuestionCategory, List<AbstractPage>> getQuestionCategoryListMap() {
        return this.questionCategoryListMap;
    }

    public List<AbstractPage> getQuestions(QuestionCategory category) {
        if (category == null) {
            return this.getQuestions();
        }
        return this.questionCategoryListMap.get(category);
    }

    public List<AbstractPage> getQuestions() {
        return this.questionCategoryListMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }
}

