/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.entity.quiz.answer;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.sal.api.message.I18nResolver;
import com.stiltsoft.confluence.quiz.entity.Status;
import com.stiltsoft.confluence.quiz.entity.quiz.answer.Answer;
import com.stiltsoft.confluence.quiz.manager.QuizResultsHelper;
import com.stiltsoft.confluence.quiz.utils.QuizSettingsNumberHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AnswersReport {
    public static final String PARTICIPANT = "Participant";
    public static final String USER_NAME = "User Name";
    public static final String ATTEMPTS = "Attempts";
    public static final String STATUS = "Status";
    public static final String RESULT = "Result";
    public static final String SCORE = "Score";
    public static final String DATE_ENROLLED = "Date Enrolled";
    public static final String DATE_STARTED = "Date Started";
    public static final String DATE_COMPLETED = "Date Completed";
    public static final String TIME_SPENT = "Time Spent";
    public static final String DUE_DATE = "Due Date";
    public static final String SHARED_BY = "Shared By";
    public static final String COURSE = "Course";
    public static final String DELIMITER = ",";
    public static final List<String> DEFAULT_COLUMNS = Arrays.asList("Participant", "Attempts", "Status", "Result", "Score", "Date Started", "Time Spent", "Due Date", "Shared By", "Course");
    private Long pageId;
    private List<Long> quizIds;
    private Map<Long, QuizResultsHelper.Answers> answersByQuizId;
    private Map<Long, AbstractPage> questionPagesByPageId;
    private List<String> columns;

    public AnswersReport(Long pageId, List<Long> quizIds) {
        this.pageId = pageId;
        this.quizIds = quizIds;
        this.answersByQuizId = new LinkedHashMap<Long, QuizResultsHelper.Answers>();
        this.questionPagesByPageId = new HashMap<Long, AbstractPage>();
    }

    public void addAnswers(long quizId, QuizResultsHelper.Answers answers) {
        this.answersByQuizId.put(quizId, answers);
    }

    public void setQuestionPagesMap(Map<Long, AbstractPage> questionPagesByPageId) {
        this.questionPagesByPageId = questionPagesByPageId;
    }

    public Map<Long, AbstractPage> getQuestionPagesMap() {
        return this.questionPagesByPageId;
    }

    public List<Long> getQuizIds() {
        return this.quizIds;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(String columns) {
        this.columns = columns != null ? Arrays.asList(columns.split(DELIMITER)) : DEFAULT_COLUMNS;
    }

    public boolean canRemind() {
        return this.answersByQuizId.values().stream().anyMatch(QuizResultsHelper.Answers::hasIncompleteAnswers);
    }

    public boolean isUsedInCourse() {
        return this.answersByQuizId.values().stream().anyMatch(QuizResultsHelper.Answers::isUsedInCourse);
    }

    public List<Answer> getLatestAnswers() {
        ArrayList<Answer> latestAnswers = new ArrayList<Answer>();
        for (QuizResultsHelper.Answers answer : this.answersByQuizId.values()) {
            ArrayList<Answer> quizAnswers = new ArrayList<Answer>(answer.getAllAnswers());
            Collections.sort(quizAnswers);
            latestAnswers.addAll(quizAnswers);
        }
        return latestAnswers;
    }

    public Map<Integer, List<Answer>> getOldAttempts() {
        HashMap<Integer, List<Answer>> oldAttempts = new HashMap<Integer, List<Answer>>();
        this.answersByQuizId.values().forEach(answers -> oldAttempts.putAll(answers.getOldAttempts()));
        return oldAttempts;
    }

    public List<Answer> getAllAnswers() {
        ArrayList<Answer> answers = new ArrayList<Answer>();
        Map<Integer, List<Answer>> oldAttempts = this.getOldAttempts();
        for (Answer answer : this.getLatestAnswers()) {
            answers.add(answer);
            answers.addAll((Collection<Answer>)oldAttempts.get(answer.getSessionId()));
        }
        return answers;
    }

    public List<String> getHeaders(I18nResolver i18n) {
        ArrayList<String> headers = new ArrayList<String>();
        if (this.shouldShowQuizName()) {
            headers.add(i18n.getText("quiz.create-link.title"));
        }
        Iterator<String> iterator = this.getColumns().iterator();
        while (iterator.hasNext()) {
            String column;
            switch (column = iterator.next()) {
                case "Participant": {
                    headers.add(i18n.getText("quiz.report.student"));
                    break;
                }
                case "User Name": {
                    headers.add(i18n.getText("quiz.report.user-name"));
                    break;
                }
                case "Attempts": {
                    headers.add(i18n.getText("quiz.report.attempts"));
                    break;
                }
                case "Status": {
                    headers.add(i18n.getText("quiz.report.status"));
                    break;
                }
                case "Result": {
                    headers.add(i18n.getText("quiz.report.result"));
                    break;
                }
                case "Score": {
                    headers.add(i18n.getText("quiz.report.score"));
                    break;
                }
                case "Date Enrolled": {
                    headers.add(i18n.getText("quiz.report.enrolled"));
                    break;
                }
                case "Date Started": {
                    headers.add(i18n.getText("quiz.report.started"));
                    break;
                }
                case "Date Completed": {
                    headers.add(i18n.getText("quiz.report.ended"));
                    break;
                }
                case "Time Spent": {
                    headers.add(i18n.getText("quiz.report.duration"));
                    break;
                }
                case "Due Date": {
                    headers.add(i18n.getText("quiz.report.due-date"));
                    break;
                }
                case "Shared By": {
                    headers.add(i18n.getText("quiz.report.author"));
                }
            }
        }
        if (this.shouldShowCourse()) {
            headers.add(i18n.getText("com.stiltsoft.confluence.quiz.course.label"));
        }
        return headers;
    }

    public List<List<String>> getValues(I18nResolver i18n) {
        ArrayList<List<String>> records = new ArrayList<List<String>>();
        boolean showCourse = this.shouldShowCourse();
        for (Answer answer : this.getAllAnswers()) {
            ArrayList<String> record = new ArrayList<String>();
            if (this.shouldShowQuizName()) {
                record.add(answer.getQuizName());
            }
            Iterator<String> iterator = this.getColumns().iterator();
            while (iterator.hasNext()) {
                String column;
                switch (column = iterator.next()) {
                    case "Participant": {
                        if (answer.getStudent() != null) {
                            record.add(answer.getStudent().getFullName());
                            break;
                        }
                        String name = "";
                        if (answer.getName() != null && !answer.getEmail().equals(answer.getName())) {
                            name = answer.getName() + " ";
                        }
                        name = name + answer.getEmail();
                        record.add(name);
                        break;
                    }
                    case "User Name": {
                        if (answer.getStudent() != null) {
                            record.add(answer.getStudent().getName());
                            break;
                        }
                        record.add("");
                        break;
                    }
                    case "Attempts": {
                        String attempt = "";
                        attempt = answer.getTotalAttempts() != null ? answer.getAttemptNumber().toString() : "?";
                        record.add(attempt);
                        break;
                    }
                    case "Status": {
                        String status = "";
                        switch (answer.getStatus()) {
                            case 0: {
                                status = i18n.getText("quiz.report.not-started");
                                break;
                            }
                            case 1: {
                                status = i18n.getText("quiz.report.inprogress");
                                break;
                            }
                            case 4: {
                                status = i18n.getText("quiz.report.overdue");
                                break;
                            }
                            default: {
                                status = answer.isReviewed() ? i18n.getText("quiz.report.finished") : i18n.getText("quiz.report.waiting");
                            }
                        }
                        record.add(status);
                        break;
                    }
                    case "Result": {
                        String result = "";
                        if (answer.isReviewed() && answer.getStatus() > 1 && answer.getStatus() != 4) {
                            if (answer.getScore() >= answer.getTarget()) {
                                result = i18n.getText("quiz.report.success");
                            } else if (answer.getTarget() > answer.getTotal() - answer.getAnswered() + answer.getScore() || answer.getStatus() == 2) {
                                result = i18n.getText("quiz.report.fail");
                            }
                        }
                        record.add(result);
                        break;
                    }
                    case "Score": {
                        String score = "";
                        if (Status.hasProgress(answer) && answer.isReviewed()) {
                            score = QuizSettingsNumberHelper.getLocalizedRateDetails(answer.getScore(), answer.getTotal());
                        }
                        record.add(score);
                        break;
                    }
                    case "Date Enrolled": {
                        record.add(answer.getEnrolled());
                        break;
                    }
                    case "Date Started": {
                        String started = "";
                        if (Status.hasProgress(answer)) {
                            started = answer.getStarted();
                        }
                        record.add(started);
                        break;
                    }
                    case "Date Completed": {
                        if (answer.getStatus() == 2) {
                            record.add(answer.getEnded());
                            break;
                        }
                        record.add("");
                        break;
                    }
                    case "Time Spent": {
                        if (Status.hasProgress(answer)) {
                            record.add(answer.getDuration());
                            break;
                        }
                        record.add("");
                        break;
                    }
                    case "Due Date": {
                        if (answer.getDueDate() != null) {
                            record.add(answer.getDueDate());
                            break;
                        }
                        record.add("");
                        break;
                    }
                    case "Shared By": {
                        record.add(answer.getAuthor().getFullName());
                    }
                }
            }
            if (showCourse) {
                record.add(answer.getCourseName());
            }
            records.add(record);
        }
        return records;
    }

    private boolean shouldShowQuizName() {
        return this.getQuizIds().size() > 1;
    }

    private boolean shouldShowCourse() {
        return this.isUsedInCourse() && this.getQuizIds().contains(this.pageId);
    }
}

