/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.entity.quiz.answer;

import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.ConfluenceUser;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizStateEntity;
import com.stiltsoft.confluence.quiz.entity.quiz.answer.AnswerVariants;
import com.stiltsoft.confluence.quiz.utils.DueDateHelper;
import com.stiltsoft.confluence.quiz.utils.DurationHelper;
import com.stiltsoft.confluence.quiz.utils.QuizSettingsNumberHelper;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class Answer
implements Comparable<Answer> {
    private static final String NO_BREAK_SPACE = "\u00a0";
    private int id;
    private int sessionId;
    private Long quizId;
    private String quizName;
    private AbstractPage quizPage;
    private ConfluenceUser author;
    private ConfluenceUser student;
    private int studentId;
    private String email;
    private String name;
    private int total;
    private int score;
    private int target;
    private int answered;
    private int toReview;
    private Long startedMs;
    private Long endedMs;
    private String enrolled;
    private Long enrolledMs;
    private String started;
    private String ended;
    private String duration;
    private int status;
    private long attempt;
    private int attempts;
    private Integer totalAttempts;
    private Integer attemptNumber;
    private Boolean deleted;
    private Boolean deletedByUser;
    private Boolean completed;
    private String url;
    private Map<Long, AnswerVariants> variants;
    private String dueDate;
    private Long dueDateMs;
    private boolean isOverdue;
    private boolean isUpcoming;
    private boolean isComplete;
    private boolean isRetakeOnFail;
    private Long courseId;
    private String courseName;
    private String allQuestions;

    private Answer() {
    }

    public int getId() {
        return this.id;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public Long getQuizId() {
        return this.quizId;
    }

    public String getQuizName() {
        return this.quizName;
    }

    public AbstractPage getQuizPage() {
        return this.quizPage;
    }

    public ConfluenceUser getAuthor() {
        return this.author;
    }

    public ConfluenceUser getStudent() {
        return this.student;
    }

    public int getStudentId() {
        return this.studentId;
    }

    public String getEmail() {
        return this.email;
    }

    public String getName() {
        return this.name;
    }

    public int getTotal() {
        return this.total;
    }

    public int getScore() {
        return this.score;
    }

    public int getTarget() {
        return this.target;
    }

    public int getAnswered() {
        return this.answered;
    }

    public int getToReview() {
        return this.toReview;
    }

    public Long getStartedMs() {
        return this.startedMs;
    }

    public Long getEndedMs() {
        return this.endedMs;
    }

    public Long getEnrolledMs() {
        return this.enrolledMs;
    }

    public String getEnrolled() {
        return this.enrolled;
    }

    public String getStarted() {
        return this.started;
    }

    public String getEnded() {
        return this.ended;
    }

    public String getDuration() {
        return this.duration;
    }

    public int getStatus() {
        return this.status;
    }

    public long getAttempt() {
        return this.attempt;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public boolean isReviewed() {
        return this.toReview == 0;
    }

    public Integer getTotalAttempts() {
        if (this.totalAttempts != null) {
            return Math.max(this.totalAttempts, this.getAttemptNumber());
        }
        return this.totalAttempts;
    }

    public Integer getAttemptNumber() {
        if (this.attemptNumber != null && (this.status == 0 || this.status == 3 || this.status == 4)) {
            return this.attemptNumber + 1;
        }
        return this.attemptNumber;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public Boolean getDeletedByUser() {
        return this.deletedByUser;
    }

    public Boolean getCompleted() {
        return this.completed;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<Long, AnswerVariants> getVariants() {
        return this.variants;
    }

    public void setVariants(Map<Long, AnswerVariants> variants) {
        this.variants = variants;
    }

    public Long getDueDateMs() {
        return this.dueDateMs;
    }

    public String getDueDate() {
        return this.dueDate;
    }

    public boolean isOverdue() {
        return this.isOverdue;
    }

    public boolean isUpcoming() {
        return this.isUpcoming;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public boolean isRetakeOnFail() {
        return this.isRetakeOnFail;
    }

    public Long getCourseId() {
        return this.courseId;
    }

    public String getCourseName() {
        return this.courseName;
    }

    public String getLocalizedRate() {
        return QuizSettingsNumberHelper.getLocalizedRate(this.score, this.total);
    }

    @Override
    public int compareTo(Answer answer) {
        if (this.attempt < answer.getAttempt()) {
            return 1;
        }
        if (this.attempt > answer.getAttempt()) {
            return -1;
        }
        return answer.getStartedMs().compareTo(this.startedMs);
    }

    public String getAllQuestions() {
        return this.allQuestions;
    }

    public static AnswerBuilder newBuilder() {
        return new AnswerBuilder();
    }

    public static class AnswerBuilder {
        private QuizStateEntity entity;
        private Map<Long, AbstractPage> pageMap;
        private DateFormatter dateFormatter;
        private ConfluenceUser author;
        private ConfluenceUser student;
        private String studentName;
        private String studentEmail;
        private Boolean retakeOnFailEnabled;
        private String url;

        public AnswerBuilder setEntity(QuizStateEntity entity) {
            this.entity = entity;
            return this;
        }

        public AnswerBuilder setPageMap(Map<Long, AbstractPage> pageMap) {
            this.pageMap = pageMap;
            return this;
        }

        public AnswerBuilder setDateFormatter(DateFormatter dateFormatter) {
            this.dateFormatter = dateFormatter;
            return this;
        }

        public AnswerBuilder setAuthor(ConfluenceUser author) {
            this.author = author;
            return this;
        }

        public AnswerBuilder setStudent(ConfluenceUser student) {
            this.student = student;
            return this;
        }

        public AnswerBuilder setStudentName(String studentName) {
            this.studentName = studentName;
            return this;
        }

        public AnswerBuilder setStudentEmail(String studentEmail) {
            this.studentEmail = studentEmail;
            return this;
        }

        public AnswerBuilder setRetakeOnFailEnabled(boolean retakeOnFailEnabled) {
            this.retakeOnFailEnabled = retakeOnFailEnabled;
            return this;
        }

        public AnswerBuilder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Answer build() {
            Objects.requireNonNull(this.entity);
            Answer answer = new Answer();
            answer.quizId = this.entity.getQuizId();
            answer.id = this.entity.getID();
            answer.sessionId = this.entity.getSessionId() == null ? this.entity.getID() : this.entity.getSessionId().intValue();
            answer.courseId = this.entity.getCourseId();
            answer.studentId = this.entity.getUserId();
            answer.email = this.studentEmail;
            answer.name = this.studentName;
            answer.student = this.student;
            answer.author = this.author;
            answer.url = this.url;
            if (this.pageMap != null) {
                answer.quizPage = this.pageMap.get(this.entity.getQuizId());
                answer.quizName = answer.quizPage != null ? answer.quizPage.getDisplayTitle() : "";
                answer.courseName = this.pageMap.get(this.entity.getCourseId()) == null ? "" : this.pageMap.get(this.entity.getCourseId()).getDisplayTitle();
            }
            answer.total = this.entity.getTotal();
            answer.score = this.entity.getCorrect();
            answer.target = this.entity.getTarget();
            answer.answered = this.entity.getAnswers();
            answer.toReview = this.entity.getReview() != null ? this.entity.getReview() : 0;
            answer.attempt = this.entity.getStartDate();
            answer.status = this.entity.getStatus();
            answer.attempts = this.entity.getAttempts() != null ? this.entity.getAttempts() : 0;
            answer.totalAttempts = this.entity.getAttemptsCount();
            answer.attemptNumber = this.entity.getAttemptsCount() == null ? null : Integer.valueOf(this.entity.getAttemptsCount() - answer.getAttempts());
            answer.deleted = Boolean.TRUE.equals(this.entity.getDeleted());
            answer.deletedByUser = Boolean.TRUE.equals(this.entity.getDeletedByUser());
            answer.allQuestions = this.entity.getAllQuestions();
            answer.isRetakeOnFail = Boolean.TRUE.equals(this.retakeOnFailEnabled);
            answer.startedMs = this.entity.getStartDate();
            answer.started = this.dateFormatter.formatDateTime(new Date(this.entity.getStartDate()));
            answer.enrolledMs = this.entity.getEnrolledDate();
            answer.enrolled = this.entity.getEnrolledDate() != null ? this.dateFormatter.formatDateTime(new Date(this.entity.getEnrolledDate())) : Answer.NO_BREAK_SPACE;
            answer.endedMs = this.entity.getStatus() == 2 ? this.entity.getEndDate() : System.currentTimeMillis();
            answer.ended = this.dateFormatter.formatDateTime(new Date(answer.getEndedMs()));
            answer.duration = DurationHelper.formatDuration(answer.getEndedMs() - answer.getStartedMs());
            answer.dueDateMs = this.entity.getDueDate();
            answer.dueDate = this.entity.getDueDate() != null ? this.dateFormatter.format(new Date(this.entity.getDueDate())) : null;
            answer.isOverdue = this.entity.getDueDate() != null && DueDateHelper.isOverdue(this.entity.getDueDate());
            answer.isUpcoming = this.entity.getDueDate() != null && DueDateHelper.isUpcoming(this.entity.getDueDate());
            answer.completed = Boolean.TRUE.equals(this.entity.getCompleted());
            answer.isComplete = answer.isOverdue() || answer.getStatus() != 0 && answer.getStatus() != 1 && (answer.getStatus() != 2 || answer.getAttempts() <= 0 || answer.getScore() >= answer.getTarget() || !answer.isReviewed());
            return answer;
        }
    }
}

