/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.entity.quiz;

import com.google.common.collect.Lists;
import com.stiltsoft.confluence.quiz.utils.DueDateHelper;
import com.stiltsoft.confluence.quiz.utils.NumberHelper;
import com.stiltsoft.confluence.quiz.utils.QuizSettingsNumberHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class QuizParams {
    private List<String> labels;
    private int count;
    private int target;
    private int timeLimit;
    private int attempts;
    private boolean showRes;
    private boolean showFeedback;
    private boolean random;
    private boolean skip;
    private boolean resubmit;
    private String desc;
    private List<String> authorsKeys;
    private Long startPageId;
    private Long successPageId;
    private Long failPageId;
    private Long reviewPageId;
    private List<Long> questionsOrder;
    private boolean anonymous;
    private boolean anonymousConfirmation;
    private boolean skipStartPage;
    private boolean disableUserNotification;
    private boolean isEmpty;
    private boolean disableTakeNotification;
    private Long dueDate;
    private String rawDueDate;
    private String rawDueDays;
    private boolean retakeOnFail;
    private boolean showAnswers;
    private Integer enrollmentReminder;
    private String enrollmentReminderMsg;
    private Integer dueDateReminder;
    private String dueDateReminderMsg;

    public QuizParams() {
        this(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        this.isEmpty = true;
    }

    public QuizParams(String labels, String count, String target, String timeLimit, String attempts, String showRes, String showFeedback, String random, String skip, String desc, String authors, String successPageId, String failPageId, String reviewPageId, String questionsOrder, String anonymous, String skipStartPage, String startPageId, String resubmit, String anonymousConfirmation, String disableUserNotification, String disableTakeNotification, String dueDate, String dueDays, String retakeOnFail, String showAnswers, String enrollmentReminder, String enrollmentReminderMsg, String dueDateReminder, String dueDateReminderMsg) {
        this.labels = labels != null ? Lists.newArrayList((Object[])labels.split(",")) : Lists.newArrayList();
        this.setCount(count);
        this.setTarget(target);
        this.setTimeLimit(timeLimit);
        this.setAttempts(attempts);
        this.setShowRes(showRes);
        this.setShowFeedback(showFeedback);
        this.setSkip(skip);
        this.setResubmit(resubmit);
        this.setRandom(random);
        this.setQuestionsOrder(questionsOrder);
        this.setAnonymous(anonymous);
        this.setAnonymousConfirmation(anonymousConfirmation);
        this.setSkipStartPage(skipStartPage);
        this.setDisableUserNotification(disableUserNotification);
        this.setDisableTakeNotification(disableTakeNotification);
        this.setDueDate(StringUtils.defaultString((String)dueDate), StringUtils.defaultString((String)dueDays));
        this.setDesc(desc);
        this.setEnrollmentReminder(enrollmentReminder);
        this.setDueDateReminder(dueDateReminder);
        this.authorsKeys = Lists.newArrayList((Object[])StringUtils.defaultString((String)authors).split(","));
        this.authorsKeys.remove("");
        this.successPageId = StringUtils.defaultString((String)successPageId).isEmpty() ? null : Long.valueOf(successPageId);
        this.failPageId = StringUtils.defaultString((String)failPageId).isEmpty() ? null : Long.valueOf(failPageId);
        this.reviewPageId = StringUtils.defaultString((String)reviewPageId).isEmpty() ? null : Long.valueOf(reviewPageId);
        this.startPageId = StringUtils.defaultString((String)startPageId).isEmpty() ? null : Long.valueOf(startPageId);
        this.isEmpty = false;
        this.rawDueDate = dueDate;
        this.rawDueDays = dueDays;
        this.retakeOnFail = Boolean.parseBoolean(retakeOnFail);
        this.showAnswers = Boolean.parseBoolean(showAnswers);
        this.enrollmentReminderMsg = StringUtils.defaultString((String)enrollmentReminderMsg);
        this.dueDateReminderMsg = StringUtils.defaultString((String)dueDateReminderMsg);
    }

    public void setCount(String count) {
        this.count = NumberHelper.getValueOrMaxInt(count);
    }

    public void setTarget(String target) {
        this.target = NumberHelper.getValueOrMaxInt(target);
    }

    public void setTimeLimit(String timeLimit) {
        this.timeLimit = QuizSettingsNumberHelper.getTimeLimit(timeLimit);
    }

    public void setAttempts(String attempts) {
        this.attempts = QuizSettingsNumberHelper.getAttempts(attempts);
    }

    public void setShowRes(String showRes) {
        this.showRes = Boolean.parseBoolean(showRes);
    }

    public void setShowFeedback(String showFeedback) {
        this.showFeedback = Boolean.parseBoolean(showFeedback);
    }

    public void setSkip(String skip) {
        this.skip = Boolean.parseBoolean(skip);
    }

    public void setResubmit(String resubmit) {
        this.resubmit = Boolean.parseBoolean(resubmit);
    }

    public void setRandom(String random) {
        this.random = random == null || Boolean.parseBoolean(random);
    }

    public void setAnonymous(String anonymous) {
        this.anonymous = Boolean.parseBoolean(anonymous);
    }

    public void setAnonymousConfirmation(String anonymousConfirmation) {
        this.anonymousConfirmation = Boolean.parseBoolean(anonymousConfirmation);
    }

    public void setSkipStartPage(String skipStartPage) {
        this.skipStartPage = Boolean.parseBoolean(skipStartPage);
    }

    public void setDisableUserNotification(String disableUserNotification) {
        this.disableUserNotification = Boolean.parseBoolean(disableUserNotification);
    }

    public void setDisableTakeNotification(String disableTakeNotification) {
        this.disableTakeNotification = Boolean.parseBoolean(disableTakeNotification);
    }

    public void setQuestionsOrder(String questionsOrder) {
        this.questionsOrder = new ArrayList<Long>();
        for (String id : StringUtils.defaultString((String)questionsOrder).split(",")) {
            if (id.isEmpty()) continue;
            this.questionsOrder.add(Long.valueOf(id));
        }
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setTarget(int target) {
        this.target = target;
    }

    public int getCount() {
        return this.count;
    }

    public int getTarget() {
        return this.target;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public boolean isShowRes() {
        return this.showRes;
    }

    public boolean isShowFeedback() {
        return this.showFeedback;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public boolean isResubmit() {
        return this.resubmit;
    }

    public boolean isRandom() {
        return this.random;
    }

    public void setDesc(String desc) {
        this.desc = StringUtils.defaultString((String)desc);
    }

    public String getDesc() {
        return this.desc;
    }

    public List<String> getAuthorsKeys() {
        return this.authorsKeys;
    }

    public Long getFailPageId() {
        return this.failPageId;
    }

    public Long getReviewPageId() {
        return this.reviewPageId;
    }

    public Long getSuccessPageId() {
        return this.successPageId;
    }

    public Long getStartPageId() {
        return this.startPageId;
    }

    public List<Long> getQuestionsOrder() {
        return this.questionsOrder;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public boolean isAnonymousConfirmation() {
        return this.anonymousConfirmation;
    }

    public boolean isSkipStartPage() {
        return this.skipStartPage;
    }

    public boolean isDisableUserNotification() {
        return this.disableUserNotification;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean isDisableTakeNotification() {
        return this.disableTakeNotification;
    }

    public void setDueDate(String dueDate, String dueDays) {
        this.dueDate = DueDateHelper.parseDueDate(dueDate, dueDays);
    }

    public Long getDueDate() {
        return this.dueDate;
    }

    public String getRawDueDate() {
        return this.rawDueDate;
    }

    public String getRawDueDays() {
        return this.rawDueDays;
    }

    public boolean isRetakeOnFail() {
        return this.retakeOnFail;
    }

    public boolean isShowAnswers() {
        return this.showAnswers;
    }

    public void setEnrollmentReminder(String enrollmentReminder) {
        this.enrollmentReminder = NumberHelper.getValueOrZero(enrollmentReminder);
    }

    public void setDueDateReminder(String dueDateReminder) {
        this.dueDateReminder = QuizSettingsNumberHelper.getDueDateReminder(dueDateReminder);
    }

    public Integer getEnrollmentReminder() {
        return this.enrollmentReminder;
    }

    public String getEnrollmentReminderMsg() {
        return this.enrollmentReminderMsg;
    }

    public Integer getDueDateReminder() {
        return this.dueDateReminder;
    }

    public String getDueDateReminderMsg() {
        return this.dueDateReminderMsg;
    }
}

