/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.entity.quiz;

import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizStateEntity;
import com.stiltsoft.confluence.quiz.utils.QuizSettingsNumberHelper;
import javax.xml.bind.annotation.XmlElement;

public class Quiz {
    @XmlElement(name="id")
    private Integer id;
    @XmlElement(name="status")
    private Integer status;
    @XmlElement(name="startDate")
    private Long startDate;
    @XmlElement(name="studentId")
    private Integer studentId;
    @XmlElement(name="review")
    private Integer review;
    @XmlElement(name="correct")
    private Integer correct;
    @XmlElement(name="target")
    private Integer target;
    @XmlElement(name="total")
    private Integer total;
    @XmlElement(name="answers")
    private Integer answers;
    @XmlElement(name="localizedRate")
    private String localizedRate;
    @XmlElement(name="currentUserCanViewAnswers")
    private boolean currentUserCanViewAnswers;

    public Quiz(QuizStateEntity quizStateEntity, boolean currentUserCanViewAnswers) {
        if (currentUserCanViewAnswers) {
            this.id = quizStateEntity.getID();
            this.startDate = quizStateEntity.getStartDate();
            this.studentId = quizStateEntity.getUserId();
        }
        this.status = quizStateEntity.getStatus();
        this.review = quizStateEntity.getReview();
        this.correct = quizStateEntity.getCorrect();
        this.target = quizStateEntity.getTarget();
        this.total = quizStateEntity.getTotal();
        this.answers = quizStateEntity.getAnswers();
        this.localizedRate = QuizSettingsNumberHelper.getLocalizedRate(this.correct, this.total);
        this.currentUserCanViewAnswers = currentUserCanViewAnswers;
    }

    public Integer getId() {
        return this.id;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Long getStartDate() {
        return this.startDate;
    }

    public Integer getReview() {
        return this.review;
    }

    public Integer getCorrect() {
        return this.correct;
    }

    public Integer getTarget() {
        return this.target;
    }

    public Integer getTotal() {
        return this.total;
    }

    public Integer getAnswers() {
        return this.answers;
    }

    public String getLocalizedRate() {
        return this.localizedRate;
    }

    public Integer getStudentId() {
        return this.studentId;
    }

    public boolean isCurrentUserCanViewAnswers() {
        return this.currentUserCanViewAnswers;
    }
}

