/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.entity.course;

import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.util.GeneralUtil;
import com.google.common.base.Joiner;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseCategory;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseModule;
import com.stiltsoft.confluence.quiz.entity.MailParams;
import com.stiltsoft.confluence.quiz.entity.course.CourseEnrollWrapper;
import com.stiltsoft.confluence.quiz.entity.course.CourseMetadata;
import com.stiltsoft.confluence.quiz.entity.course.DueDateStatus;
import com.stiltsoft.confluence.quiz.utils.QuizEncrypter;
import com.stiltsoft.confluence.quiz.utils.QuizSettingsNumberHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class UserCourse
implements Comparable<UserCourse> {
    private int id;
    private int status;
    private String localizedRate;
    private String url;
    private List<CourseCategory> categories;
    private String dueDate;
    private int dueDateStatus;
    private CourseMetadata courseMetadata;
    private double rate;

    private UserCourse() {
    }

    public int getId() {
        return this.id;
    }

    public int getStatus() {
        return this.status;
    }

    public String getLocalizedRate() {
        return this.localizedRate;
    }

    public double getRate() {
        return this.rate;
    }

    public String getUrl() {
        return this.url;
    }

    public List<CourseCategory> getCategories() {
        return this.categories != null ? this.categories : Collections.emptyList();
    }

    public String getCategoriesString() {
        if (this.categories == null) {
            return "";
        }
        ArrayList<String> titles = new ArrayList<String>();
        for (CourseCategory category : this.categories) {
            titles.add(category.getName());
        }
        return Joiner.on((String)", ").join(titles);
    }

    public String getDueDate() {
        return this.dueDate;
    }

    public int getDueDateStatus() {
        return this.dueDateStatus;
    }

    public CourseMetadata getCourseMetadata() {
        return this.courseMetadata;
    }

    @Override
    public int compareTo(UserCourse course) {
        return this.courseMetadata.getTitle().compareTo(course.courseMetadata.getTitle());
    }

    public static UserCourseBuilder newBuilder() {
        return new UserCourseBuilder();
    }

    public static class UserCourseBuilder {
        private DateFormatter dateFormatter;
        private CourseMetadata courseMetadata;
        private String userKey;
        private CourseModule[] courseModules;
        private CourseEnrollWrapper courseEnrollWrapper;
        private List<CourseCategory> courseCategories;

        public UserCourseBuilder setDateFormatter(DateFormatter dateFormatter) {
            this.dateFormatter = dateFormatter;
            return this;
        }

        public UserCourseBuilder setCourseCategories(CourseCategory[] courseCategories) {
            this.courseCategories = Arrays.asList(courseCategories);
            return this;
        }

        public UserCourseBuilder setUserKey(String userKey) {
            this.userKey = userKey;
            return this;
        }

        public UserCourseBuilder setCourseEnrollWrapper(CourseEnrollWrapper courseEnrollWrapper) {
            this.courseEnrollWrapper = courseEnrollWrapper;
            return this;
        }

        public UserCourseBuilder setCourseMetadata(CourseMetadata courseMetadata) {
            this.courseMetadata = courseMetadata;
            return this;
        }

        public UserCourseBuilder setCourseModules(CourseModule[] courseModules) {
            this.courseModules = courseModules;
            return this;
        }

        public UserCourse build() throws Exception {
            Objects.requireNonNull(this.dateFormatter);
            Objects.requireNonNull(this.courseMetadata);
            UserCourse userCourse = new UserCourse();
            userCourse.courseMetadata = this.courseMetadata;
            userCourse.categories = this.courseCategories;
            if (this.userKey != null && this.courseEnrollWrapper.getEntity() != null) {
                userCourse.id = this.courseEnrollWrapper.getID();
                userCourse.status = this.courseEnrollWrapper.getStatus();
                userCourse.url = GeneralUtil.urlEncode((String)QuizEncrypter.encrypt(new MailParams(this.courseEnrollWrapper.getEntity(), this.userKey)));
                if (this.courseEnrollWrapper.getDueDate() != null) {
                    userCourse.dueDateStatus = DueDateStatus.getDueDateStatus(this.courseEnrollWrapper.getDueDate());
                    userCourse.dueDate = this.dateFormatter.format(new Date(this.courseEnrollWrapper.getDueDate()));
                }
                if (this.courseModules != null) {
                    userCourse.localizedRate = QuizSettingsNumberHelper.getLocalizedRate(this.courseModules.length - this.courseEnrollWrapper.getCourseModules().length, this.courseModules.length);
                    userCourse.rate = QuizSettingsNumberHelper.calculateRate(this.courseModules.length - this.courseEnrollWrapper.getCourseModules().length, this.courseModules.length);
                }
            } else {
                userCourse.status = -1;
            }
            return userCourse;
        }
    }
}

