/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.entity.course;

import com.stiltsoft.confluence.quiz.ao.entity.course.CourseModule;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseSection;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseStateEntity;
import com.stiltsoft.confluence.quiz.entity.Status;
import com.stiltsoft.confluence.quiz.utils.DueDateHelper;
import com.stiltsoft.confluence.quiz.utils.StatusHistoryHelper;
import java.util.Optional;

public class CourseEnrollWrapper {
    private CourseStateEntity entity;

    public CourseEnrollWrapper(CourseStateEntity entity) {
        this.entity = entity;
    }

    public int getStatus() {
        if (this.isActiveEntityOverdueByTime()) {
            return 4;
        }
        return this.entity.getStatus();
    }

    public String getStatusHistory() {
        if (this.isActiveEntityOverdueByTime()) {
            return StatusHistoryHelper.generateStatusHistory(4, this.entity);
        }
        return this.entity.getStatusHistory();
    }

    public boolean wasStarted() {
        return StatusHistoryHelper.wasStartedEntity(this.entity);
    }

    public Integer getAuthor() {
        return this.entity.getAuthor();
    }

    public Long getStartDate() {
        return this.entity.getStartDate();
    }

    public CourseStateEntity getEntity() {
        return this.entity;
    }

    public Long getCourseId() {
        return this.entity.getCourseId();
    }

    public int getID() {
        return this.entity.getID();
    }

    public Integer getUserId() {
        return this.entity.getUserId();
    }

    public Long getEnrolledDate() {
        return this.entity.getEnrolledDate();
    }

    public Long getEndDate() {
        return this.entity.getEndDate();
    }

    public Long getDueDate() {
        return this.entity.getDueDate();
    }

    public Optional<Long> getCompletedDateOpt() {
        return Optional.ofNullable(this.entity.getCompletedDate());
    }

    public CourseSection[] getCourseSections() {
        return this.entity.getCourseSections();
    }

    public CourseModule[] getCourseModules() {
        return this.entity.getCourseModules();
    }

    private boolean isOverdue(Long dueDate) {
        return dueDate != null && DueDateHelper.isOverdue(dueDate);
    }

    private boolean isActiveEntityOverdueByTime() {
        return Status.isActive(this.entity) && this.isOverdue(this.entity.getDueDate());
    }
}

