/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.entity;

import com.stiltsoft.confluence.quiz.utils.DurationHelper;
import com.stiltsoft.confluence.quiz.utils.QuizSettingsNumberHelper;
import javax.xml.bind.annotation.XmlElement;

public class AbstractStats {
    protected int total = 0;
    protected int succeeded = 0;
    protected long duration = 0L;

    public void setTotal(int total) {
        this.total = total;
    }

    public void setSucceeded(int succeeded) {
        this.succeeded = succeeded;
    }

    public void incTotal() {
        ++this.total;
    }

    public void incSucceeded() {
        ++this.succeeded;
    }

    public void addTotal(int total) {
        this.total += total;
    }

    public void addDuration(long duration) {
        this.duration += duration;
    }

    public int getTotal() {
        return this.total;
    }

    public int getSucceeded() {
        return this.succeeded;
    }

    public long getDurationMillis() {
        return this.duration;
    }

    @XmlElement(name="duration")
    public String getDuration() {
        return DurationHelper.formatDuration(this.duration);
    }

    @XmlElement(name="localizedRate")
    public String getLocalizedRate() {
        return QuizSettingsNumberHelper.getLocalizedRate(this.succeeded, this.total);
    }

    @XmlElement(name="rate")
    public double getRate() {
        return QuizSettingsNumberHelper.calculateRate(this.succeeded, this.total);
    }

    public String getLocalizedRateDetails() {
        return QuizSettingsNumberHelper.getLocalizedRateDetails(this.succeeded, this.total);
    }

    public String getAverageDuration() {
        return this.getAverageDuration(this.total);
    }

    public String getAverageDuration(int total) {
        return DurationHelper.formatDuration(total > 0 ? this.duration / (long)total : this.duration);
    }
}

