/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.cache;

import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserPreferences;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import java.util.HashMap;
import java.util.Map;

public class DateFormatterCacheManager {
    private Map<String, DateFormatterCache> cache;
    private UserAccessor userAccessor;
    private FormatSettingsManager formatSettingsManager;
    private LocaleManager localeManager;

    public DateFormatterCacheManager(UserAccessor userAccessor, FormatSettingsManager formatSettingsManager, LocaleManager localeManager) {
        this.userAccessor = userAccessor;
        this.formatSettingsManager = formatSettingsManager;
        this.localeManager = localeManager;
        this.cache = new HashMap<String, DateFormatterCache>();
    }

    public DateFormatter getDateFormatter() {
        return this.getUserDateFormatter(AuthenticatedUserThreadLocal.get());
    }

    public DateFormatter getDateFormatter(ConfluenceUser user) {
        return this.getUserDateFormatter(user);
    }

    private DateFormatter getUserDateFormatter(ConfluenceUser user) {
        String userKey = this.getUserKey(user);
        if (!this.cache.containsKey(userKey)) {
            return this.storeDateFormatter(user);
        }
        DateFormatterCache cached = this.cache.get(userKey);
        if (cached.isExpired()) {
            return this.storeDateFormatter(user);
        }
        return cached.get();
    }

    private DateFormatter storeDateFormatter(ConfluenceUser user) {
        ConfluenceUserPreferences preferences = this.userAccessor.getConfluenceUserPreferences((User)user);
        DateFormatter dateFormatter = preferences.getDateFormatter(this.formatSettingsManager, this.localeManager);
        this.cache.put(this.getUserKey(user), new DateFormatterCache(dateFormatter));
        return dateFormatter;
    }

    private String getUserKey(ConfluenceUser user) {
        return user != null ? user.getKey().getStringValue() : "";
    }

    private static class DateFormatterCache {
        private static final long LIFE_TIME_MS = 600000L;
        private DateFormatter dateFormatter;
        private long timeStamp;

        public DateFormatterCache(DateFormatter dateFormatter) {
            this.dateFormatter = dateFormatter;
            this.timeStamp = System.currentTimeMillis();
        }

        public DateFormatter get() {
            return this.dateFormatter;
        }

        public boolean isExpired() {
            return this.timeStamp + 600000L < System.currentTimeMillis();
        }
    }
}

