/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.stiltsoft.confluence.quiz.entity.AttachmentParams;
import java.util.concurrent.TimeUnit;

public class AttachmentsCacheManager {
    private static final String KEY = "quiz-ac";
    private Cache<String, Long> cache;

    public AttachmentsCacheManager(CacheManager cacheManager) {
        this.cache = cacheManager.getCache(this.getClass().getName() + ".cache", null, new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    public void add(long attachmentId, AttachmentParams params) {
        this.cache.put((Object)this.getKey(params), (Object)attachmentId);
    }

    public Long get(AttachmentParams params) {
        return (Long)this.cache.get((Object)this.getKey(params));
    }

    public void remove(AttachmentParams params) {
        this.cache.remove((Object)this.getKey(params));
    }

    private String getKey(AttachmentParams params) {
        return KEY + params.getQuizId() + params.getQuestionId() + params.getUserId() + params.getRecordId() + params.getId();
    }
}

