/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.blueprint;

import com.atlassian.confluence.plugins.createcontent.ContentBlueprintManager;
import com.atlassian.confluence.plugins.createcontent.actions.BlueprintManager;
import com.atlassian.confluence.plugins.createcontent.api.events.BlueprintPageCreateEvent;
import com.atlassian.confluence.plugins.createcontent.impl.ContentBlueprint;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.ModuleCompleteKey;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseModuleService;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseSectionService;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseSettingsService;
import com.stiltsoft.confluence.quiz.ao.service.course.DefaultCourseModuleService;
import com.stiltsoft.confluence.quiz.ao.service.quiz.QuestionCategoryService;
import com.stiltsoft.confluence.quiz.ao.service.quiz.QuizQuestionMapService;
import com.stiltsoft.confluence.quiz.manager.ContentPermissionHelper;
import com.stiltsoft.confluence.quiz.manager.QuizServicePageManager;
import com.stiltsoft.confluence.quiz.manager.UpdateMacroManager;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class BlueprintListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(BlueprintListener.class);
    private static final String QUIZ_KEY = "com.stiltsoft.confluence.quiz:quiz-blueprint";
    private static final String COURSE_KEY = "com.stiltsoft.confluence.quiz:course-blueprint";
    private static final String QUESTION_KEY = "com.stiltsoft.confluence.quiz:question-blueprint";
    private EventPublisher eventPublisher;
    private UpdateMacroManager updateMacroManager;
    private QuizServicePageManager quizServicePageManager;
    private QuizQuestionMapService quizQuestionMapService;
    private BlueprintManager blueprintManager;
    private ContentBlueprintManager contentBlueprintManager;
    private CourseSettingsService courseSettingsService;
    private CourseSectionService sectionService;
    private CourseModuleService moduleService;
    private QuestionCategoryService questionCategoryService;
    private ContentPermissionHelper contentPermissionHelper;

    public BlueprintListener(EventPublisher eventPublisher, QuizQuestionMapService quizQuestionMapService, UpdateMacroManager updateMacroManager, QuizServicePageManager quizServicePageManager, BlueprintManager blueprintManager, ContentBlueprintManager contentBlueprintManager, CourseSettingsService courseSettingsService, CourseSectionService sectionService, CourseModuleService moduleService, QuestionCategoryService questionCategoryService, ContentPermissionHelper contentPermissionHelper) {
        this.eventPublisher = eventPublisher;
        this.quizQuestionMapService = quizQuestionMapService;
        this.updateMacroManager = updateMacroManager;
        this.quizServicePageManager = quizServicePageManager;
        this.blueprintManager = blueprintManager;
        this.contentBlueprintManager = contentBlueprintManager;
        this.courseSettingsService = courseSettingsService;
        this.sectionService = sectionService;
        this.moduleService = moduleService;
        this.questionCategoryService = questionCategoryService;
        this.contentPermissionHelper = contentPermissionHelper;
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onBlueprintCreateEvent(BlueprintPageCreateEvent event) {
        if (QUIZ_KEY.equals(event.getBlueprint().getModuleCompleteKey())) {
            this.contentPermissionHelper.setContentPermission(event.getCreator(), event.getPage());
            try {
                HashMap<String, String> additionalQuizParams = new HashMap<String, String>();
                additionalQuizParams.put("success-page-id", this.quizServicePageManager.createSuccessPageAndReturnId(event));
                additionalQuizParams.put("fail-page-id", this.quizServicePageManager.createFailPageAndReturnId(event));
                additionalQuizParams.put("review-page-id", this.quizServicePageManager.createReviewPageAndReturnId(event));
                additionalQuizParams.put("start-page-id", this.quizServicePageManager.createStartPageAndReturnId(event));
                additionalQuizParams.put("desc", (String)event.getContext().get("desc"));
                new Thread(() -> this.updateMacroManager.updateQuizPageParams(event, additionalQuizParams)).start();
            }
            catch (Exception ex) {
                log.error("Quiz on blueprint created event: unable to update quiz settings.");
            }
            Space space = event.getPage().getSpace();
            ModuleCompleteKey moduleCompleteKey = new ModuleCompleteKey("com.stiltsoft.confluence.quiz", "question-blueprint");
            ContentBlueprint contentBlueprint = this.contentBlueprintManager.getPluginBackedContentBlueprint(moduleCompleteKey, space.getKey());
            this.blueprintManager.createAndPinIndexPage(contentBlueprint, space);
            String courseId = (String)event.getContext().get("courseid");
            if (!courseId.isEmpty()) {
                this.moduleService.addTx(Long.valueOf(courseId), event.getPage().getId(), DefaultCourseModuleService.QUIZ_MODULE, Integer.valueOf((String)event.getContext().get("sectionid")));
            }
        } else if (QUESTION_KEY.equals(event.getBlueprint().getModuleCompleteKey())) {
            String quizIdParam = (String)event.getContext().get("quizid");
            if (quizIdParam.isEmpty()) {
                this.contentPermissionHelper.setContentPermission(event.getCreator(), event.getPage());
            } else {
                Long quizId = Long.valueOf(quizIdParam);
                this.quizQuestionMapService.add(quizId, event.getPage().getId(), this.questionCategoryService.getDefaultCategory(quizId, null));
            }
        } else if (COURSE_KEY.equals(event.getBlueprint().getModuleCompleteKey())) {
            this.contentPermissionHelper.setContentPermission(event.getCreator(), event.getPage());
            this.courseSettingsService.setDesc(event.getPage().getId(), (String)event.getContext().get("desc"));
            this.sectionService.addSectionTx(event.getPage().getId(), "");
        }
    }
}

