/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.ao.service.settings;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.stiltsoft.confluence.quiz.ao.entity.settings.Coauthor;
import com.stiltsoft.confluence.quiz.ao.service.settings.CoauthorService;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;

public class DefaultCoauthorService
implements CoauthorService {
    private ActiveObjects ao;
    private UserAccessor userAccessor;

    public DefaultCoauthorService(ActiveObjects ao, UserAccessor userAccessor) {
        this.ao = ao;
        this.userAccessor = userAccessor;
    }

    @Override
    public void setCoauthors(List<String> groups, List<String> users) {
        this.ao.delete(this.ao.find(Coauthor.class));
        this.createEntities(groups, 0);
        this.createEntities(users, 1);
    }

    @Override
    public Coauthor[] getCoauthors() {
        return (Coauthor[])this.ao.find(Coauthor.class, Query.select().order("TYPE ASC"));
    }

    @Override
    public Coauthor[] getCoauthorGroups() {
        return this.findByType(0);
    }

    @Override
    public Coauthor[] getCoauthorUsers() {
        return this.findByType(1);
    }

    private Coauthor[] findByType(int type) {
        return (Coauthor[])this.ao.find(Coauthor.class, Query.select().where("TYPE = ?", new Object[]{type}).order("IDENTIFIER ASC"));
    }

    private void createEntities(List<String> identifiers, int type) {
        identifiers.forEach(identifier -> {
            if (this.isUserOrGroupEntityExist((String)identifier, type)) {
                this.ao.create(Coauthor.class, new DBParam[]{new DBParam("IDENTIFIER", identifier), new DBParam("TYPE", (Object)type)});
            }
        });
    }

    private boolean isUserOrGroupEntityExist(String identifier, int type) {
        if (type == 0) {
            return this.userAccessor.getGroup(identifier) != null;
        }
        if (type == 1) {
            return this.userAccessor.getExistingUserByKey(new UserKey(identifier)) != null;
        }
        return false;
    }
}

