/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.ao.service.settings;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.stiltsoft.confluence.quiz.ao.entity.settings.GroupPermission;
import com.stiltsoft.confluence.quiz.ao.entity.settings.UserPermission;
import com.stiltsoft.confluence.quiz.ao.service.settings.CQPermissionService;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class DefaultCQPermissionService
implements CQPermissionService {
    private ActiveObjects ao;

    public DefaultCQPermissionService(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public void setGroups(List<String> groups, Integer type) {
        this.ao.delete((RawEntity[])this.getGroupPermissionsByType(type));
        for (String group : groups) {
            this.ao.create(GroupPermission.class, new DBParam[]{new DBParam("GROUP", (Object)group), new DBParam("TYPE", (Object)type)});
        }
    }

    @Override
    public GroupPermission[] getGroupPermissions(Integer type) {
        return this.getGroupPermissionsByType(type);
    }

    @Override
    public void setUsers(List<String> users, Integer type) {
        this.ao.delete((RawEntity[])this.getUserPermissionsByType(type));
        for (String user : users) {
            this.ao.create(UserPermission.class, new DBParam[]{new DBParam("USER_KEY", (Object)user), new DBParam("TYPE", (Object)type)});
        }
    }

    @Override
    public UserPermission[] getUserPermissions(Integer type) {
        return this.getUserPermissionsByType(type);
    }

    @Override
    public boolean hasUserPermission(String userKey, Integer type) {
        return ((UserPermission[])this.ao.find(UserPermission.class, Query.select().where("USER_KEY = ? AND TYPE = ?", new Object[]{userKey, type}).limit(1))).length == 1;
    }

    private UserPermission[] getUserPermissionsByType(Integer type) {
        return (UserPermission[])this.ao.find(UserPermission.class, Query.select().where("TYPE = ?", new Object[]{type}).order("USER_KEY ASC"));
    }

    private GroupPermission[] getGroupPermissionsByType(Integer type) {
        return (GroupPermission[])this.ao.find(GroupPermission.class, Query.select().where("TYPE = ?", new Object[]{type}).order("GROUP ASC"));
    }
}

