/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.ao.service.quiz;

import com.stiltsoft.confluence.quiz.ao.dao.CourseStateEntityDao;
import com.stiltsoft.confluence.quiz.ao.dao.QuizStateEntityDao;
import com.stiltsoft.confluence.quiz.ao.dao.ReminderDao;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseSettings;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseStateEntity;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizReminder;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizStateEntity;
import com.stiltsoft.confluence.quiz.ao.service.quiz.ReminderService;
import com.stiltsoft.confluence.quiz.entity.quiz.QuizParams;
import com.stiltsoft.confluence.quiz.utils.ReminderTimeHelper;
import java.util.List;

public class DefaultReminderService
implements ReminderService {
    private ReminderDao reminderDao;
    private CourseStateEntityDao courseStateEntityDao;
    private QuizStateEntityDao quizStateEntityDao;

    public DefaultReminderService(ReminderDao reminderDao, CourseStateEntityDao courseStateEntityDao, QuizStateEntityDao quizStateEntityDao) {
        this.reminderDao = reminderDao;
        this.courseStateEntityDao = courseStateEntityDao;
        this.quizStateEntityDao = quizStateEntityDao;
    }

    @Override
    public void setQuizReminders(QuizParams params, QuizStateEntity entity) {
        ReminderTimeHelper.tryComputeDAEReminderTime(params.getEnrollmentReminder(), entity.getEnrolledDate(), entity.getDueDate()).ifPresent(time -> this.reminderDao.createQuizDAEReminder(entity.getSessionId(), entity.getQuizId(), (Long)time));
        ReminderTimeHelper.tryComputeDueDateReminderTime(params.getDueDateReminder(), entity.getDueDate()).ifPresent(time -> this.reminderDao.createQuizDueDateReminder(entity.getSessionId(), entity.getQuizId(), (Long)time));
    }

    @Override
    public void setCourseReminders(CourseSettings settings, CourseStateEntity entity) {
        ReminderTimeHelper.tryComputeDAEReminderTime(settings.getReminderDays(), entity.getEnrolledDate(), entity.getDueDate()).ifPresent(time -> this.reminderDao.createCourseDAEReminder(entity.getID(), entity.getCourseId(), (Long)time));
    }

    @Override
    public void updateCourseDAEReminders(Long courseId, Integer daysAfterEnrollment) {
        List<QuizReminder> quizReminders = this.reminderDao.findCourseDAEReminders(courseId);
        this.reminderDao.remove(quizReminders);
        if (daysAfterEnrollment != null) {
            List<CourseStateEntity> entities = this.courseStateEntityDao.getActiveEntitiesByCourseId(courseId);
            for (CourseStateEntity entity : entities) {
                ReminderTimeHelper.tryComputeDAEReminderTime(daysAfterEnrollment, entity.getEnrolledDate(), entity.getDueDate()).ifPresent(time -> this.reminderDao.createCourseDAEReminder(entity.getID(), entity.getCourseId(), (Long)time));
            }
        }
    }

    @Override
    public void updateQuizDAEReminders(Long quizId, Integer daysAfterEnrollment) {
        List<QuizReminder> quizReminders = this.reminderDao.findQuizDAEReminders(quizId);
        this.reminderDao.remove(quizReminders);
        if (daysAfterEnrollment != null) {
            List<QuizStateEntity> entities = this.quizStateEntityDao.getStatesWithAttemptsByQuizId(quizId);
            for (QuizStateEntity entity : entities) {
                ReminderTimeHelper.tryComputeDAEReminderTime(daysAfterEnrollment, entity.getEnrolledDate(), entity.getDueDate()).ifPresent(time -> this.reminderDao.createQuizDAEReminder(entity.getSessionId(), entity.getQuizId(), (Long)time));
            }
        }
    }

    @Override
    public void updateQuizDueDateReminders(Long quizId, Integer daysBeforeDueDate) {
        List<QuizReminder> quizReminders = this.reminderDao.findQuizDueDateReminders(quizId);
        this.reminderDao.remove(quizReminders);
        if (daysBeforeDueDate != null) {
            List<QuizStateEntity> entities = this.quizStateEntityDao.getStatesWithAttemptsByQuizId(quizId);
            for (QuizStateEntity entity : entities) {
                ReminderTimeHelper.tryComputeDueDateReminderTime(daysBeforeDueDate, entity.getDueDate()).ifPresent(time -> this.reminderDao.createQuizDueDateReminder(entity.getSessionId(), entity.getQuizId(), (Long)time));
            }
        }
    }
}

