/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.ao.service.quiz;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.stiltsoft.confluence.quiz.ao.entity.UserEntity;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizAnswersEntity;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizStateEntity;
import com.stiltsoft.confluence.quiz.ao.service.quiz.QuizService;
import com.stiltsoft.confluence.quiz.entity.DueDateChanges;
import com.stiltsoft.confluence.quiz.entity.Status;
import com.stiltsoft.confluence.quiz.entity.quiz.QuizFinishedStatus;
import com.stiltsoft.confluence.quiz.entity.quiz.QuizParams;
import com.stiltsoft.confluence.quiz.manager.QuizHelper;
import com.stiltsoft.confluence.quiz.manager.QuizMacroManager;
import com.stiltsoft.confluence.quiz.manager.UserEntityService;
import com.stiltsoft.confluence.quiz.utils.DueDateHelper;
import com.stiltsoft.confluence.quiz.utils.NumberHelper;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.java.ao.DBParam;
import net.java.ao.EntityStreamCallback;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class DefaultQuizService
implements QuizService {
    private static final Logger log = LoggerFactory.getLogger(DefaultQuizService.class);
    private static final int ENTITY_DELETE_LIMIT = 100;
    private ActiveObjects ao;
    private ApplicationContext applicationContext;
    private QuizMacroManager quizMacroManager;
    private UserEntityService userEntityService;
    private UserAccessor userAccessor;
    private DueDateHelper dueDateHelper;

    public DefaultQuizService(ActiveObjects ao, ApplicationContext applicationContext, QuizMacroManager quizMacroManager, UserEntityService userEntityService, UserAccessor userAccessor, DueDateHelper dueDateHelper) {
        this.ao = ao;
        this.applicationContext = applicationContext;
        this.quizMacroManager = quizMacroManager;
        this.userEntityService = userEntityService;
        this.userAccessor = userAccessor;
        this.dueDateHelper = dueDateHelper;
    }

    @Override
    public List<QuizStateEntity> setTests(Long quizId, Integer authorId, QuizParams params, List<QuizHelper.RecordParams> recordParams) {
        ArrayList<QuizStateEntity> entities = new ArrayList<QuizStateEntity>();
        for (QuizHelper.RecordParams recordParam : recordParams) {
            entities.add(this.createRecord(recordParam.getUserId(), quizId, authorId, recordParam.getQuestions(), params, recordParam.getDueDate(), false, null, null));
        }
        return entities;
    }

    @Override
    public QuizStateEntity setTest(Integer studentId, Long quizId, Integer authorId, List<Long> questions, QuizParams params, Long dueDate, Boolean selfEnrollment, Long courseId, Integer courseRecord) {
        return this.createRecord(studentId, quizId, authorId, questions, params, dueDate, selfEnrollment, courseId, courseRecord);
    }

    @Override
    public boolean startTest(QuizStateEntity entity) {
        if (entity != null && entity.getStatus() == 0 && !this.isOverDue(entity)) {
            entity.setDeleted(false);
            entity.setDeletedByUser(false);
            entity.setStatus(1);
            entity.setReview(0);
            entity.setStartDate(System.currentTimeMillis());
            entity.setAttempts(entity.getAttempts() != null ? entity.getAttempts() - 1 : 0);
            entity.save();
            return true;
        }
        return false;
    }

    @Override
    public Optional<QuizStateEntity> getState(Integer studentId, Long quizId, Integer recordId) {
        return Optional.ofNullable(this.findState(studentId, quizId, recordId));
    }

    @Override
    public Optional<QuizStateEntity> restartTest(Integer studentId, Long quizId, Integer authorId, List<Long> questions, QuizStateEntity previousState, QuizParams quizParams) {
        if (this.canRetakeQuiz(previousState)) {
            QuizStateEntity currentState = (QuizStateEntity)this.ao.create(QuizStateEntity.class, new DBParam[]{new DBParam("USER_ID", (Object)studentId), new DBParam("AUTHOR", (Object)authorId), new DBParam("QUIZ_ID", (Object)quizId), new DBParam("STATUS", (Object)0), new DBParam("CORRECT", (Object)0), new DBParam("ANSWERS", (Object)0)});
            currentState.setQuestions(Joiner.on((char)',').join(questions));
            currentState.setAllQuestions(Joiner.on((char)',').join(questions));
            currentState.setTotal(questions.size());
            currentState.setTarget(quizParams.getTarget());
            currentState.setTimeLimit(quizParams.getTimeLimit());
            currentState.setAttempts(previousState.getAttempts());
            currentState.setAttemptsCount(previousState.getAttemptsCount());
            currentState.setShowRes(quizParams.isShowRes());
            currentState.setShowFeedback(quizParams.isShowFeedback());
            currentState.setSkip(quizParams.isSkip());
            currentState.setResubmit(quizParams.isResubmit());
            currentState.setRandom(quizParams.isRandom());
            currentState.setStartDate(System.currentTimeMillis());
            currentState.setSkipStartPage(quizParams.isSkipStartPage());
            currentState.setSelfEnrollment(previousState.getSelfEnrollment());
            currentState.setSessionId(previousState.getSessionId() == null ? previousState.getID() : previousState.getSessionId().intValue());
            currentState.setReview(0);
            currentState.setDeleted(false);
            currentState.setDeletedByUser(false);
            currentState.setDueDate(previousState.getDueDate());
            currentState.setCourseRecord(previousState.getCourseRecord());
            currentState.setCourseId(previousState.getCourseId());
            currentState.setEnrolledDate(previousState.getEnrolledDate());
            currentState.save();
            return Optional.of(currentState);
        }
        return Optional.empty();
    }

    @Override
    public QuizStateEntity getStateTx(Integer studentId, Long quizId, Integer authorId, Integer recordId) {
        return this.finishTestTx(studentId, quizId, authorId, recordId, false);
    }

    @Override
    public QuizStateEntity getStateNoTx(Integer studentId, Long quizId, Integer authorId, Integer recordId) {
        return this.finishTestTx(studentId, quizId, authorId, recordId, false);
    }

    @Override
    public QuizStateEntity finishTestTx(Integer studentId, Long quizId, Integer authorId, Integer recordId, Boolean giveUp) {
        return this.finishTest(studentId, quizId, authorId, recordId, giveUp);
    }

    @Override
    public QuizStateEntity finishTestNoTx(Integer studentId, Long quizId, Integer authorId, Integer recordId, Boolean giveUp) {
        return this.finishTest(studentId, quizId, authorId, recordId, giveUp);
    }

    @Override
    public Long getNextQuestion(Integer studentId, Long quizId, Integer authorId, Integer recordId) {
        return this.getNextQuestion(this.findState(studentId, quizId, recordId));
    }

    @Override
    public QuizAnswersEntity startAnswer(Integer studentId, Long quizId, Integer authorId, Long questionId, int questionVersion, long attempt, List<String> correctAnswers, List<Integer> sequence, Boolean reviewable) {
        QuizAnswersEntity[] entities = this.findAnswer(studentId, quizId, authorId, questionId, attempt);
        QuizAnswersEntity entity = entities.length == 0 ? (QuizAnswersEntity)this.ao.create(QuizAnswersEntity.class, new DBParam[]{new DBParam("USER_ID", (Object)studentId), new DBParam("QUIZ_ID", (Object)quizId), new DBParam("AUTHOR", (Object)authorId), new DBParam("ATTEMPT", (Object)attempt), new DBParam("PROGRESS", (Object)true), new DBParam("REVIEWABLE", (Object)reviewable), new DBParam("QUESTION_ID", (Object)questionId)}) : entities[0];
        entity.setStartTime(System.currentTimeMillis());
        entity.setPageVersion(questionVersion);
        entity.setCorrectAnswers(Joiner.on((String)",").join(correctAnswers));
        entity.setSequence(Joiner.on((String)",").join(sequence));
        entity.save();
        return entity;
    }

    @Override
    public MutablePair<QuizStateEntity, QuizAnswersEntity> saveAnswer(Integer studentId, Long quizId, Integer authorId, Long questionId, long attempt, List<String> answers, Integer recordId, Long started, Boolean isAutoCheckedFreeText) {
        boolean wasAnswered;
        QuizAnswersEntity entity = this.findAnswer(studentId, quizId, authorId, questionId, attempt)[0];
        QuizStateEntity stateEntity = this.findState(studentId, quizId, recordId);
        if (stateEntity == null) {
            return null;
        }
        if (started != null && started > 0L && !started.equals(entity.getStartTime())) {
            return null;
        }
        boolean bl = wasAnswered = entity.getEndTime() != null;
        if (wasAnswered && !Boolean.TRUE.equals(stateEntity.getResubmit())) {
            return new MutablePair((Object)stateEntity, (Object)entity);
        }
        boolean wasCorrect = Boolean.TRUE.equals(entity.getCorrect());
        entity.setEndTime(System.currentTimeMillis());
        entity.setAnswers(Joiner.on((String)",").join(answers));
        if (!Boolean.TRUE.equals(entity.getReviewable())) {
            ArrayList correct = Lists.newArrayList((Object[])entity.getCorrectAnswers().split(","));
            correct.remove("");
            if (isAutoCheckedFreeText.booleanValue()) {
                try {
                    String encodedAnswer = URLEncoder.encode(answers.get(0).toLowerCase(), StandardCharsets.UTF_8.toString());
                    entity.setCorrect(correct.contains(encodedAnswer));
                }
                catch (Exception e) {
                    entity.setCorrect(false);
                }
            } else {
                entity.setCorrect(correct.containsAll(answers) && answers.containsAll(correct));
            }
        } else if (!wasAnswered) {
            stateEntity.setReview(stateEntity.getReview() + 1);
        }
        entity.setProgress(false);
        entity.save();
        if (!wasAnswered) {
            stateEntity.setAnswers(stateEntity.getAnswers() + 1);
        }
        stateEntity.setEndDate(entity.getEndTime());
        int result = wasAnswered && wasCorrect ? -1 : 0;
        stateEntity.setCorrect(stateEntity.getCorrect() + (result += entity.getCorrect() != null && entity.getCorrect() != false ? 1 : 0));
        ArrayList<Long> questions = new ArrayList<Long>();
        for (String question : StringUtils.defaultString((String)stateEntity.getQuestions()).split(",")) {
            if (question.isEmpty()) continue;
            questions.add(Long.valueOf(question));
        }
        questions.remove(questionId);
        stateEntity.setQuestions(Joiner.on((String)",").join(questions));
        if (questions.isEmpty() && (stateEntity.getResubmit() == null || !stateEntity.getResubmit().booleanValue())) {
            stateEntity.setStatus(2);
        }
        stateEntity.save();
        return new MutablePair((Object)stateEntity, (Object)entity);
    }

    @Override
    public QuizStateEntity reviewAnswer(Integer userId, Long quizId, Long questionId, Long attempt, Boolean correct, Integer stateId, String reviewerKey) {
        QuizAnswersEntity answersEntity = this.getAnswer(userId, quizId, questionId, attempt);
        if (answersEntity.getCorrect() != null && answersEntity.getCorrect() == correct) {
            return null;
        }
        QuizStateEntity stateEntity = this.getStateTx(stateId);
        if (answersEntity.getCorrect() == null) {
            stateEntity.setReview(stateEntity.getReview() - 1);
        } else if (!correct.booleanValue()) {
            stateEntity.setCorrect(stateEntity.getCorrect() - 1);
        }
        answersEntity.setCorrect(correct);
        answersEntity.setReviewer(reviewerKey);
        answersEntity.save();
        if (correct.booleanValue()) {
            stateEntity.setCorrect(stateEntity.getCorrect() + 1);
        }
        stateEntity.save();
        return stateEntity;
    }

    @Override
    public void skipQuestion(Integer studentId, Long quizId, Integer authorId, Long questionId, long attempt, Integer recordId, Long nextId) {
        QuizAnswersEntity entity = this.findAnswer(studentId, quizId, authorId, questionId, attempt)[0];
        QuizStateEntity stateEntity = this.findState(studentId, quizId, recordId);
        if (stateEntity.getSkip() != null && stateEntity.getSkip().booleanValue() || stateEntity.getResubmit() != null && stateEntity.getResubmit().booleanValue()) {
            if (entity.getProgress() != null && entity.getProgress().booleanValue()) {
                entity.setProgress(null);
                long wastedTime = entity.getWastedTime() == null ? 0L : entity.getWastedTime();
                entity.setWastedTime(wastedTime += System.currentTimeMillis() - entity.getStartTime());
                entity.save();
            }
            ArrayList<Long> questions = new ArrayList<Long>();
            for (String question : StringUtils.defaultString((String)stateEntity.getQuestions()).split(",")) {
                if (question.isEmpty()) continue;
                questions.add(Long.valueOf(question));
            }
            if (questions.isEmpty() || nextId != null && !questions.contains(nextId)) {
                return;
            }
            if (nextId == null) {
                questions.remove(questionId);
                questions.add(questionId);
            } else {
                while (!nextId.equals(questions.get(0))) {
                    Long id = (Long)questions.get(0);
                    questions.remove(id);
                    questions.add(id);
                }
            }
            stateEntity.setQuestions(Joiner.on((String)",").join(questions));
            if (questions.isEmpty()) {
                stateEntity.setStatus(2);
            }
            stateEntity.save();
        }
    }

    @Override
    public List<QuizAnswersEntity> getAnswers(Long quizId, Long questionId) {
        return this.findAnswers(quizId, questionId);
    }

    @Override
    public List<QuizAnswersEntity> getAnswers(Long questionId) {
        return this.findAnswers(null, questionId);
    }

    @Override
    public List<QuizStateEntity> getStates(Long quizId, List<Integer> studentIds) {
        Query query = studentIds.isEmpty() ? Query.select().where("QUIZ_ID = ? AND (DELETED IS NULL OR DELETED = ?)", new Object[]{quizId, Boolean.FALSE}) : Query.select().where("QUIZ_ID = ? AND (DELETED IS NULL OR DELETED = ?) AND USER_ID IN (" + Joiner.on((char)',').join(studentIds) + ")", new Object[]{quizId, Boolean.FALSE});
        QuizStateEntity[] entities = (QuizStateEntity[])this.ao.find(QuizStateEntity.class, query.order("START_DATE DESC"));
        ArrayList<QuizStateEntity> entityList = new ArrayList<QuizStateEntity>();
        for (QuizStateEntity entity : entities) {
            this.finishTest(entity, false);
            entityList.add(entity);
        }
        return entityList;
    }

    @Override
    public List<QuizStateEntity> getUserStates(String userKey) {
        QuizStateEntity[] entities;
        ArrayList<QuizStateEntity> entityList = new ArrayList<QuizStateEntity>();
        for (QuizStateEntity entity : entities = (QuizStateEntity[])this.ao.find(QuizStateEntity.class, Query.select().where("USER_ID = ? AND COURSE_ID IS NULL AND (DELETED_BY_USER IS NULL OR DELETED_BY_USER = ?) AND (DELETED IS NULL OR DELETED = ?)", new Object[]{this.userEntityService.getUserId(userKey), Boolean.FALSE, Boolean.FALSE}).order("START_DATE DESC"))) {
            this.finishTest(entity, false);
            entityList.add(entity);
        }
        return entityList;
    }

    @Override
    public List<QuizStateEntity> getUserActualStates(String userKey, Long quizId) {
        return Lists.newArrayList((Object[])this.ao.find(QuizStateEntity.class, Query.select().where("USER_ID = ? AND QUIZ_ID = ? AND COURSE_ID IS NULL AND (DELETED IS NULL OR DELETED = ?)", new Object[]{this.userEntityService.getUserId(userKey), quizId, Boolean.FALSE}).order("START_DATE DESC")));
    }

    @Override
    public Set<Integer> getQuizActualEnrolledUserIds(Long quizId) {
        final HashSet<Integer> ids = new HashSet<Integer>();
        this.ao.stream(QuizStateEntity.class, Query.select((String)"ID,QUIZ_ID,COURSE_ID,DELETED,USER_ID").where("QUIZ_ID = ? AND COURSE_ID IS NULL AND (DELETED IS NULL OR DELETED = ?)", new Object[]{quizId, Boolean.FALSE}), (EntityStreamCallback)new EntityStreamCallback<QuizStateEntity, Integer>(){

            public void onRowRead(QuizStateEntity entity) {
                ids.add(entity.getUserId());
            }
        });
        return ids;
    }

    @Override
    public void delete(Long quizId, List<Integer> ids) {
        List<Integer> idsSubList;
        int part = 0;
        do {
            idsSubList = this.getSubList(part, ids);
            for (QuizStateEntity entity : (QuizStateEntity[])this.ao.find(QuizStateEntity.class, Query.select().where("QUIZ_ID = ? AND (DELETED IS NULL OR DELETED = ?) AND (ID IN(" + NumberHelper.joinNumbersByComma(idsSubList) + ") OR SESSION_ID IN (" + NumberHelper.joinNumbersByComma(idsSubList) + "))", new Object[]{quizId, Boolean.FALSE}))) {
                if (entity.getStatus() == 0 || entity.getStatus() == 1) {
                    entity.setStatus(3);
                }
                entity.setDeleted(true);
                entity.save();
            }
            ++part;
        } while (idsSubList.size() >= 100);
    }

    @Override
    public Map<QuizStateEntity, DueDateChanges> updateDueDate(Long quizId, String dueDate, String dueDays) {
        QuizStateEntity[] entities = (QuizStateEntity[])this.ao.find(QuizStateEntity.class, Query.select().where("QUIZ_ID = ? AND (DELETED IS NULL OR DELETED = ?)", new Object[]{quizId, Boolean.FALSE}));
        return this.updateDueDate(entities, dueDate, dueDays);
    }

    @Override
    public Map<QuizStateEntity, DueDateChanges> updateDueDate(Long quizId, String dueDate, String dueDays, List<Integer> ids) {
        HashMap<QuizStateEntity, DueDateChanges> updatedAttempts = new HashMap<QuizStateEntity, DueDateChanges>();
        for (Integer id : ids) {
            QuizStateEntity[] entities = (QuizStateEntity[])this.ao.find(QuizStateEntity.class, Query.select().where("(ID = ? OR SESSION_ID = ?) AND QUIZ_ID = ?", new Object[]{id, id, quizId}));
            updatedAttempts.putAll(this.updateDueDate(entities, dueDate, dueDays));
        }
        return updatedAttempts;
    }

    @Override
    public Map<QuizStateEntity, Integer> updateAttempts(Long quizId, Integer attempts) {
        QuizStateEntity[] entities;
        HashMap<QuizStateEntity, Integer> updatedAttempts = new HashMap<QuizStateEntity, Integer>();
        HashSet<Integer> updatedIds = new HashSet<Integer>();
        for (QuizStateEntity entity : entities = (QuizStateEntity[])this.ao.find(QuizStateEntity.class, Query.select().where("QUIZ_ID = ? AND (DELETED IS NULL OR DELETED = ?)", new Object[]{quizId, Boolean.FALSE}))) {
            Integer addedAttempts = this.updateAttempts(entity, attempts);
            if (addedAttempts <= 0 || entity.getSessionId() == null || updatedIds.contains(entity.getSessionId())) continue;
            updatedAttempts.put(entity, addedAttempts);
            updatedIds.add(entity.getSessionId());
        }
        return updatedAttempts;
    }

    @Override
    public List<QuizStateEntity> addUsersAttempts(Long quizId, Integer attempts, List<String> userKeys) {
        ArrayList<Integer> studentIds = new ArrayList<Integer>();
        for (String userKey : userKeys) {
            studentIds.add(this.userEntityService.getUserId(userKey));
        }
        ArrayList<QuizStateEntity> updatedEntities = new ArrayList<QuizStateEntity>();
        for (Integer studentId : studentIds) {
            QuizStateEntity[] entities = (QuizStateEntity[])this.ao.find(QuizStateEntity.class, Query.select().where("QUIZ_ID = ? AND USER_ID = ?", new Object[]{quizId, studentId}).order("START_DATE DESC"));
            if (!this.addAttempts(entities, attempts)) continue;
            updatedEntities.add(entities[0]);
        }
        return updatedEntities;
    }

    @Override
    public List<QuizStateEntity> addRecordsAttempts(Long quizId, Integer attempts, List<Integer> ids) {
        ArrayList<QuizStateEntity> updatedEntities = new ArrayList<QuizStateEntity>();
        for (Integer id : ids) {
            QuizStateEntity[] entities = (QuizStateEntity[])this.ao.find(QuizStateEntity.class, Query.select().where("(ID = ? OR SESSION_ID = ?) AND QUIZ_ID = ?", new Object[]{id, id, quizId}));
            if (!this.addAttempts(entities, attempts)) continue;
            updatedEntities.add(entities[0]);
        }
        return updatedEntities;
    }

    @Override
    public void deleteByUser(String userKey, List<Integer> ids) {
        int userId = this.userEntityService.getUserId(userKey);
        for (int id : ids) {
            for (QuizStateEntity entity : (QuizStateEntity[])this.ao.find(QuizStateEntity.class, Query.select().where("(ID = ? OR SESSION_ID = ?) AND USER_ID = ?", new Object[]{id, id, userId}))) {
                entity.setDeletedByUser(true);
                entity.save();
            }
        }
    }

    @Override
    public QuizAnswersEntity[] getAnswers(Integer userId, Long quizId, long attempt) {
        return (QuizAnswersEntity[])this.ao.find(QuizAnswersEntity.class, Query.select().where("USER_ID = ? AND QUIZ_ID = ? AND ATTEMPT = ? AND END_TIME > 0", new Object[]{userId, quizId, attempt}).order("ID ASC"));
    }

    @Override
    public QuizAnswersEntity getAnswer(Integer userId, Long quizId, Long questionId, long attempt) {
        QuizAnswersEntity[] entities = (QuizAnswersEntity[])this.ao.find(QuizAnswersEntity.class, Query.select().where("USER_ID = ? AND QUIZ_ID = ? AND QUESTION_ID = ? AND ATTEMPT = ?", new Object[]{userId, quizId, questionId, attempt}).limit(1));
        return entities.length == 0 ? null : entities[0];
    }

    @Override
    public void startWatchingQuestion(QuizAnswersEntity entity) {
        this.stopWatchingQuestion(entity.getUserId(), entity.getQuizId(), entity.getAttempt());
        long wastedTime = entity.getWastedTime() == null ? 0L : entity.getWastedTime();
        entity.setWastedTime(wastedTime += entity.getEndTime() - entity.getStartTime());
        entity.setStartTime(System.currentTimeMillis());
        entity.setEndTime(System.currentTimeMillis());
        entity.setWatching(true);
        entity.save();
    }

    @Override
    public QuizStateEntity getStateTx(Integer recordId) {
        return ((QuizStateEntity[])this.ao.find(QuizStateEntity.class, Query.select().where("ID = ?", new Object[]{recordId}).limit(1)))[0];
    }

    @Override
    public void remove(QuizStateEntity entity) {
        this.ao.delete(new RawEntity[]{entity});
    }

    @Override
    public List<QuizStateEntity> findAttempts(Integer recordId) {
        QuizStateEntity[] entities = (QuizStateEntity[])this.ao.find(QuizStateEntity.class, Query.select().where("ID = ? OR SESSION_ID = ?", new Object[]{recordId, recordId}).order("START_DATE DESC"));
        return Arrays.asList(entities);
    }

    @Override
    public QuizStateEntity[] findStatesForReview(Long quizId, Long courseId) {
        Query query = Query.select();
        query = courseId == null ? query.where("QUIZ_ID = ? AND (STATUS = 1 OR STATUS = 2) AND ANSWERS > 0 AND COURSE_ID IS NULL AND (DELETED IS NULL OR DELETED = ?)", new Object[]{quizId, Boolean.FALSE}) : query.where("QUIZ_ID = ? AND COURSE_ID = ? AND (STATUS = 1 OR STATUS = 2) AND ANSWERS > 0 AND (DELETED IS NULL OR DELETED = ?)", new Object[]{quizId, courseId, Boolean.FALSE});
        return (QuizStateEntity[])this.ao.find(QuizStateEntity.class, query.order("START_DATE DESC"));
    }

    @Override
    public boolean isRetakeOnFail(QuizStateEntity entity) {
        return this.quizMacroManager.getQuizParams(entity.getQuizId()).isRetakeOnFail() && (entity.getReview() != null && entity.getReview() > 0 || entity.getCorrect() >= entity.getTarget());
    }

    @Override
    public boolean isLatestAttempt(QuizStateEntity entity) {
        Integer sessionId = entity.getSessionId() != null ? entity.getSessionId().intValue() : entity.getID();
        return ((QuizStateEntity[])this.ao.find(QuizStateEntity.class, Query.select().where("SESSION_ID = ? AND USER_ID = ? AND QUIZ_ID = ? AND START_DATE > ?", new Object[]{sessionId, entity.getUserId(), entity.getQuizId(), entity.getStartDate()}).limit(1))).length == 0;
    }

    @Override
    public boolean canRetake(QuizStateEntity entity) {
        return this.canRetakeQuiz(entity);
    }

    private boolean canRetakeQuiz(QuizStateEntity entity) {
        return entity != null && entity.getAttempts() > 0 && entity.getStatus() == 2 && (this.isNotDeleted(entity) || entity.getCourseId() != null) && !this.isOverDue(entity) && !this.isCompleted(entity) && !this.isRetakeOnFail(entity) && this.isLatestAttempt(entity);
    }

    private List<Integer> getSubList(int part, List<Integer> ids) {
        int start = Math.min(part * 100, ids.size());
        int end = Math.min((part + 1) * 100, ids.size());
        return ids.subList(start, end);
    }

    private QuizStateEntity findState(Integer userId, Long quizId, Integer recordId) {
        QuizStateEntity[] entities = (QuizStateEntity[])this.ao.find(QuizStateEntity.class, Query.select().where("(ID = ? OR SESSION_ID = ?) AND USER_ID = ? AND QUIZ_ID = ?", new Object[]{recordId, recordId, userId, quizId}).order("START_DATE DESC").limit(1));
        return entities.length == 0 ? null : entities[0];
    }

    private QuizAnswersEntity[] findAnswer(Integer userId, Long quizId, Integer authorId, Long questionId, long attempt) {
        return (QuizAnswersEntity[])this.ao.find(QuizAnswersEntity.class, Query.select().where("USER_ID = ? AND QUIZ_ID = ? AND AUTHOR = ? AND QUESTION_ID = ? AND ATTEMPT = ?", new Object[]{userId, quizId, authorId, questionId, attempt}).limit(1));
    }

    private void finishTest(QuizStateEntity entity, Boolean giveUp) {
        if (entity != null && Status.isActive(entity)) {
            boolean overDue = this.isOverDue(entity);
            boolean timeOut = this.isTimeOut(entity);
            if (entity.getStatus() == 1 && (timeOut || overDue || giveUp.booleanValue())) {
                QuizAnswersEntity[] answersEntities;
                this.stopWatchingQuestion(entity.getUserId(), entity.getQuizId(), entity.getStartDate());
                Long qid = this.getNextQuestion(entity);
                if (qid != null && (answersEntities = this.findAnswer(entity.getUserId(), entity.getQuizId(), entity.getAuthor(), qid, entity.getStartDate())).length > 0) {
                    this.ao.delete((RawEntity[])answersEntities);
                }
                entity.setStatus(2);
                if (timeOut) {
                    entity.setEndDate(entity.getStartDate() + (long)entity.getTimeLimit().intValue());
                } else if (overDue) {
                    entity.setEndDate(entity.getDueDate());
                } else {
                    entity.setEndDate(System.currentTimeMillis());
                }
                entity.save();
                try {
                    QuizHelper quizHelper = (QuizHelper)this.applicationContext.getBean("quiz-helper");
                    quizHelper.notifyOnCompletion(entity, new QuizFinishedStatus(entity, timeOut, overDue));
                }
                catch (Exception e) {
                    log.error("Fail to notify quiz authors", (Throwable)e);
                }
            } else if (entity.getStatus() == 0 && overDue) {
                entity.setStatus(4);
                entity.save();
            }
        }
    }

    private Long getNextQuestion(QuizStateEntity entity) {
        String[] questions = StringUtils.defaultString((String)entity.getQuestions()).split(",");
        if (questions.length == 0 || questions[0].isEmpty()) {
            return null;
        }
        return Long.valueOf(questions[0]);
    }

    private int updateAttempts(QuizStateEntity entity, Integer attempts) {
        int addedAttempts = 0;
        if (this.isNotDeleted(entity)) {
            if (entity.getAttemptsCount() != null) {
                addedAttempts = attempts - entity.getAttemptsCount();
                entity.setAttempts(entity.getAttempts() + addedAttempts);
            }
            entity.setAttemptsCount(attempts);
            entity.save();
        }
        return addedAttempts;
    }

    private boolean addAttempts(QuizStateEntity[] entities, Integer attempts) {
        boolean updated = false;
        for (QuizStateEntity entity : entities) {
            if (!this.isNotDeleted(entity) || entity.getAttempts() >= 2000000000) continue;
            entity.setAttempts(entity.getAttempts() + attempts);
            if (entity.getAttemptsCount() != null && entity.getAttemptsCount() != Integer.MAX_VALUE) {
                entity.setAttemptsCount(entity.getAttemptsCount() + attempts);
            }
            updated = true;
            entity.save();
        }
        return updated;
    }

    private boolean isNotDeleted(QuizStateEntity entity) {
        return entity.getDeleted() == null || entity.getDeleted() == false;
    }

    private boolean isCompleted(QuizStateEntity entity) {
        return entity.getCompleted() != null && entity.getCompleted() != false;
    }

    private boolean isOverDue(QuizStateEntity entity) {
        return entity.getDueDate() != null && DueDateHelper.isOverdue(entity.getDueDate());
    }

    private boolean isTimeOut(QuizStateEntity entity) {
        return entity.getTimeLimit() > 0 && entity.getStartDate() + (long)entity.getTimeLimit().intValue() < System.currentTimeMillis();
    }

    private void stopWatchingQuestion(Integer userId, Long quizId, long attempt) {
        QuizAnswersEntity[] entities = (QuizAnswersEntity[])this.ao.find(QuizAnswersEntity.class, Query.select().where("USER_ID = ? AND QUIZ_ID = ? AND ATTEMPT = ? AND WATCHING = ?", new Object[]{userId, quizId, attempt, Boolean.TRUE}).limit(1));
        if (entities.length == 1) {
            entities[0].setEndTime(System.currentTimeMillis());
            entities[0].setWatching(false);
            entities[0].save();
        }
    }

    private QuizStateEntity createRecord(Integer studentId, Long quizId, Integer authorId, List<Long> questions, QuizParams params, Long dueDate, Boolean selfEnrollment, Long courseId, Integer courseRecord) {
        QuizStateEntity entity = (QuizStateEntity)this.ao.create(QuizStateEntity.class, new DBParam[]{new DBParam("USER_ID", (Object)studentId), new DBParam("AUTHOR", (Object)authorId), new DBParam("QUIZ_ID", (Object)quizId), new DBParam("STATUS", (Object)0), new DBParam("CORRECT", (Object)0), new DBParam("ANSWERS", (Object)0)});
        String rawQuestions = Joiner.on((char)',').join(questions);
        entity.setQuestions(rawQuestions);
        entity.setAllQuestions(rawQuestions);
        entity.setTotal(questions.size());
        entity.setTarget(params.getTarget());
        entity.setTimeLimit(params.getTimeLimit());
        entity.setAttempts(params.getAttempts());
        entity.setAttemptsCount(params.getAttempts());
        entity.setShowRes(params.isShowRes());
        entity.setShowFeedback(params.isShowFeedback());
        entity.setSkip(params.isSkip());
        entity.setResubmit(params.isResubmit());
        entity.setRandom(params.isRandom());
        entity.setStartDate(System.currentTimeMillis());
        entity.setSkipStartPage(params.isSkipStartPage());
        entity.setSelfEnrollment(selfEnrollment);
        entity.setSessionId(entity.getID());
        entity.setDueDate(dueDate);
        entity.setCourseId(courseId);
        entity.setCourseRecord(courseRecord);
        entity.setEnrolledDate(System.currentTimeMillis());
        entity.save();
        return entity;
    }

    private QuizStateEntity finishTest(Integer studentId, Long quizId, Integer authorId, Integer recordId, Boolean giveUp) {
        QuizStateEntity entity = this.findState(studentId, quizId, recordId);
        this.finishTest(entity, giveUp);
        return entity;
    }

    private List<QuizAnswersEntity> findAnswers(Long quizId, Long questionId) {
        Query query = Query.select().alias(QuizAnswersEntity.class, "answer").alias(QuizStateEntity.class, "state").join(QuizStateEntity.class, "answer.ATTEMPT = state.START_DATE");
        if (quizId != null) {
            query.where("answer.QUIZ_ID = ? AND answer.QUESTION_ID = ? AND answer.PROGRESS = ? AND state.STATUS > ? AND NOT state.DELETED = ?", new Object[]{quizId, questionId, Boolean.FALSE, 1, Boolean.TRUE});
        } else {
            query.where("answer.QUESTION_ID = ? AND answer.PROGRESS = ? AND state.STATUS > ? AND NOT state.DELETED = ?", new Object[]{questionId, Boolean.FALSE, 1, Boolean.TRUE});
        }
        return Lists.newArrayList((Object[])this.ao.find(QuizAnswersEntity.class, query));
    }

    private Map<QuizStateEntity, DueDateChanges> updateDueDate(QuizStateEntity[] entities, String dueDate, String dueDays) {
        HashMap<QuizStateEntity, DueDateChanges> updatedAttempts = new HashMap<QuizStateEntity, DueDateChanges>();
        HashSet<Integer> ids = new HashSet<Integer>();
        for (QuizStateEntity entity : entities) {
            Long enrolledDate;
            UserEntity userEntity = this.userEntityService.getUser(entity.getUserId());
            ConfluenceUser user = userEntity.getExternal() != false ? null : this.userAccessor.getUserByKey(new UserKey(userEntity.getKey()));
            Long userDueDate = this.dueDateHelper.getUserDueDate(user, DueDateHelper.parseDueDate(dueDate, dueDays, enrolledDate = entity.getEnrolledDate() == null ? entity.getStartDate() : entity.getEnrolledDate()));
            if ((userDueDate == null || userDueDate.equals(entity.getDueDate())) && (entity.getDueDate() == null || entity.getDueDate().equals(userDueDate))) continue;
            DueDateChanges dueDateChanges = new DueDateChanges(this.dueDateHelper.formatDueDate(entity.getDueDate(), user), this.dueDateHelper.formatDueDate(userDueDate, user));
            entity.setDueDate(userDueDate);
            if (userDueDate != null && DueDateHelper.isOverdue(userDueDate)) {
                this.finishTest(entity, false);
            } else {
                if (entity.getStatus() == 4) {
                    entity.setStatus(0);
                }
                if (entity.getSessionId() == null || !ids.contains(entity.getSessionId())) {
                    updatedAttempts.put(entity, dueDateChanges);
                    ids.add(entity.getSessionId());
                }
            }
            entity.save();
        }
        return updatedAttempts;
    }
}

