/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.ao.service.quiz;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuestionCategory;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizQuestionMap;
import com.stiltsoft.confluence.quiz.ao.service.quiz.QuestionCategoryService;
import com.stiltsoft.confluence.quiz.ao.service.quiz.QuizQuestionMapService;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class DefaultQuizQuestionMapService
implements QuizQuestionMapService {
    private ActiveObjects ao;
    private QuestionCategoryService categoryService;

    public DefaultQuizQuestionMapService(ActiveObjects ao, QuestionCategoryService categoryService) {
        this.ao = ao;
        this.categoryService = categoryService;
    }

    @Override
    public void add(Long quizId, Long questionId, QuestionCategory category) {
        if (this.find(quizId, questionId).length == 0) {
            QuizQuestionMap map = (QuizQuestionMap)this.ao.create(QuizQuestionMap.class, new DBParam[0]);
            map.setQuizId(quizId);
            map.setQuestionId(questionId);
            map.setQuestionCategory(category);
            map.setPosition(map.getID());
            map.save();
        }
    }

    @Override
    public void remove(Long quizId, Long questionId) {
        QuizQuestionMap[] maps = this.find(quizId, questionId);
        if (maps.length > 0) {
            this.ao.delete((RawEntity[])maps);
        }
    }

    @Override
    public QuizQuestionMap[] getQuestions(Long quizId) {
        return (QuizQuestionMap[])this.ao.find(QuizQuestionMap.class, Query.select().where("QUIZ_ID = ?", new Object[]{quizId}).order("POSITION ASC"));
    }

    @Override
    public int getQuestionsCount(Long quizId) {
        return this.ao.count(QuizQuestionMap.class, Query.select().where("QUIZ_ID = ?", new Object[]{quizId}));
    }

    @Override
    public QuizQuestionMap[] getQuizzes(Long questionId) {
        return (QuizQuestionMap[])this.ao.find(QuizQuestionMap.class, Query.select().where("QUESTION_ID = ?", new Object[]{questionId}));
    }

    @Override
    public void reorder(Long quizId, List<Long> ids) {
        for (int i = 0; i < ids.size(); ++i) {
            QuizQuestionMap[] maps = this.find(quizId, ids.get(i));
            if (maps.length <= 0) continue;
            maps[0].setPosition(i);
            maps[0].save();
        }
    }

    @Override
    public void setCategory(Long quizId, Long id, Integer categoryId) {
        QuizQuestionMap[] maps = this.find(quizId, id);
        if (maps.length > 0) {
            maps[0].setQuestionCategory(this.categoryService.getDefaultCategory(quizId, categoryId));
            maps[0].save();
        }
    }

    private QuizQuestionMap[] find(Long quizId, Long questionId) {
        return (QuizQuestionMap[])this.ao.find(QuizQuestionMap.class, Query.select().where("QUIZ_ID = ? AND QUESTION_ID = ?", new Object[]{quizId, questionId}).limit(1));
    }
}

