/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.ao.service.quiz;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuestionCategory;
import com.stiltsoft.confluence.quiz.ao.service.quiz.QuestionCategoryService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class DefaultQuestionCategoryService
implements QuestionCategoryService {
    private ActiveObjects ao;

    public DefaultQuestionCategoryService(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public QuestionCategory[] getQuestionCategories(Long quizId) {
        return (QuestionCategory[])this.ao.find(QuestionCategory.class, Query.select().where("QUIZ_ID = ?", new Object[]{quizId}).order("ORDER ASC"));
    }

    @Override
    public QuestionCategory getDefaultCategory(Long quizId, Integer categoryId) {
        QuestionCategory[] categories;
        if (categoryId != null && (categories = this.find(quizId, categoryId)).length > 0) {
            return categories[0];
        }
        categories = this.getQuestionCategories(quizId);
        if (categories.length == 0) {
            return this.create(quizId, "");
        }
        return categories[0];
    }

    @Override
    public QuestionCategory create(Long quizId, String name) {
        QuestionCategory category = (QuestionCategory)this.ao.create(QuestionCategory.class, new DBParam[0]);
        category.setQuizId(quizId);
        category.setName(name);
        category.setOrder(category.getID());
        category.save();
        return category;
    }

    @Override
    public void rename(Long quizId, int id, String name) {
        QuestionCategory[] categories = this.find(quizId, id);
        if (categories.length > 0) {
            categories[0].setName(name);
            categories[0].save();
        }
    }

    @Override
    public void reorder(Long quizId, List<Integer> ids) {
        for (int i = 0; i < ids.size(); ++i) {
            QuestionCategory[] categories = this.find(quizId, ids.get(i));
            if (categories.length <= 0) continue;
            categories[0].setOrder(i);
            categories[0].save();
        }
    }

    @Override
    public int remove(Long quizId, List<Integer> ids) {
        QuestionCategory[] categories;
        ArrayList<Number> params = new ArrayList<Number>();
        params.add(quizId);
        params.addAll(ids);
        for (QuestionCategory category : categories = (QuestionCategory[])this.ao.find(QuestionCategory.class, Query.select().where("QUIZ_ID = ? AND ID IN (" + ids.stream().map(v -> "?").collect(Collectors.joining(", ")) + ")", params.toArray()))) {
            this.ao.delete((RawEntity[])category.getQuizQuestionMap());
        }
        this.ao.delete((RawEntity[])categories);
        return this.getDefaultCategory(quizId, 0).getID();
    }

    @Override
    public QuestionCategory[] find(Long quizId, Integer id) {
        return (QuestionCategory[])this.ao.find(QuestionCategory.class, Query.select().where("QUIZ_ID = ? AND ID = ?", new Object[]{quizId, id}).limit(1));
    }
}

