/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.ao.service.learning;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.stiltsoft.confluence.quiz.ao.entity.course.CategoryToCourse;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseCategory;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseModule;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseSettings;
import com.stiltsoft.confluence.quiz.ao.service.learning.LearningService;
import com.stiltsoft.confluence.quiz.entity.course.CourseSelfEnrollmentType;
import com.stiltsoft.confluence.quiz.manager.CourseLearningAccessibilityHelper;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import net.java.ao.EntityStreamCallback;
import net.java.ao.Query;

public class DefaultLearningService
implements LearningService {
    private ActiveObjects ao;
    private CourseLearningAccessibilityHelper courseLearningAccessibilityHelper;

    public DefaultLearningService(ActiveObjects ao, CourseLearningAccessibilityHelper courseLearningAccessibilityHelper) {
        this.ao = ao;
        this.courseLearningAccessibilityHelper = courseLearningAccessibilityHelper;
    }

    @Override
    public Map<CourseSettings, CourseCategory[]> getAvailableCourses(final Integer categoryId) {
        final HashSet ids = new HashSet();
        final LinkedHashMap<CourseSettings, CourseCategory[]> settingsMap = new LinkedHashMap<CourseSettings, CourseCategory[]>();
        Query query = Query.select((String)"ID, COURSE_ID, IMAGE, SELF_ENROLLMENT_TYPE, SELF_ENROLLMENT_GROUPS").order("ID ASC").alias(CourseSettings.class, "settings").alias(CourseModule.class, "module").join(CourseModule.class, "settings.COURSE_ID = module.COURSE_ID");
        if (categoryId == null || categoryId == -1) {
            query.where("settings.SELF_ENROLLMENT_TYPE != ?", new Object[]{CourseSelfEnrollmentType.NO_ONE});
        } else {
            query.alias(CategoryToCourse.class, "ctc").join(CategoryToCourse.class, "settings.ID = ctc.COURSE_SETTINGS_ID").where("settings.SELF_ENROLLMENT_TYPE != ? AND ctc.COURSE_CATEGORY_ID = ?", new Object[]{CourseSelfEnrollmentType.NO_ONE, categoryId});
        }
        this.ao.stream(CourseSettings.class, query, (EntityStreamCallback)new EntityStreamCallback<CourseSettings, Integer>(){

            public void onRowRead(CourseSettings settings) {
                if (DefaultLearningService.this.courseLearningAccessibilityHelper.isAvailableForCurrentUser(settings) && !ids.contains(settings.getID())) {
                    ids.add(settings.getID());
                    CourseCategory[] categories = (CourseCategory[])DefaultLearningService.this.ao.find(CourseCategory.class, Query.select().alias(CourseCategory.class, "category").alias(CategoryToCourse.class, "ctc").join(CategoryToCourse.class, "category.ID = ctc.COURSE_CATEGORY_ID").where("ctc.COURSE_SETTINGS_ID = ?", new Object[]{settings.getID()}).distinct());
                    if (categoryId == null || categoryId != -1 || categories.length == 0) {
                        settingsMap.put(settings, categories);
                    }
                }
            }
        });
        return settingsMap;
    }
}

