/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.ao.service.course;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.stiltsoft.confluence.quiz.ao.dao.CourseAnswersDao;
import com.stiltsoft.confluence.quiz.ao.dao.CourseStateEntityDao;
import com.stiltsoft.confluence.quiz.ao.entity.UserEntity;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseAnswers;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseModule;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseSection;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseSettings;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseStateEntity;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizStateEntity;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseModuleService;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseSectionService;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseSettingsService;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseStateEntityService;
import com.stiltsoft.confluence.quiz.ao.service.course.DefaultCourseModuleService;
import com.stiltsoft.confluence.quiz.ao.service.quiz.QuizService;
import com.stiltsoft.confluence.quiz.ao.service.quiz.ReminderService;
import com.stiltsoft.confluence.quiz.entity.DueDateChanges;
import com.stiltsoft.confluence.quiz.entity.Status;
import com.stiltsoft.confluence.quiz.entity.StatusHistoryEvent;
import com.stiltsoft.confluence.quiz.entity.course.CourseEnrollWrapper;
import com.stiltsoft.confluence.quiz.entity.quiz.QuizParams;
import com.stiltsoft.confluence.quiz.manager.ConfluenceContentSearcher;
import com.stiltsoft.confluence.quiz.manager.QuizHelper;
import com.stiltsoft.confluence.quiz.manager.QuizMacroManager;
import com.stiltsoft.confluence.quiz.manager.UserEntityService;
import com.stiltsoft.confluence.quiz.utils.DueDateHelper;
import com.stiltsoft.confluence.quiz.utils.NumberHelper;
import com.stiltsoft.confluence.quiz.utils.StatusHistoryHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.java.ao.DBParam;
import net.java.ao.EntityStreamCallback;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCourseStateEntityService
implements CourseStateEntityService {
    private static final Logger log = LoggerFactory.getLogger(DefaultCourseStateEntityService.class);
    private static final int ENTITY_DELETE_LIMIT = 100;
    private static final int SEARCH_OVERDUE_ENTITY_LIMIT = 100;
    private static final int PREVIOUS_STATUS_INDEX = 1;
    private ActiveObjects ao;
    private QuizService quizService;
    private UserEntityService userEntityService;
    private CourseSectionService sectionService;
    private CourseSettingsService courseSettingsService;
    private CourseModuleService moduleService;
    private QuizHelper quizHelper;
    private QuizMacroManager quizMacroManager;
    private ConfluenceContentSearcher confluenceContentSearcher;
    private PageManager pageManager;
    private UserAccessor userAccessor;
    private ReminderService reminderService;
    private DueDateHelper dueDateHelper;
    private CourseStateEntityDao courseStateEntityDao;
    private CourseAnswersDao courseAnswersDao;

    public DefaultCourseStateEntityService(ActiveObjects ao, QuizService quizService, UserEntityService userEntityService, CourseSectionService sectionService, CourseSettingsService courseSettingsService, CourseModuleService moduleService, QuizHelper quizHelper, QuizMacroManager quizMacroManager, ConfluenceContentSearcher confluenceContentSearcher, PageManager pageManager, UserAccessor userAccessor, ReminderService reminderService, DueDateHelper dueDateHelper, CourseStateEntityDao courseStateEntityDao, CourseAnswersDao courseAnswersDao) {
        this.ao = ao;
        this.quizService = quizService;
        this.userEntityService = userEntityService;
        this.sectionService = sectionService;
        this.courseSettingsService = courseSettingsService;
        this.moduleService = moduleService;
        this.quizHelper = quizHelper;
        this.quizMacroManager = quizMacroManager;
        this.confluenceContentSearcher = confluenceContentSearcher;
        this.pageManager = pageManager;
        this.userAccessor = userAccessor;
        this.reminderService = reminderService;
        this.dueDateHelper = dueDateHelper;
        this.courseStateEntityDao = courseStateEntityDao;
        this.courseAnswersDao = courseAnswersDao;
    }

    @Override
    public List<CourseStateEntity> enroll(Long courseId, List<ConfluenceUser> users, String author) throws Exception {
        ArrayList<CourseStateEntity> entities = new ArrayList<CourseStateEntity>();
        HashMap<Long, AbstractPage> pageMap = new HashMap<Long, AbstractPage>();
        HashMap<Long, CourseSection[]> sectionsMap = new HashMap<Long, CourseSection[]>();
        HashMap<Integer, CourseModule[]> modulesMap = new HashMap<Integer, CourseModule[]>();
        Integer authorId = this.userEntityService.getUserId(author);
        CourseSettings settings = this.courseSettingsService.getOrCreate(courseId);
        for (ConfluenceUser user : users) {
            Long dueDate = this.dueDateHelper.getUserDueDate(user, settings.getDueDate(), settings.getDueDays());
            entities.add(this.createRecord(courseId, user.getKey().getStringValue(), user.getEmail(), authorId, pageMap, sectionsMap, modulesMap, settings, dueDate));
        }
        return entities;
    }

    @Override
    public int enroll(Long courseId, String student, String studentName, String author, ConfluenceUser participant) throws Exception {
        Integer authorId = this.userEntityService.getUserId(author);
        CourseSettings settings = this.courseSettingsService.getOrCreate(courseId);
        Long dueDate = this.dueDateHelper.getUserDueDate(participant, settings.getDueDate(), settings.getDueDays());
        return this.createRecord(courseId, student, studentName, authorId, new HashMap<Long, AbstractPage>(), new HashMap<Long, CourseSection[]>(), new HashMap<Integer, CourseModule[]>(), settings, dueDate).getID();
    }

    @Override
    public CourseStateEntity[] getActualStates(Long courseId, String userKey) {
        return (CourseStateEntity[])this.ao.find(CourseStateEntity.class, Query.select().where("COURSE_ID = ? AND USER_ID = ? AND DELETED = ?", new Object[]{courseId, this.userEntityService.getUserId(userKey), Boolean.FALSE}));
    }

    @Override
    public Set<Integer> getActualEnrolledUserIds(Long courseId) {
        final HashSet<Integer> ids = new HashSet<Integer>();
        this.ao.stream(CourseStateEntity.class, Query.select((String)"ID, USER_ID").where("COURSE_ID = ? AND DELETED = ?", new Object[]{courseId, Boolean.FALSE}), (EntityStreamCallback)new EntityStreamCallback<CourseStateEntity, Integer>(){

            public void onRowRead(CourseStateEntity entity) {
                ids.add(entity.getUserId());
            }
        });
        return ids;
    }

    @Override
    public CourseStateEntity getLatestActualStates(Long courseId, String userKey) {
        CourseStateEntity[] entities = (CourseStateEntity[])this.ao.find(CourseStateEntity.class, Query.select().where("COURSE_ID = ? AND USER_ID = ? AND DELETED = ?", new Object[]{courseId, this.userEntityService.getUserId(userKey), Boolean.FALSE}).limit(1).order("ID DESC"));
        return entities.length == 0 ? null : entities[0];
    }

    @Override
    public Optional<CourseEnrollWrapper> start(Integer studentId, Long courseId, Integer recordId) {
        Optional<CourseStateEntity> entityOpt = this.courseStateEntityDao.getCourseStateEntity(studentId, courseId, recordId);
        if (!entityOpt.isPresent()) {
            return Optional.empty();
        }
        CourseStateEntity entity = entityOpt.get();
        if (entity.getStatus() == 0 && !this.isOverdue(entity.getDueDate())) {
            CourseAnswers[] answers = this.getAnswers(studentId, courseId, entity.getAuthor(), entity.getStartDate());
            entity.setDeletedByUser(false);
            this.setStatus(entity, 1);
            entity.save();
            for (CourseAnswers answer : answers) {
                answer.setAttempt(entity.getStartDate());
                answer.save();
            }
            return Optional.of(new CourseEnrollWrapper(entity));
        }
        return Optional.empty();
    }

    @Override
    public Optional<CourseEnrollWrapper> getCourseEnrollWrapper(Integer studentId, Long courseId, Integer recordId) {
        return this.courseStateEntityDao.getCourseStateEntity(studentId, courseId, recordId).map(CourseEnrollWrapper::new);
    }

    @Override
    public CourseAnswers startAnswer(Integer studentId, Long courseId, Integer authorId, Long moduleId, int pageVersion, CourseEnrollWrapper courseEnrollWrapper) throws Exception {
        if (courseEnrollWrapper.getStatus() == 4) {
            return null;
        }
        CourseModule[] modules = courseEnrollWrapper.getCourseModules();
        CourseAnswers entity = this.getAnswer(studentId, courseId, authorId, moduleId, courseEnrollWrapper.getStartDate())[0];
        if (modules.length == 0) {
            return entity;
        }
        CourseModule module = modules[0];
        CourseSettings settings = this.courseSettingsService.getOrCreate(courseId);
        if (settings.getOrder() == null || settings.getOrder() == 0) {
            if (!module.getModuleId().equals(moduleId)) {
                return entity.getProgress() != 0 ? entity : null;
            }
        } else {
            for (CourseModule cm : modules) {
                if (!cm.getModuleId().equals(moduleId)) continue;
                module = cm;
                break;
            }
        }
        if (entity.getProgress() == 0) {
            entity.setProgress(1);
            entity.setWatching(true);
            entity.setStartTime(System.currentTimeMillis());
            entity.setEndTime(System.currentTimeMillis());
            entity.setPageVersion(pageVersion);
            if (module.getType().equals(DefaultCourseModuleService.QUIZ_MODULE) && entity.getQuizStateId() == null) {
                this.createQuizRecord(entity, module, studentId, courseId, authorId, courseEnrollWrapper.getID());
            }
            entity.save();
        }
        return entity;
    }

    @Override
    public Optional<CourseAnswers> saveAnswer(Integer studentId, Long courseId, Integer authorId, Long moduleId, long attempt, CourseEnrollWrapper courseEnrollWrapper) {
        Optional<CourseAnswers> courseAnswersOpt;
        if (courseEnrollWrapper.getStatus() == 4) {
            return Optional.empty();
        }
        CourseStateEntity courseStateEntity = courseEnrollWrapper.getEntity();
        CourseAnswers entity = this.getAnswer(studentId, courseId, authorId, moduleId, attempt)[0];
        if (entity.getProgress() != 1) {
            return Optional.empty();
        }
        if (entity.getType().equals(DefaultCourseModuleService.PAGE_MODULE)) {
            courseAnswersOpt = this.courseAnswersDao.saveAnswer(entity, courseStateEntity);
        } else {
            QuizStateEntity quizStateEntity = this.quizService.getStateTx(studentId, entity.getModuleId(), authorId, entity.getQuizStateId());
            Optional<Object> optional = courseAnswersOpt = quizStateEntity.getStatus() == 2 ? this.courseAnswersDao.saveAnswer(entity, quizStateEntity, courseStateEntity) : Optional.empty();
        }
        if (courseAnswersOpt.isPresent() && courseStateEntity.getCourseModules().length == 0) {
            this.setStatus(courseStateEntity, 2);
            courseStateEntity.save();
        }
        return courseAnswersOpt;
    }

    @Override
    public Optional<CourseAnswers> moveToModule(Integer studentId, Long courseId, Integer authorId, Long moduleId, CourseEnrollWrapper courseEnrollWrapper) {
        if (courseEnrollWrapper.getStatus() == 4) {
            return Optional.empty();
        }
        CourseAnswers entity = this.getAnswer(studentId, courseId, authorId, moduleId, courseEnrollWrapper.getStartDate())[0];
        CourseAnswers[] watchings = this.findWatchingAnswer(studentId, courseId, authorId, courseEnrollWrapper.getStartDate());
        if (watchings.length > 0) {
            CourseAnswers watching = watchings[0];
            watching.setWatching(false);
            watching.setEndTime(System.currentTimeMillis());
            watching.save();
        }
        entity.setWatching(true);
        entity.setWastedTime(entity.getWastedTime() + entity.getEndTime() - entity.getStartTime());
        entity.setStartTime(System.currentTimeMillis());
        entity.setEndTime(System.currentTimeMillis());
        entity.save();
        return Optional.of(entity);
    }

    @Override
    public CourseAnswers[] getAnswers(Long courseId, Long moduleId) {
        return (CourseAnswers[])this.ao.find(CourseAnswers.class, Query.select().where("COURSE_ID = ? AND MODULE_ID = ?", new Object[]{courseId, moduleId}));
    }

    @Override
    public CourseAnswers[] getAnswers(Long courseId, Integer userId, long attempt) {
        return (CourseAnswers[])this.ao.find(CourseAnswers.class, Query.select().where("COURSE_ID = ? AND USER_ID = ? AND ATTEMPT = ? AND (PROGRESS = ? OR PROGRESS = ?)", new Object[]{courseId, userId, attempt, 2, 1}));
    }

    @Override
    public List<CourseEnrollWrapper> getCourseEnrollWrappers(List<Long> courseIds, List<Integer> studentIds, int start, int limit) {
        return this.courseStateEntityDao.getCourseStateEntities(courseIds, studentIds, start, limit).stream().map(CourseEnrollWrapper::new).collect(Collectors.toList());
    }

    @Override
    public int countStates(List<Long> courseIds, List<Integer> studentIds) {
        if (courseIds.isEmpty()) {
            return 0;
        }
        Query query = !studentIds.isEmpty() ? Query.select().where("COURSE_ID IN (" + NumberHelper.joinNumbersByComma(courseIds) + ") AND USER_ID IN (" + NumberHelper.joinNumbersByComma(studentIds) + ") AND DELETED = ?", new Object[]{Boolean.FALSE}) : Query.select().where("COURSE_ID IN (" + NumberHelper.joinNumbersByComma(courseIds) + ") AND DELETED = ?", new Object[]{Boolean.FALSE});
        return this.ao.count(CourseStateEntity.class, query);
    }

    @Override
    public void delete(Long courseId, List<Integer> ids) {
        List<Integer> idsSubList;
        int part = 0;
        do {
            CourseStateEntity[] entities;
            idsSubList = this.getSubList(part, ids);
            for (CourseStateEntity entity : entities = (CourseStateEntity[])this.ao.find(CourseStateEntity.class, Query.select().where("ID IN (" + NumberHelper.joinNumbersByComma(idsSubList) + ") AND COURSE_ID = ? AND DELETED = ?", new Object[]{courseId, Boolean.FALSE}))) {
                entity.setDeleted(true);
                entity.save();
                for (CourseAnswers answers : this.getAnswers(entity.getUserId(), courseId, entity.getAuthor(), entity.getStartDate())) {
                    QuizStateEntity quizStateEntity;
                    answers.setDeleted(true);
                    answers.save();
                    if (!answers.getType().equals(DefaultCourseModuleService.QUIZ_MODULE) || (quizStateEntity = this.quizService.getStateNoTx(entity.getUserId(), answers.getModuleId(), entity.getAuthor(), answers.getQuizStateId())) == null) continue;
                    quizStateEntity.setDeleted(true);
                    quizStateEntity.save();
                }
            }
            ++part;
        } while (idsSubList.size() >= 100);
    }

    @Override
    public void deleteByUser(String userKey, List<Integer> ids) {
        int userId = this.userEntityService.getUserId(userKey);
        for (int id : ids) {
            CourseStateEntity entity = ((CourseStateEntity[])this.ao.find(CourseStateEntity.class, Query.select().where("ID = ? AND USER_ID = ? AND DELETED = ?", new Object[]{id, userId, Boolean.FALSE}).limit(1)))[0];
            entity.setDeletedByUser(true);
            entity.save();
        }
    }

    @Override
    public CourseAnswers[] getAnswer(Integer userId, Long courseId, Integer authorId, Long moduleId, long attempt) {
        return (CourseAnswers[])this.ao.find(CourseAnswers.class, Query.select().where("USER_ID = ? AND COURSE_ID = ? AND AUTHOR = ? AND MODULE_ID = ? AND ATTEMPT = ?", new Object[]{userId, courseId, authorId, moduleId, attempt}).limit(1));
    }

    @Override
    public List<CourseEnrollWrapper> getCourseEnrollWrappersByUser(String userKey) {
        int userId = this.userEntityService.getUserId(userKey);
        return this.courseStateEntityDao.getCourseStateEntitiesByUser(userId).stream().map(CourseEnrollWrapper::new).collect(Collectors.toList());
    }

    @Override
    public CourseAnswers[] findWatchingAnswer(Integer userId, Long courseId, Integer authorId, long attempt) {
        return (CourseAnswers[])this.ao.find(CourseAnswers.class, Query.select().where("USER_ID = ? AND COURSE_ID = ? AND AUTHOR = ? AND ATTEMPT = ? AND WATCHING = ?", new Object[]{userId, courseId, authorId, attempt, Boolean.TRUE}).limit(1));
    }

    @Override
    public Optional<CourseStateEntity> getUnfinishedState(Integer id) {
        CourseStateEntity[] entities = (CourseStateEntity[])this.ao.find(CourseStateEntity.class, Query.select().where("ID = ? AND DELETED = ? AND STATUS < ?", new Object[]{id, Boolean.FALSE, 2}).limit(1));
        return entities.length > 0 ? Optional.of(entities[0]) : Optional.empty();
    }

    @Override
    public Map<CourseEnrollWrapper, DueDateChanges> updateDueDateAndGetUpdated(Long courseId, String dueDate, String dueDays) {
        List<CourseStateEntity> entities = Arrays.stream(this.ao.find(CourseStateEntity.class, Query.select().where("COURSE_ID = ? AND STATUS != ? AND DELETED = ?", new Object[]{courseId, 2, Boolean.FALSE}))).collect(Collectors.toList());
        return this.updateDueDate(entities, dueDate, dueDays);
    }

    @Override
    public void updateOverdueEntities() {
        List<CourseStateEntity> entities;
        int offset = 0;
        do {
            entities = this.courseStateEntityDao.getCourseStateEntitiesOverdueByTime(offset, 100);
            for (CourseStateEntity entity : entities) {
                this.setStatus(entity, 4);
                entity.save();
            }
            offset += 100;
        } while (entities.size() == 100);
    }

    private List<Integer> getSubList(int part, List<Integer> ids) {
        int start = Math.min(part * 100, ids.size());
        int end = Math.min((part + 1) * 100, ids.size());
        return ids.subList(start, end);
    }

    private Map<CourseEnrollWrapper, DueDateChanges> updateDueDate(List<CourseStateEntity> entities, String dueDate, String dueDays) {
        HashMap<CourseEnrollWrapper, DueDateChanges> updated = new HashMap<CourseEnrollWrapper, DueDateChanges>();
        HashSet<Integer> ids = new HashSet<Integer>();
        for (CourseStateEntity entity : entities) {
            UserEntity userEntity = this.userEntityService.getUser(entity.getUserId());
            ConfluenceUser user = userEntity.getExternal() != false ? null : this.userAccessor.getUserByKey(new UserKey(userEntity.getKey()));
            Long userDueDate = this.dueDateHelper.getUserDueDate(user, DueDateHelper.parseDueDate(dueDate, dueDays, entity.getEnrolledDate()));
            if ((userDueDate == null || userDueDate.equals(entity.getDueDate())) && (entity.getDueDate() == null || entity.getDueDate().equals(userDueDate))) continue;
            DueDateChanges dueDateChanges = new DueDateChanges(this.dueDateHelper.formatDueDate(entity.getDueDate(), user), this.dueDateHelper.formatDueDate(userDueDate, user));
            this.setDueDate(entity, userDueDate);
            entity.save();
            if (this.isOverdue(entity.getDueDate()) || ids.contains(entity.getID())) continue;
            updated.put(new CourseEnrollWrapper(entity), dueDateChanges);
            ids.add(entity.getID());
        }
        return updated;
    }

    private void setDueDate(CourseStateEntity entity, Long dueDate) {
        if (entity.getStatus() == 2) {
            return;
        }
        if (this.isOverdue(dueDate)) {
            if (Status.isActive(entity)) {
                entity.setStatus(4);
                entity.setStatusHistory(StatusHistoryHelper.generateStatusHistory(4, entity));
            }
            entity.setEndDate(dueDate);
        } else if (entity.getStatus() == 4) {
            DefaultCourseStateEntityService.getPreviousStatusHistoryEvent(entity).ifPresent(event -> this.setStatus(entity, event.getStatus()));
            entity.setEndDate(null);
        }
        entity.setDueDate(dueDate);
    }

    private static Optional<StatusHistoryEvent> getPreviousStatusHistoryEvent(CourseStateEntity entity) {
        String[] statusEvents = entity.getStatusHistory().split(",");
        if (statusEvents.length > 1) {
            return Optional.of(new StatusHistoryEvent(statusEvents[1]));
        }
        return Optional.empty();
    }

    private void setStatus(CourseStateEntity entity, int status) {
        long currentTime = System.currentTimeMillis();
        if (status == 1 && !StatusHistoryHelper.wasStartedEntity(entity)) {
            entity.setStartDate(currentTime);
        } else if (status == 2) {
            entity.setCompletedDate(currentTime);
            entity.setEndDate(currentTime);
        } else if (status == 4) {
            entity.setEndDate(currentTime);
        }
        entity.setStatus(status);
        entity.setStatusHistory(StatusHistoryHelper.generateStatusHistory(status, entity));
    }

    private boolean isOverdue(Long dueDate) {
        return dueDate != null && DueDateHelper.isOverdue(dueDate);
    }

    private CourseAnswers[] getAnswers(Integer userId, Long courseId, Integer authorId, Long attempt) {
        return (CourseAnswers[])this.ao.find(CourseAnswers.class, Query.select().where("USER_ID = ? AND COURSE_ID = ? AND AUTHOR = ? AND ATTEMPT = ?", new Object[]{userId, courseId, authorId, attempt}));
    }

    private CourseStateEntity createRecord(Long courseId, String student, String studentName, Integer authorId, Map<Long, AbstractPage> pageMap, Map<Long, CourseSection[]> sectionMap, Map<Integer, CourseModule[]> modulesMap, CourseSettings settings, Long dueDate) throws Exception {
        Integer studentId = this.userEntityService.getUserId(student, studentName);
        CourseStateEntity entity = this.courseStateEntityDao.create(studentId, authorId, courseId, dueDate);
        if (!sectionMap.containsKey(courseId)) {
            sectionMap.put(courseId, this.sectionService.getNoTx(courseId));
        }
        for (CourseSection section : sectionMap.get(courseId)) {
            CourseModule[] sectionModules;
            if (!modulesMap.containsKey(section.getID())) {
                modulesMap.put(section.getID(), section.getCourseModules());
            }
            if ((sectionModules = modulesMap.get(section.getID())).length <= 0) continue;
            int sectionId = this.sectionService.addSectionNoTx(Long.valueOf(entity.getID()), section.getName());
            boolean sectionHasModules = false;
            for (CourseModule module : modulesMap.get(section.getID())) {
                AbstractPage page;
                if (!pageMap.containsKey(module.getModuleId())) {
                    pageMap.put(module.getModuleId(), this.pageManager.getAbstractPage(module.getModuleId().longValue()));
                }
                if ((page = pageMap.get(module.getModuleId())) == null) {
                    this.moduleService.removeNoTx(courseId, module.getID());
                    continue;
                }
                if (page.isDeleted()) continue;
                this.moduleService.addNoTx(Long.valueOf(entity.getID()), module.getModuleId(), module.getType(), sectionId);
                this.moduleService.addNoTx(Long.valueOf(entity.getID()), module.getModuleId(), module.getType(), null);
                CourseAnswers answers = (CourseAnswers)this.ao.create(CourseAnswers.class, new DBParam[]{new DBParam("USER_ID", (Object)studentId), new DBParam("COURSE_ID", (Object)courseId), new DBParam("AUTHOR", (Object)authorId), new DBParam("ATTEMPT", (Object)entity.getStartDate()), new DBParam("PROGRESS", (Object)0), new DBParam("MODULE_ID", (Object)module.getModuleId()), new DBParam("WATCHING", (Object)false), new DBParam("WASTED_TIME", (Object)0L), new DBParam("TYPE", (Object)module.getType()), new DBParam("DELETED", (Object)false)});
                if (module.getType().equals(DefaultCourseModuleService.QUIZ_MODULE) && answers.getQuizStateId() == null) {
                    this.createQuizRecord(answers, module, studentId, courseId, authorId, entity.getID());
                }
                sectionHasModules = true;
            }
            if (sectionHasModules) continue;
            this.sectionService.removeNoTx(Long.valueOf(entity.getID()), sectionId);
        }
        this.reminderService.setCourseReminders(settings, entity);
        return entity;
    }

    private void createQuizRecord(CourseAnswers entity, CourseModule module, Integer studentId, Long courseId, Integer authorId, Integer recordId) throws Exception {
        Page page = this.pageManager.getPage(module.getModuleId().longValue());
        QuizParams params = this.quizMacroManager.getQuizParams((ContentEntityObject)page);
        params.setDisableTakeNotification("true");
        params.setAnonymousConfirmation("true");
        ConfluenceUser author = this.userAccessor.getUserByKey(new UserKey(this.userEntityService.getUser(authorId).getKey()));
        List<AbstractPage> results = this.confluenceContentSearcher.findStructuredQuestions(page.getId(), author).getQuestions();
        UserEntity userEntity = this.userEntityService.getUser(studentId);
        ConfluenceUser participant = userEntity.getExternal() != false ? null : this.userAccessor.getUserByKey(new UserKey(userEntity.getKey()));
        int qrId = this.quizHelper.createQuizRecord(params, results, participant, userEntity.getKey(), "", userEntity.getName(), page, author, true, courseId, recordId);
        entity.setQuizStateId(qrId);
        entity.save();
    }
}

