/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.ao.service.course;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.AttachmentResource;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.InputStreamAttachmentResource;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.FileUploadManager;
import com.stiltsoft.confluence.quiz.ao.entity.course.CategoryToCourse;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseSettings;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseSettingsService;
import com.stiltsoft.confluence.quiz.entity.course.CourseImage;
import com.stiltsoft.confluence.quiz.entity.course.CourseSelfEnrollmentType;
import com.stiltsoft.confluence.quiz.utils.NumberHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCourseSettingsService
implements CourseSettingsService {
    private static final Logger log = LoggerFactory.getLogger(DefaultCourseSettingsService.class);
    private ActiveObjects ao;
    private AttachmentManager attachmentManager;
    private FileUploadManager fileUploadManager;

    public DefaultCourseSettingsService(ActiveObjects ao, AttachmentManager attachmentManager, FileUploadManager fileUploadManager) {
        this.ao = ao;
        this.attachmentManager = attachmentManager;
        this.fileUploadManager = fileUploadManager;
    }

    @Override
    public void setExpanded(Long courseId, Boolean expanded) {
        CourseSettings courseSettings = this.findOrCreate(courseId);
        courseSettings.setExpanded(expanded);
        courseSettings.save();
    }

    @Override
    public void setDesc(Long courseId, String desc) {
        CourseSettings courseSettings = this.findOrCreate(courseId);
        courseSettings.setDesc(desc);
        courseSettings.save();
    }

    @Override
    public void setOrder(Long courseId, Integer order) {
        CourseSettings courseSettings = this.findOrCreate(courseId);
        courseSettings.setOrder(order);
        courseSettings.save();
    }

    @Override
    public void setReminderDesc(Long courseId, String desc) {
        CourseSettings courseSettings = this.findOrCreate(courseId);
        courseSettings.setReminderDesc(desc);
        courseSettings.save();
    }

    @Override
    public void setReminderDays(Long courseId, Integer days) {
        CourseSettings courseSettings = this.findOrCreate(courseId);
        courseSettings.setReminderDays(days);
        courseSettings.save();
    }

    @Override
    public void addCategory(Long courseId, Integer categoryId) {
        CourseSettings courseSettings = this.findOrCreate(courseId);
        this.ao.create(CategoryToCourse.class, new DBParam[]{new DBParam("COURSE_SETTINGS_ID", (Object)courseSettings.getID()), new DBParam("COURSE_CATEGORY_ID", (Object)categoryId)});
    }

    @Override
    public void deleteCategory(Long courseId, Integer categoryId) {
        CourseSettings courseSettings = this.findOrCreate(courseId);
        this.ao.delete(this.ao.find(CategoryToCourse.class, Query.select().where("COURSE_SETTINGS_ID = ? AND COURSE_CATEGORY_ID = ?", new Object[]{courseSettings.getID(), categoryId}).limit(1)));
    }

    @Override
    public void setDueDate(Long courseId, String dueDate) {
        CourseSettings courseSettings = this.findOrCreate(courseId);
        courseSettings.setDueDate(dueDate);
        courseSettings.save();
    }

    @Override
    public void setDueDays(Long courseId, String dueDays) {
        CourseSettings courseSettings = this.findOrCreate(courseId);
        courseSettings.setDueDays(dueDays);
        courseSettings.save();
    }

    @Override
    public void setSelfEnrollmentType(Long courseId, Integer type) {
        CourseSettings courseSettings = this.findOrCreate(courseId);
        courseSettings.setSelfEnrollmentType(type != null ? type : 0);
        courseSettings.save();
    }

    @Override
    public void setSelfEnrollmentGroups(Long courseId, String groups) {
        CourseSettings courseSettings = this.findOrCreate(courseId);
        courseSettings.setSelfEnrollmentGroups(groups);
        courseSettings.save();
    }

    @Override
    public String setImage(AbstractPage page, CourseImage courseImage) {
        String base64Data = courseImage.getImageDataURI().substring(courseImage.getImageDataURI().indexOf(",") + 1);
        byte[] imageBytes = Base64.decodeBase64((String)base64Data);
        ByteArrayInputStream stream = new ByteArrayInputStream(imageBytes);
        InputStreamAttachmentResource attachmentResource = new InputStreamAttachmentResource((InputStream)stream, courseImage.getName(), "image/png", (long)imageBytes.length);
        this.fileUploadManager.storeResource((AttachmentResource)attachmentResource, (ContentEntityObject)page);
        Attachment attachment = this.attachmentManager.getAttachment((ContentEntityObject)page, attachmentResource.getFilename());
        CourseSettings courseSettings = this.getOrCreate(courseImage.getCourseId());
        courseSettings.setImage(attachment.getDownloadPath());
        courseSettings.save();
        try {
            ((InputStream)stream).close();
        }
        catch (IOException e) {
            log.error("Failed to close input stream", (Throwable)e);
        }
        return attachment.getDownloadPath();
    }

    @Override
    public CourseSettings getOrCreate(Long courseId) {
        return this.findOrCreate(courseId);
    }

    @Override
    public Optional<CourseSettings> get(Long courseId) {
        if (courseId != null) {
            CourseSettings[] settings = (CourseSettings[])this.ao.find(CourseSettings.class, Query.select().where("COURSE_ID = ?", new Object[]{courseId}).order("ID ASC").limit(1));
            return settings.length > 0 ? Optional.of(settings[0]) : Optional.empty();
        }
        return Optional.empty();
    }

    @Override
    public Map<Long, CourseSettings> getCourseSettingsByCourseIdsMap(List<Long> courseIds) {
        CourseSettings[] entities = (CourseSettings[])this.ao.find(CourseSettings.class, Query.select().where("COURSE_ID IN (" + NumberHelper.joinNumbersByComma(courseIds) + ")", new Object[0]));
        return Stream.of(entities).collect(Collectors.toMap(CourseSettings::getCourseId, Function.identity(), (first, second) -> first.getID() < second.getID() ? first : second));
    }

    private CourseSettings findOrCreate(Long courseId) {
        CourseSettings[] settings = (CourseSettings[])this.ao.find(CourseSettings.class, Query.select().where("COURSE_ID = ?", new Object[]{courseId}).order("ID ASC").limit(1));
        if (settings.length == 0) {
            return (CourseSettings)this.ao.create(CourseSettings.class, new DBParam[]{new DBParam("COURSE_ID", (Object)courseId), new DBParam("IMAGE", (Object)"/download/resources/com.stiltsoft.confluence.quiz/images/course-image.png"), new DBParam("ORDER", (Object)0), new DBParam("SELF_ENROLLMENT_TYPE", (Object)CourseSelfEnrollmentType.NO_ONE)});
        }
        return settings[0];
    }
}

