/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.ao.service.course;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseSection;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseSectionService;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class DefaultCourseSectionService
implements CourseSectionService {
    private ActiveObjects ao;

    public DefaultCourseSectionService(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public int addSectionTx(Long courseId, String name) {
        return this.addSection(courseId, name);
    }

    @Override
    public int addSectionNoTx(Long courseId, String name) {
        return this.addSection(courseId, name);
    }

    @Override
    public void rename(Long courseId, Integer id, String name) {
        CourseSection[] sections = this.find(courseId, id);
        if (sections.length > 0) {
            sections[0].setName(name);
            sections[0].save();
        }
    }

    @Override
    public void reorder(Long courseId, List<Integer> ids) {
        for (int i = 0; i < ids.size(); ++i) {
            CourseSection[] sections = this.find(courseId, ids.get(i));
            if (sections.length <= 0) continue;
            sections[0].setOrder(i);
            sections[0].save();
        }
    }

    @Override
    public void removeTx(Long courseId, Integer id) {
        this.remove(courseId, id);
    }

    @Override
    public void removeNoTx(Long courseId, Integer id) {
        this.remove(courseId, id);
    }

    @Override
    public CourseSection[] getTx(Long courseId) {
        return this.get(courseId);
    }

    @Override
    public CourseSection[] getNoTx(Long courseId) {
        return this.get(courseId);
    }

    @Override
    public CourseSection[] find(Long courseId, Integer id) {
        return (CourseSection[])this.ao.find(CourseSection.class, Query.select().where("COURSE_ID = ? AND ID = ?", new Object[]{courseId, id}).limit(1));
    }

    private CourseSection[] get(Long courseId) {
        return (CourseSection[])this.ao.find(CourseSection.class, Query.select().where("COURSE_ID = ?", new Object[]{courseId}).order("ORDER, ID ASC"));
    }

    private int addSection(Long courseId, String name) {
        CourseSection section = (CourseSection)this.ao.create(CourseSection.class, new DBParam[]{new DBParam("COURSE_ID", (Object)courseId), new DBParam("NAME", (Object)name), new DBParam("ORDER", (Object)1000)});
        return section.getID();
    }

    private void remove(Long courseId, Integer id) {
        CourseSection[] sections = this.find(courseId, id);
        if (sections.length > 0) {
            this.ao.delete((RawEntity[])sections[0].getCourseModules());
            this.ao.delete(new RawEntity[]{sections[0]});
        }
    }
}

