/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.ao.service.course;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseModule;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseModuleService;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseSectionService;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class DefaultCourseModuleService
implements CourseModuleService {
    public static final Integer PAGE_MODULE = 0;
    public static final Integer QUIZ_MODULE = 1;
    private ActiveObjects ao;
    private CourseSectionService sectionService;

    public DefaultCourseModuleService(ActiveObjects ao, CourseSectionService sectionService) {
        this.ao = ao;
        this.sectionService = sectionService;
    }

    @Override
    public int addTx(Long courseId, Long moduleId, Integer type, Integer sectionId) {
        return this.add(courseId, moduleId, type, sectionId);
    }

    @Override
    public int addNoTx(Long courseId, Long moduleId, Integer type, Integer sectionId) {
        return this.add(courseId, moduleId, type, sectionId);
    }

    @Override
    public void removeTx(Long courseId, Integer id) {
        this.remove(courseId, id);
    }

    @Override
    public void removeNoTx(Long courseId, Integer id) {
        this.remove(courseId, id);
    }

    @Override
    public void reorder(Long courseId, List<Integer> ids) {
        for (int i = 0; i < ids.size(); ++i) {
            CourseModule[] modules = this.find(courseId, ids.get(i));
            if (modules.length <= 0) continue;
            modules[0].setOrder(i);
            modules[0].save();
        }
    }

    @Override
    public void setSection(Long courseId, Integer id, Integer sectionId) {
        CourseModule[] modules = this.find(courseId, id);
        if (modules.length > 0) {
            modules[0].setCourseSection(this.sectionService.find(courseId, sectionId)[0]);
            modules[0].save();
        }
    }

    @Override
    public CourseModule[] get(Long courseId) {
        return (CourseModule[])this.ao.find(CourseModule.class, Query.select().where("COURSE_ID = ?", new Object[]{courseId}).order("ORDER, ID ASC"));
    }

    @Override
    public boolean hasCourseModules(Long courseId) {
        return ((CourseModule[])this.ao.find(CourseModule.class, Query.select().where("COURSE_ID = ?", new Object[]{courseId}).limit(1))).length == 1;
    }

    @Override
    public CourseModule[] getQuizModules(Long courseId) {
        return (CourseModule[])this.ao.find(CourseModule.class, Query.select().where("COURSE_ID = ? AND TYPE = ?", new Object[]{courseId, QUIZ_MODULE}));
    }

    @Override
    public CourseModule[] getCourseStateInitialModules(Long courseId) {
        return (CourseModule[])this.ao.find(CourseModule.class, Query.select().where("COURSE_ID = ? AND NOT ( COURSE_SECTION_ID = -1 )", new Object[]{courseId}).order("ORDER ASC, ID ASC"));
    }

    @Override
    public int getCourseStateInitialModulesCount(Long courseId) {
        return this.ao.count(CourseModule.class, Query.select().where("COURSE_ID = ? AND NOT ( COURSE_SECTION_ID = -1 )", new Object[]{courseId}));
    }

    @Override
    public int getCourseStateLeftModulesCount(Long stateId) {
        return this.ao.count(CourseModule.class, Query.select().where("COURSE_ID = ? AND TO_PASS = ?", new Object[]{stateId, Boolean.TRUE}));
    }

    private CourseModule[] find(Long courseId, Integer moduleId) {
        return (CourseModule[])this.ao.find(CourseModule.class, Query.select().where("COURSE_ID = ? AND ID = ?", new Object[]{courseId, moduleId}).limit(1));
    }

    private void remove(Long courseId, Integer id) {
        this.ao.delete((RawEntity[])this.find(courseId, id));
    }

    private int add(Long courseId, Long moduleId, Integer type, Integer sectionId) {
        CourseModule module = (CourseModule)this.ao.create(CourseModule.class, new DBParam[]{new DBParam("COURSE_SECTION_ID", (Object)sectionId), new DBParam("COURSE_ID", (Object)courseId), new DBParam("MODULE_ID", (Object)moduleId), new DBParam("TYPE", (Object)type), new DBParam("TO_PASS", (Object)(sectionId == null ? 1 : 0)), new DBParam("ORDER", (Object)1000)});
        return module.getID();
    }
}

