/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.ao.service.course;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.spi.DataSourceProvider;
import com.stiltsoft.confluence.quiz.ao.DBDependent;
import com.stiltsoft.confluence.quiz.ao.entity.course.CategoryToCourse;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseCategory;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseModule;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseSettings;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseCategoryService;
import com.stiltsoft.confluence.quiz.entity.course.CourseSelfEnrollmentType;
import com.stiltsoft.confluence.quiz.manager.CourseLearningAccessibilityHelper;
import com.stiltsoft.confluence.quiz.utils.SqlStringBuilder;
import java.util.ArrayList;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCourseCategoryService
extends DBDependent
implements CourseCategoryService {
    private static final Logger log = LoggerFactory.getLogger(DefaultCourseCategoryService.class);
    private final ActiveObjects ao;
    private final CourseLearningAccessibilityHelper courseLearningAccessibilityHelper;

    public DefaultCourseCategoryService(ActiveObjects ao, CourseLearningAccessibilityHelper courseLearningAccessibilityHelper, DataSourceProvider dataSourceProvider) {
        super(dataSourceProvider);
        this.ao = ao;
        this.courseLearningAccessibilityHelper = courseLearningAccessibilityHelper;
    }

    @Override
    public int create(String name) {
        CourseCategory category = (CourseCategory)this.ao.create(CourseCategory.class, new DBParam[]{new DBParam("NAME", (Object)name)});
        category.setPosition(category.getID());
        category.save();
        return category.getID();
    }

    @Override
    public void reorder(List<Integer> ids) {
        int position = 0;
        for (Integer id : ids) {
            CourseCategory[] categories = this.getCategories(id);
            if (categories.length != 1) continue;
            categories[0].setPosition(position++);
            categories[0].save();
        }
    }

    @Override
    public CourseCategory[] getCategories() {
        return (CourseCategory[])this.ao.find(CourseCategory.class, Query.select().order("POSITION ASC"));
    }

    @Override
    public List<CourseCategory> getUsedCategories() {
        CourseCategory[] categories = (CourseCategory[])this.ao.find(CourseCategory.class, Query.select().alias(CourseCategory.class, "category").alias(CategoryToCourse.class, "ctc").join(CategoryToCourse.class, "category.ID = ctc.COURSE_CATEGORY_ID").alias(CourseSettings.class, "settings").join(CourseSettings.class, "ctc.COURSE_SETTINGS_ID = settings.ID").alias(CourseModule.class, "module").join(CourseModule.class, "settings.COURSE_ID = module.COURSE_ID").where("settings.SELF_ENROLLMENT_TYPE != ?", new Object[]{CourseSelfEnrollmentType.NO_ONE}).distinct().order("POSITION ASC"));
        ArrayList<CourseCategory> filteredCategories = new ArrayList<CourseCategory>();
        for (CourseCategory category : categories) {
            if (this.courseLearningAccessibilityHelper.filterBySelfEnrollmentType(category.getCourseSettings()).isEmpty()) continue;
            filteredCategories.add(category);
        }
        return filteredCategories;
    }

    @Override
    public boolean isUncategorizedUsed() {
        try {
            String selectPublicUncategorizedCoursesWithModules = SqlStringBuilder.sqlBuilder().select("`AO_DDE40E_COURSE_SETTINGS`.`ID`").from("`AO_DDE40E_COURSE_SETTINGS`").leftJoin("`AO_DDE40E_CATEGORY_TO_COURSE`", "`AO_DDE40E_COURSE_SETTINGS`.`ID` = `AO_DDE40E_CATEGORY_TO_COURSE`.`COURSE_SETTINGS_ID`").join("`AO_DDE40E_COURSE_MODULE`", "`AO_DDE40E_COURSE_SETTINGS`.`COURSE_ID` = `AO_DDE40E_COURSE_MODULE`.`COURSE_ID`").where("`AO_DDE40E_CATEGORY_TO_COURSE`.`COURSE_SETTINGS_ID` IS NULL").and("`AO_DDE40E_COURSE_SETTINGS`.`SELF_ENROLLMENT_TYPE` != ?").build().replaceAll("`", this.getQuotes());
            return !this.courseLearningAccessibilityHelper.filterBySelfEnrollmentType((CourseSettings[])this.ao.findWithSQL(CourseSettings.class, "ID", selectPublicUncategorizedCoursesWithModules, new Object[]{CourseSelfEnrollmentType.NO_ONE})).isEmpty();
        }
        catch (Exception e) {
            log.error("Failed to find uncategorized courses", (Throwable)e);
            return true;
        }
    }

    @Override
    public void delete(Integer id) {
        CourseCategory[] categories = this.getCategories(id);
        if (categories.length == 1) {
            this.ao.delete(this.ao.find(CategoryToCourse.class, Query.select().where("COURSE_CATEGORY_ID = ?", new Object[]{id})));
            this.ao.delete((RawEntity[])categories);
        }
    }

    @Override
    public void rename(Integer id, String name) {
        CourseCategory[] categories = this.getCategories(id);
        if (categories.length == 1) {
            categories[0].setName(name);
            categories[0].save();
        }
    }

    @Override
    public CourseCategory[] getCategories(Integer id) {
        return (CourseCategory[])this.ao.find(CourseCategory.class, Query.select().where("ID = ?", new Object[]{id}).limit(1));
    }
}

