/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.ao.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.stiltsoft.confluence.quiz.ao.entity.UserEntity;
import com.stiltsoft.confluence.quiz.ao.service.UserEntityDao;
import java.util.ArrayList;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;

public class UserEntityDaoImpl
implements UserEntityDao {
    private ActiveObjects ao;
    private UserAccessor userAccessor;

    public UserEntityDaoImpl(ActiveObjects ao, UserAccessor userAccessor) {
        this.ao = ao;
        this.userAccessor = userAccessor;
    }

    @Override
    public UserEntity getUserEntity(String key, String name) {
        UserEntity[] entities = (UserEntity[])this.ao.find(UserEntity.class, Query.select().where("KEY = ?", new Object[]{key}).limit(1));
        if (entities.length > 0) {
            if (name != null && !name.equals(entities[0].getName())) {
                entities[0].setName(name);
                entities[0].save();
            }
            return entities[0];
        }
        return (UserEntity)this.ao.create(UserEntity.class, new DBParam[]{new DBParam("KEY", (Object)key), new DBParam("NAME", (Object)name), new DBParam("EXTERNAL", (Object)(this.userAccessor.getUserByKey(new UserKey(key)) == null ? 1 : 0))});
    }

    @Override
    public UserEntity getUser(int id) {
        UserEntity[] entities = (UserEntity[])this.ao.find(UserEntity.class, Query.select().where("ID = ?", new Object[]{id}).limit(1));
        if (entities.length > 0) {
            return entities[0];
        }
        return null;
    }

    @Override
    public int getUsersCount() {
        return this.ao.count(UserEntity.class, Query.select().where("KEY LIKE ?", new Object[]{"Participant%"}));
    }

    @Override
    public List<String> getEmails(String part, int limit) {
        ArrayList<String> emails = new ArrayList<String>();
        for (UserEntity entity : (UserEntity[])this.ao.find(UserEntity.class, Query.select().where("EXTERNAL = ? AND KEY LIKE ?", new Object[]{Boolean.TRUE, part + "%"}).limit(limit))) {
            emails.add(entity.getKey());
        }
        return emails;
    }
}

