/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.ao.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.stiltsoft.confluence.quiz.ao.dao.ReminderDao;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizReminder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class DefaultReminderDao
implements ReminderDao {
    private static final int ENROLLMENT_TYPE = 0;
    private static final int DUE_DATE_TYPE = 1;
    private static final int QUIZ_TYPE = 0;
    private static final int COURSE_TYPE = 1;
    private ActiveObjects ao;

    public DefaultReminderDao(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public void createCourseDAEReminder(Integer stateId, Long entityId, Long time) {
        this.createReminder(stateId, entityId, time, 0, 1);
    }

    @Override
    public void createQuizDAEReminder(Integer stateId, Long entityId, Long time) {
        this.createReminder(stateId, entityId, time, 0, 0);
    }

    @Override
    public void createQuizDueDateReminder(Integer stateId, Long entityId, Long time) {
        this.createReminder(stateId, entityId, time, 1, 0);
    }

    @Override
    public List<QuizReminder> findCourseDAEReminders(Long courseId) {
        if (courseId == null) {
            return new ArrayList<QuizReminder>();
        }
        QuizReminder[] reminders = (QuizReminder[])this.ao.find(QuizReminder.class, Query.select().where("QUIZ_ID = ? AND TYPE_OF_ENTITY = ?", new Object[]{courseId, 1}));
        return Stream.of(reminders).collect(Collectors.toList());
    }

    @Override
    public List<QuizReminder> findQuizDAEReminders(Long quizId) {
        if (quizId == null) {
            return new ArrayList<QuizReminder>();
        }
        QuizReminder[] reminders = (QuizReminder[])this.ao.find(QuizReminder.class, Query.select().where("QUIZ_ID = ? AND TYPE_OF_ENTITY = ? AND TYPE = ?", new Object[]{quizId, 0, 0}));
        return Stream.of(reminders).collect(Collectors.toList());
    }

    @Override
    public List<QuizReminder> findQuizDueDateReminders(Long quizId) {
        if (quizId == null) {
            return new ArrayList<QuizReminder>();
        }
        QuizReminder[] reminders = (QuizReminder[])this.ao.find(QuizReminder.class, Query.select().where("QUIZ_ID = ? AND TYPE_OF_ENTITY = ? AND TYPE = ?", new Object[]{quizId, 0, 1}));
        return Stream.of(reminders).collect(Collectors.toList());
    }

    @Override
    public List<QuizReminder> findQuizReminders(int limit) {
        QuizReminder[] reminders = (QuizReminder[])this.ao.find(QuizReminder.class, Query.select().where("TIME < ? AND TYPE_OF_ENTITY = ?", new Object[]{System.currentTimeMillis(), 0}).limit(limit));
        return Stream.of(reminders).collect(Collectors.toList());
    }

    @Override
    public List<QuizReminder> findCourseReminders(int limit) {
        QuizReminder[] reminders = (QuizReminder[])this.ao.find(QuizReminder.class, Query.select().where("TIME < ? AND TYPE_OF_ENTITY = ?", new Object[]{System.currentTimeMillis(), 1}).limit(limit));
        return Stream.of(reminders).collect(Collectors.toList());
    }

    @Override
    public void remove(List<QuizReminder> reminders) {
        this.ao.delete((RawEntity[])reminders.toArray(new QuizReminder[0]));
    }

    @Override
    public void remove(QuizReminder reminder) {
        this.ao.delete(new RawEntity[]{reminder});
    }

    private void createReminder(int stateId, long entityId, long reminderTime, int reminderType, int entityType) {
        this.ao.create(QuizReminder.class, new DBParam[]{new DBParam("STATE_ID", (Object)stateId), new DBParam("QUIZ_ID", (Object)entityId), new DBParam("TIME", (Object)reminderTime), new DBParam("TYPE", (Object)reminderType), new DBParam("TYPE_OF_ENTITY", (Object)entityType)});
    }
}

