/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.ao.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.spi.DataSourceProvider;
import com.stiltsoft.confluence.quiz.ao.DBDependent;
import com.stiltsoft.confluence.quiz.ao.dao.QuizStateEntityDao;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizStateEntity;
import com.stiltsoft.confluence.quiz.utils.SqlStringBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultQuizStateEntityDao
extends DBDependent
implements QuizStateEntityDao {
    private final ActiveObjects ao;

    public DefaultQuizStateEntityDao(ActiveObjects ao, DataSourceProvider dataSourceProvider) {
        super(dataSourceProvider);
        this.ao = ao;
    }

    @Override
    public List<QuizStateEntity> getStatesWithAttemptsByQuizId(Long quizId) {
        if (quizId == null) {
            return new ArrayList<QuizStateEntity>();
        }
        String selectLastAttemptIdForEachUserByQuizId = SqlStringBuilder.sqlBuilder().select("MAX(`ID`)").from("`AO_DDE40E_TEST_STATE`").where("`QUIZ_ID` = ?").and("(`DELETED` IS NULL OR `DELETED` = ?)").groupBy("`USER_ID`").build();
        String selectStatesWithAttemptsByQuizId = SqlStringBuilder.sqlBuilder().select("*").from("`AO_DDE40E_TEST_STATE`").where("`ID`").in(selectLastAttemptIdForEachUserByQuizId).and("((`STATUS` = ? OR `STATUS` = ?) OR (`STATUS` = ? AND `ATTEMPTS` > ? AND `REVIEW` = ?))").build().replaceAll("`", this.getQuotes());
        QuizStateEntity[] states = (QuizStateEntity[])this.ao.findWithSQL(QuizStateEntity.class, "ID", selectStatesWithAttemptsByQuizId, new Object[]{quizId, Boolean.FALSE, 0, 1, 2, 0, 0});
        return Stream.of(states).collect(Collectors.toList());
    }
}

