/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.ao.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.stiltsoft.confluence.quiz.ao.dao.CourseStateEntityDao;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseStateEntity;
import com.stiltsoft.confluence.quiz.utils.NumberHelper;
import com.stiltsoft.confluence.quiz.utils.StatusHistoryHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.java.ao.DBParam;
import net.java.ao.Query;

public class DefaultCourseStateEntityDao
implements CourseStateEntityDao {
    private ActiveObjects ao;

    public DefaultCourseStateEntityDao(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public List<CourseStateEntity> getActiveEntitiesByCourseId(Long courseId) {
        if (courseId == null) {
            return new ArrayList<CourseStateEntity>();
        }
        Query query = Query.select().where("COURSE_ID = ? AND (STATUS = ? OR STATUS = ?) AND DELETED = ?", new Object[]{courseId, 0, 1, Boolean.FALSE});
        return Stream.of(this.ao.find(CourseStateEntity.class, query)).collect(Collectors.toList());
    }

    @Override
    public List<CourseStateEntity> getCourseStateEntities(List<Long> courseIds, List<Integer> studentIds, int start, int limit) {
        if (courseIds.isEmpty()) {
            return Collections.emptyList();
        }
        Query query = Query.select().order("ID DESC");
        query = !studentIds.isEmpty() ? query.where("COURSE_ID IN (" + NumberHelper.joinNumbersByComma(courseIds) + ") AND USER_ID IN (" + NumberHelper.joinNumbersByComma(studentIds) + ") AND DELETED = ?", new Object[]{Boolean.FALSE}).limit(limit).offset(start) : query.where("COURSE_ID IN (" + NumberHelper.joinNumbersByComma(courseIds) + ") AND DELETED = ?", new Object[]{Boolean.FALSE}).limit(limit).offset(start);
        return Arrays.stream(this.ao.find(CourseStateEntity.class, query)).collect(Collectors.toList());
    }

    @Override
    public Optional<CourseStateEntity> getCourseStateEntity(Integer userId, Long courseId, Integer recordId) {
        CourseStateEntity[] entities = (CourseStateEntity[])this.ao.find(CourseStateEntity.class, Query.select().where("ID = ? AND USER_ID = ? AND COURSE_ID = ? AND DELETED = ?", new Object[]{recordId, userId, courseId, Boolean.FALSE}).limit(1));
        return entities.length == 0 ? Optional.empty() : Optional.of(entities[0]);
    }

    @Override
    public List<CourseStateEntity> getCourseStateEntitiesByUser(int userId) {
        CourseStateEntity[] entities = (CourseStateEntity[])this.ao.find(CourseStateEntity.class, Query.select().where("USER_ID = ? AND DELETED_BY_USER = ? AND DELETED = ?", new Object[]{userId, Boolean.FALSE, Boolean.FALSE}).order("ID DESC"));
        return Arrays.stream(entities).collect(Collectors.toList());
    }

    @Override
    public List<CourseStateEntity> getCourseStateEntitiesOverdueByTime(int offset, int limit) {
        CourseStateEntity[] entities = (CourseStateEntity[])this.ao.find(CourseStateEntity.class, Query.select().where("(STATUS = ? OR STATUS = ?) AND DUE_DATE IS NOT NULL AND DUE_DATE < ? AND DELETED = ?", new Object[]{0, 1, System.currentTimeMillis(), Boolean.FALSE}).limit(limit).offset(offset).order("ID ASC"));
        return Arrays.stream(entities).collect(Collectors.toList());
    }

    @Override
    public CourseStateEntity create(Integer studentId, Integer authorId, Long courseId, Long dueDate) {
        long currentTime = System.currentTimeMillis();
        return (CourseStateEntity)this.ao.create(CourseStateEntity.class, new DBParam[]{new DBParam("USER_ID", (Object)studentId), new DBParam("AUTHOR", (Object)authorId), new DBParam("COURSE_ID", (Object)courseId), new DBParam("DELETED", (Object)false), new DBParam("DELETED_BY_USER", (Object)false), new DBParam("STATUS", (Object)0), new DBParam("STATUS_HISTORY", (Object)StatusHistoryHelper.NOT_STARTED_STATUS_HISTORY), new DBParam("START_DATE", (Object)currentTime), new DBParam("ENROLLED_DATE", (Object)currentTime), new DBParam("DUE_DATE", (Object)dueDate)});
    }
}

