/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.ao.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.stiltsoft.confluence.quiz.ao.dao.CourseAnswersDao;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseAnswers;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseModule;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseStateEntity;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizStateEntity;
import java.util.Optional;
import net.java.ao.RawEntity;

public class DefaultCourseAnswersDao
implements CourseAnswersDao {
    private ActiveObjects ao;

    public DefaultCourseAnswersDao(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public Optional<CourseAnswers> saveAnswer(CourseAnswers courseAnswers, CourseStateEntity courseStateEntity) {
        if (courseAnswers == null || courseStateEntity == null) {
            return Optional.empty();
        }
        courseAnswers.setPassed(true);
        courseAnswers.setWatching(false);
        courseAnswers.setEndTime(System.currentTimeMillis());
        courseAnswers.setProgress(2);
        courseAnswers.save();
        this.removeCompletedModule(courseAnswers, courseStateEntity);
        return Optional.of(courseAnswers);
    }

    @Override
    public Optional<CourseAnswers> saveAnswer(CourseAnswers courseAnswers, QuizStateEntity quizStateEntity, CourseStateEntity courseStateEntity) {
        if (courseAnswers == null || quizStateEntity == null || courseStateEntity == null) {
            return Optional.empty();
        }
        if (quizStateEntity.getCorrect() < quizStateEntity.getTarget()) {
            if (quizStateEntity.getAttempts() == 0) {
                courseAnswers.setPassed(false);
                courseAnswers.setEndTime(System.currentTimeMillis());
                courseAnswers.setWatching(false);
                courseAnswers.save();
                quizStateEntity.setCompleted(false);
                quizStateEntity.save();
            }
            return Optional.empty();
        }
        courseAnswers.setPassed(true);
        courseAnswers.setProgress(2);
        courseAnswers.setEndTime(System.currentTimeMillis());
        courseAnswers.setWatching(false);
        courseAnswers.save();
        this.removeCompletedModule(courseAnswers, courseStateEntity);
        quizStateEntity.setCompleted(true);
        quizStateEntity.save();
        return Optional.of(courseAnswers);
    }

    private void removeCompletedModule(CourseAnswers courseAnswers, CourseStateEntity courseStateEntity) {
        for (CourseModule module : courseStateEntity.getCourseModules()) {
            if (!module.getModuleId().equals(courseAnswers.getModuleId())) continue;
            this.ao.delete(new RawEntity[]{module});
            break;
        }
    }
}

