/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.action.quiz;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.google.common.collect.Lists;
import com.stiltsoft.confluence.quiz.action.DefaultViewContentAction;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizAnswersEntity;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizStateEntity;
import com.stiltsoft.confluence.quiz.entity.MailParams;
import com.stiltsoft.confluence.quiz.entity.quiz.question.Question;
import com.stiltsoft.confluence.quiz.entity.quiz.question.QuestionParams;
import com.stiltsoft.confluence.quiz.manager.QuizMacroManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;

public class ViewQuestionAction
extends DefaultViewContentAction {
    private static final Pattern INPUT = Pattern.compile("<input class=\"quiz-answer\" type=\"(radio|checkbox)\" name=\"quiz-answer\" id=\"([0-9a-f]+)\"( checked=\".*?\")?");
    private static final String QUIZ_ENROLL_DELETED_TEMPLATE = "quiz-enroll-deleted";
    private static final int ID_MATCHER_GROUP = 2;
    private static final int CHECKED_MATCHER_GROUP = 3;
    private QuizMacroManager quizMacroManager;
    private Question question;

    public void setQuizMacroManager(QuizMacroManager quizMacroManager) {
        this.quizMacroManager = quizMacroManager;
    }

    public String doDefault() throws Exception {
        boolean answered;
        MailParams params = this.getParam();
        if (!this.cqPermissionHelper.isUserAuthorized(params)) {
            return "login";
        }
        Long questionId = this.getQuestionId();
        Long pageId = questionId != null ? questionId : this.quizService.getNextQuestion(params.getUid(), params.getQid(), params.getAid(), params.getRid());
        QuizStateEntity entity = this.quizService.getStateTx(params.getUid(), params.getQid(), params.getAid(), params.getRid());
        if (entity == null || Boolean.TRUE.equals(entity.getDeleted())) {
            return QUIZ_ENROLL_DELETED_TEMPLATE;
        }
        if (pageId == null && entity.getResubmit() != null && entity.getResubmit().booleanValue()) {
            pageId = Long.valueOf(entity.getAllQuestions().split(",")[0]);
        }
        boolean bl = answered = !Lists.newArrayList((Object[])StringUtils.defaultString((String)entity.getQuestions()).split(",")).contains(pageId.toString());
        if (questionId != null && !Lists.newArrayList((Object[])entity.getAllQuestions().split(",")).contains(pageId.toString()) || answered && (entity.getResubmit() == null || !entity.getResubmit().booleanValue())) {
            return "none";
        }
        QuizAnswersEntity answersEntity = null;
        Integer pageVersion = null;
        if (answered) {
            answersEntity = this.quizService.getAnswer(params.getUid(), params.getQid(), pageId, entity.getStartDate());
            pageVersion = answersEntity.getPageVersion();
        }
        MutablePair<String, AbstractPage> pair = this.quizPageManager.renderPage(pageId, pageVersion, this.getAuthor(entity), params);
        AbstractPage page = (AbstractPage)pair.getRight();
        String body = (String)pair.getLeft();
        body = this.quizPageManager.removeFeedback(body);
        boolean reviewable = body.contains("<textarea class=\"textarea free-text-answer-review\">");
        List<String> answers = this.quizPageManager.getAnswers(body);
        ArrayList<String> originalAnswers = new ArrayList<String>(answers);
        QuestionParams questionParams = this.quizMacroManager.getQuestionParam((ContentEntityObject)page);
        boolean random = questionParams.getRandom();
        if (!answered && random) {
            Collections.shuffle(answers, new Random());
        }
        ArrayList<Integer> sequence = new ArrayList<Integer>();
        List<Object> correct = new ArrayList();
        if (!"Free text (checked automatically)".equals(questionParams.getType())) {
            for (String originalAnswer : originalAnswers) {
                sequence.add(answers.indexOf(originalAnswer));
            }
            for (int i = 0; i < answers.size(); ++i) {
                Matcher matcher = INPUT.matcher(answers.get(i));
                if (matcher.find()) {
                    if (matcher.group(3) != null) {
                        correct.add(Integer.toString(i));
                        answers.set(i, answers.get(i).replace(matcher.group(2) + "\"" + matcher.group(3), matcher.group(2) + "\""));
                    }
                    answers.set(i, answers.get(i).replace(matcher.group(2) + "\"", matcher.group(2) + "\" data-processed"));
                }
                body = body.replace((CharSequence)originalAnswers.get(i), answers.get(i));
            }
        } else {
            correct = this.quizPageManager.getEncodedAnswersOptionTexts(page);
            body = this.quizPageManager.removeAnswers(body);
        }
        body = "<h3>" + StringEscapeUtils.escapeHtml4((String)page.getDisplayTitle()) + "</h3>" + body;
        this.question = new Question(body, pageId, entity.getStartDate(), entity.getStartDate() + (long)entity.getTimeLimit().intValue(), entity.getSkip() != false && StringUtils.defaultString((String)entity.getQuestions()).split(",").length > 1, entity.getTotal(), entity.getAnswers());
        if (!answered) {
            answersEntity = this.quizService.startAnswer(params.getUid(), params.getQid(), params.getAid(), pageId, page.getVersion(), entity.getStartDate(), correct, sequence, reviewable);
            if (random) {
                this.question.setStarted(answersEntity.getStartTime());
            }
        } else {
            this.quizService.startWatchingQuestion(answersEntity);
            this.question.setAnswers(answersEntity.getAnswers());
            this.question.setSequence(StringUtils.defaultString((String)answersEntity.getSequence(), (String)"empty"));
        }
        return "success";
    }

    public Question getQuestion() {
        return this.question;
    }
}

