/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.action.quiz;

import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.user.UserKey;
import com.stiltsoft.confluence.quiz.action.quiz.DefaultAnswersAction;
import com.stiltsoft.confluence.quiz.ao.entity.UserEntity;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizStateEntity;
import com.stiltsoft.confluence.quiz.entity.quiz.answer.Answer;
import java.util.LinkedHashMap;
import java.util.Map;

public class ReviewAction
extends DefaultAnswersAction {
    @Override
    public boolean isPermitted() {
        return this.getAuthenticatedUser() != null;
    }

    @Override
    public String doDefault() throws Exception {
        Map<String, String[]> params = this.getParams();
        if (!this.confluencePermissionHelper.canView(this.getQuizId())) {
            return "login";
        }
        this.stateEntity = this.quizService.getStateTx(Integer.valueOf(params.get("id")[0]));
        if (!this.stateEntity.getStartDate().equals(Long.valueOf(params.get("attempt")[0]))) {
            return "none";
        }
        return super.doDefault();
    }

    public String getUserName() {
        return super.getUserName(this.stateEntity);
    }

    public Map<Integer, Answer> getUsersAnswer() {
        LinkedHashMap<Integer, Answer> answerMap = new LinkedHashMap<Integer, Answer>();
        DateFormatter dateFormatter = this.dateFormatterCacheManager.getDateFormatter();
        for (QuizStateEntity entity : this.quizService.findStatesForReview(this.stateEntity.getQuizId(), this.stateEntity.getCourseId())) {
            if (answerMap.containsKey(entity.getUserId())) continue;
            Answer.AnswerBuilder answerBuilder = Answer.newBuilder().setEntity(entity).setDateFormatter(dateFormatter);
            UserEntity userEntity = this.userEntityService.getUser(entity.getUserId());
            if (userEntity.getExternal().booleanValue()) {
                answerBuilder.setStudentName(userEntity.getName());
                answerBuilder.setStudentEmail(userEntity.getKey());
            } else {
                ConfluenceUser user = this.userAccessor.getExistingUserByKey(new UserKey(userEntity.getKey()));
                answerBuilder.setStudent(user);
            }
            answerMap.put(entity.getUserId(), answerBuilder.build());
        }
        return answerMap;
    }

    public long getQuizId() {
        return Long.parseLong(this.getParams().get("qid")[0]);
    }
}

