/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.action.quiz;

import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.user.User;
import com.stiltsoft.confluence.quiz.action.DefaultAction;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizAnswersEntity;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizStateEntity;
import com.stiltsoft.confluence.quiz.entity.MailParams;
import com.stiltsoft.confluence.quiz.entity.Status;
import com.stiltsoft.confluence.quiz.entity.quiz.QuizParams;
import com.stiltsoft.confluence.quiz.entity.quiz.question.QuestionNavigation;
import com.stiltsoft.confluence.quiz.manager.QuizMacroManager;
import com.stiltsoft.confluence.quiz.manager.QuizPageManager;
import com.stiltsoft.confluence.quiz.utils.DueDateHelper;
import com.stiltsoft.confluence.quiz.utils.DurationHelper;
import com.stiltsoft.confluence.quiz.utils.QuizEncrypter;
import com.stiltsoft.confluence.quiz.utils.QuizSettingsNumberHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class QuizAction
extends DefaultAction {
    private static final String SCORE_TEMPLATE = "score";
    private static final String EMPTY_TEMPLATE = "empty";
    private PageManager pageManager;
    private QuizPageManager quizPageManager;
    private QuizStateEntity entity;
    private Page page;
    private QuizMacroManager quizMacroManager;
    private DueDateHelper dueDateHelper;
    private WikiStyleRenderer wikiStyleRenderer;
    private int reviewCount;
    private String startPage;
    private String feedbackPage;
    private List<QuestionNavigation> navigations;

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setQuizPageManager(QuizPageManager quizPageManager) {
        this.quizPageManager = quizPageManager;
    }

    public void setDueDateHelper(DueDateHelper dueDateHelper) {
        this.dueDateHelper = dueDateHelper;
    }

    public void setQuizMacroManager(QuizMacroManager quizMacroManager) {
        this.quizMacroManager = quizMacroManager;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public String doDefault() throws Exception {
        if (this.isReadOnlyMode()) {
            return "read-only";
        }
        MailParams params = this.getParam();
        if (params == null || this.userEntityService.getUserId(params.getKey()) != params.getUid().intValue()) {
            return "error";
        }
        this.entity = this.getStateEntity(params);
        if (this.entity == null) {
            return "none";
        }
        this.page = this.pageManager.getPage(this.getParam().getQid().longValue());
        if (this.page == null || this.page.isDeleted()) {
            return "deleted";
        }
        if (Status.isActive(this.entity) && this.entity.getAllQuestions() != null && !this.entity.getAllQuestions().isEmpty()) {
            this.navigations = new ArrayList<QuestionNavigation>();
            for (String id : this.entity.getAllQuestions().split(",")) {
                Long pageId = Long.valueOf(id);
                QuestionNavigation navigation = new QuestionNavigation(pageId);
                QuizAnswersEntity answersEntity = this.quizService.getAnswer(params.getUid(), params.getQid(), pageId, this.entity.getStartDate());
                if (answersEntity != null && answersEntity.getEndTime() != null) {
                    navigation.setAnswered(true);
                    if (answersEntity.getReviewable() != null && answersEntity.getReviewable().booleanValue()) {
                        navigation.setReview(true);
                    } else if (this.entity.getShowRes() != null && this.entity.getShowRes().booleanValue() && answersEntity.getCorrect().booleanValue()) {
                        navigation.setCorrect(true);
                    }
                }
                this.navigations.add(navigation);
            }
        }
        if (Boolean.TRUE.equals(this.entity.getDeleted())) {
            return "cancelled";
        }
        if (this.entity.getStatus() == 0) {
            if (this.entity.getSkipStartPage() != null && this.entity.getSkipStartPage().booleanValue()) {
                Optional<QuizStateEntity> stateOpt = this.quizService.getState(params.getUid(), params.getQid(), params.getRid());
                stateOpt.ifPresent(quizStateEntity -> this.quizService.startTest((QuizStateEntity)quizStateEntity));
                this.entity = this.quizService.getStateTx(params.getUid(), params.getQid(), params.getAid(), params.getRid());
            } else {
                this.startPage = (String)this.quizPageManager.getStartPage((QuizStateEntity)this.entity, (ConfluenceUser)this.getAuthor((QuizStateEntity)this.entity), (MailParams)params).left;
            }
        } else if (this.entity.getStatus() == 2) {
            this.feedbackPage = (String)this.quizPageManager.getFinishPage((QuizStateEntity)this.entity, (ConfluenceUser)this.getAuthor((QuizStateEntity)this.entity), (MailParams)params).left;
            return SCORE_TEMPLATE;
        }
        if (this.isOverdue()) {
            return "overdue";
        }
        if (!(this.entity.getQuestions() != null && !this.entity.getQuestions().isEmpty() || this.entity.getResubmit() != null && this.entity.getResubmit().booleanValue())) {
            this.quizService.remove(this.entity);
            return EMPTY_TEMPLATE;
        }
        this.reviewCount = 0;
        if (this.entity.getQuestions() != null && !this.entity.getQuestions().isEmpty()) {
            for (String pageId : this.entity.getQuestions().split(",")) {
                if (!this.pageManager.getAbstractPage(Long.valueOf(pageId).longValue()).getBodyAsString().contains("<ac:parameter ac:name=\"type\">Free text</ac:parameter>")) continue;
                ++this.reviewCount;
            }
        }
        return "success";
    }

    public QuizStateEntity getEntity() {
        return this.entity;
    }

    public Page getPage() throws Exception {
        return this.page;
    }

    public String getLocalizedRate() {
        return QuizSettingsNumberHelper.getLocalizedRate(this.entity.getCorrect(), this.entity.getTotal());
    }

    public String getTimeLimit() {
        return DurationHelper.formatDuration(this.entity.getTimeLimit().intValue());
    }

    public String getDueDate() {
        return StringUtils.defaultString((String)this.dueDateHelper.formatDueDate(this.entity.getDueDate()));
    }

    public boolean isOverdue() {
        return this.entity.getStatus() == 4 || this.entity.getDueDate() != null && DueDateHelper.isOverdue(this.entity.getDueDate());
    }

    public int getReviewCount() {
        return this.reviewCount;
    }

    @HtmlSafe
    public String getFeedbackPage() {
        return this.feedbackPage;
    }

    @HtmlSafe
    public String getStartPage() {
        return this.startPage;
    }

    public QuizParams getQuizParams() throws XhtmlException {
        return this.quizMacroManager.getQuizParams((ContentEntityObject)this.pageManager.getPage(this.entity.getQuizId().longValue()));
    }

    public String getDescription() throws Exception {
        String wiki = this.getQuizParams().getDesc();
        return this.renderWikiToHtml(wiki);
    }

    public List<QuestionNavigation> getQuestions() {
        return this.navigations;
    }

    public boolean isQuizAdmin() {
        return this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.EDIT, (Object)this.pageManager.getPage(this.entity.getQuizId().longValue()));
    }

    public boolean isAdminPreview() {
        String preview = this.getUrlParam("view");
        return "admin".equals(preview);
    }

    public boolean isRetakeOnFail() {
        return this.quizService.isRetakeOnFail(this.entity);
    }

    public boolean canRetake() {
        return this.quizService.canRetake(this.entity);
    }

    public String renderWikiToHtml(String wiki) throws Exception {
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)this.getPage().toPageContext(), wiki);
    }

    public boolean isLatestAttempt() {
        return this.quizService.isLatestAttempt(this.entity);
    }

    public String getQSD() throws Exception {
        return GeneralUtil.urlEncode((String)QuizEncrypter.encrypt(new MailParams(this.entity, this.getParam().getKey())));
    }

    public String getUserName() {
        return super.getUserName(this.entity);
    }

    public boolean isQuizInsideCourse() {
        return this.entity.getCourseId() != null;
    }
}

