/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.action.quiz;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.google.common.collect.Lists;
import com.stiltsoft.confluence.quiz.action.DefaultAction;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizAnswersEntity;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizStateEntity;
import com.stiltsoft.confluence.quiz.cache.DateFormatterCacheManager;
import com.stiltsoft.confluence.quiz.manager.ConfluencePermissionHelper;
import com.stiltsoft.confluence.quiz.utils.DurationHelper;
import java.util.ArrayList;
import java.util.List;

public class DefaultAnswersAction
extends DefaultAction {
    protected DateFormatterCacheManager dateFormatterCacheManager;
    protected PageManager pageManager;
    protected ConfluencePermissionHelper confluencePermissionHelper;
    protected QuizStateEntity stateEntity;
    protected List<QuizAnswersEntity> entities;
    protected List<String> emptyQuestions;

    public String doDefault() throws Exception {
        String questionsStr;
        if (this.stateEntity.getAnswers() == 0) {
            return "none";
        }
        this.entities = Lists.newArrayList((Object[])this.quizService.getAnswers(this.stateEntity.getUserId(), this.stateEntity.getQuizId(), this.stateEntity.getStartDate()));
        if (this.stateEntity.getAllQuestions() != null) {
            block0: for (String questionId : this.stateEntity.getAllQuestions().split(",")) {
                Long id = Long.valueOf(questionId);
                for (QuizAnswersEntity entity : this.entities) {
                    if (!entity.getQuestionId().equals(id)) continue;
                    this.entities.remove(entity);
                    this.entities.add(entity);
                    continue block0;
                }
            }
        }
        this.emptyQuestions = (questionsStr = this.stateEntity.getQuestions()) != null && !questionsStr.isEmpty() ? Lists.newArrayList((Object[])questionsStr.split(",")) : new ArrayList<String>();
        return "success";
    }

    public List<QuizAnswersEntity> getEntities() {
        return this.entities;
    }

    public List<String> getEmptyQuestions() {
        return this.emptyQuestions;
    }

    public int getTotal() {
        return this.entities.size() + this.emptyQuestions.size();
    }

    public String getTimeLimit() {
        return DurationHelper.formatDuration(this.stateEntity.getTimeLimit().intValue());
    }

    public Page getPage() {
        return this.pageManager.getPage(this.stateEntity.getQuizId().longValue());
    }

    public QuizStateEntity getStateEntity() {
        return this.stateEntity;
    }

    public List<QuizStateEntity> getQuizStateEntities() {
        int id = this.stateEntity.getSessionId() == null ? this.stateEntity.getID() : this.stateEntity.getSessionId().intValue();
        return this.quizService.findAttempts(id);
    }

    public void setDateFormatterCacheManager(DateFormatterCacheManager dateFormatterCacheManager) {
        this.dateFormatterCacheManager = dateFormatterCacheManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setConfluencePermissionHelper(ConfluencePermissionHelper confluencePermissionHelper) {
        this.confluencePermissionHelper = confluencePermissionHelper;
    }
}

