/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.action.quiz;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.user.UserKey;
import com.stiltsoft.confluence.quiz.action.quiz.ReviewAction;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizAnswersEntity;
import com.stiltsoft.confluence.quiz.entity.MailParams;
import com.stiltsoft.confluence.quiz.entity.quiz.answer.AnsweredQuestion;
import com.stiltsoft.confluence.quiz.manager.QuizPageManager;
import com.stiltsoft.confluence.quiz.utils.DurationHelper;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class DefaultAnsweredQuestionAction
extends ReviewAction {
    protected AnsweredQuestion question;
    protected QuizPageManager quizPageManager;
    protected long attempt;

    public void setQuizPageManager(QuizPageManager quizPageManager) {
        this.quizPageManager = quizPageManager;
    }

    @Override
    public String doDefault() throws Exception {
        Map<String, String[]> params = this.getParams();
        MailParams mailParams = this.getMailParams();
        Long qid = mailParams.getQid();
        if (!this.canView(qid)) {
            return "login";
        }
        Long pageId = Long.valueOf(params.get("questionId")[0]);
        AbstractPage page = this.pageManager.getAbstractPage(pageId.longValue());
        Integer uid = mailParams.getUid();
        if (page == null) {
            return "none";
        }
        QuizAnswersEntity entity = this.quizService.getAnswer(uid, qid, pageId, this.attempt);
        if (entity != null) {
            page = this.pageManager.getPageByVersion(page, entity.getPageVersion().intValue());
        }
        String body = this.getPageBody(page);
        body = this.quizPageManager.removeFeedback(body);
        body = "<h3>" + StringEscapeUtils.escapeHtml4((String)page.getDisplayTitle()) + "</h3>" + body;
        if (this.isQuestionAnswered(entity)) {
            long timeSpent = entity.getWastedTime() == null ? 0L : entity.getWastedTime();
            this.question = new AnsweredQuestion(body, DurationHelper.formatDuration(timeSpent += entity.getEndTime() - entity.getStartTime()), entity.getAnswers(), entity.getCorrectAnswers(), StringUtils.defaultString((String)entity.getSequence(), (String)"empty"));
            if (entity.getReviewer() != null) {
                ConfluenceUser user = this.userAccessor.getUserByKey(new UserKey(entity.getReviewer()));
                this.question.setReviewerName(user.getName());
                this.question.setReviewerFullName(user.getFullName());
            }
        } else {
            this.question = new AnsweredQuestion(body);
        }
        return "success";
    }

    private boolean isQuestionAnswered(QuizAnswersEntity entity) {
        return entity != null && entity.getEndTime() != null;
    }

    protected abstract MailParams getMailParams() throws Exception;

    protected abstract boolean canView(Long var1) throws Exception;

    protected abstract String getPageBody(AbstractPage var1) throws Exception;

    public AnsweredQuestion getQuestion() {
        return this.question;
    }
}

