/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.action.learning;

import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseCategory;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseCategoryService;
import com.stiltsoft.confluence.quiz.entity.MailParams;
import com.stiltsoft.confluence.quiz.entity.course.CourseMetadata;
import com.stiltsoft.confluence.quiz.manager.BlueprintManager;
import com.stiltsoft.confluence.quiz.manager.CQPermissionHelper;
import com.stiltsoft.confluence.quiz.manager.ConfluencePermissionHelper;
import com.stiltsoft.confluence.quiz.manager.CourseReportHelper;
import com.stiltsoft.confluence.quiz.manager.LicenseManager;
import com.stiltsoft.confluence.quiz.manager.QuizPageManager;
import com.stiltsoft.confluence.quiz.manager.UserEntityService;
import java.util.Collection;
import java.util.List;

public abstract class AbstractLearningAction
extends ConfluenceActionSupport {
    protected CourseCategoryService courseCategoryService;
    protected AccessModeCompatService accessModeCompatService;
    protected CourseReportHelper courseReportHelper;
    protected CQPermissionHelper cqPermissionHelper;
    protected ConfluencePermissionHelper confluencePermissionHelper;
    private BlueprintManager blueprintManager;
    private SpaceManager spaceManager;
    private LicenseManager licenseManager;
    private QuizPageManager quizPageManager;
    private UserEntityService userEntityService;

    public String doDefault() throws Exception {
        return "success";
    }

    public boolean isReadOnlyMode() {
        return this.accessModeCompatService.isReadOnlyAccessModeEnabled();
    }

    public List<CourseCategory> getUsedCategories() {
        return this.courseCategoryService.getUsedCategories();
    }

    public boolean shouldShowUncategorized() {
        return this.courseCategoryService.isUncategorizedUsed();
    }

    public String getCourseBlueprintId() {
        return this.blueprintManager.getBlueprintId("com.stiltsoft.confluence.quiz:course-blueprint", this.getPersonalSpaceKey());
    }

    public String getQuizBlueprintId() {
        return this.blueprintManager.getBlueprintId("com.stiltsoft.confluence.quiz:quiz-blueprint", this.getPersonalSpaceKey());
    }

    public String getPersonalSpaceKey() {
        Space space = this.getPersonalSpace();
        return space == null ? null : space.getKey();
    }

    public Space getPersonalSpace() {
        ConfluenceUser user = this.getAuthenticatedUser();
        if (user == null) {
            return null;
        }
        Space space = this.spaceManager.getPersonalSpace(user);
        if (space != null) {
            return space;
        }
        space = this.getPermittedSpace(this.spaceManager.getAuthoredSpacesByUser(user.getName()));
        if (space != null) {
            return space;
        }
        return this.getPermittedSpace(this.spaceManager.getAllSpaces());
    }

    public boolean isLicensed() {
        return this.licenseManager.isActive();
    }

    public String getImageTagWithHtml(CourseMetadata courseMetadata) throws Exception {
        ConfluenceUser user = this.getAuthenticatedUser();
        String userKey = user == null ? "" : this.getAuthenticatedUser().getKey().getStringValue();
        MailParams params = new MailParams(courseMetadata.getCourseId(), user == null ? -1 : this.userEntityService.getUserId(userKey), -1, userKey, -1);
        String imgTag = "<img class=\"course-image\" src=\"" + this.getBootstrapManager().getWebAppContextPath() + courseMetadata.getImageUrl() + "\">";
        return this.quizPageManager.extractAttachments(imgTag, params, params.getQid());
    }

    public boolean isDcLicense() {
        return this.licenseManager.isDataCenter();
    }

    public abstract String getTabName();

    private Space getPermittedSpace(Collection<Space> spaces) {
        for (Space space : spaces) {
            if (!this.confluencePermissionHelper.canCreatePage(space)) continue;
            return space;
        }
        return null;
    }

    public void setQuizPageManager(QuizPageManager quizPageManager) {
        this.quizPageManager = quizPageManager;
    }

    public void setUserEntityService(UserEntityService userEntityService) {
        this.userEntityService = userEntityService;
    }

    public void setCourseReportHelper(CourseReportHelper courseReportHelper) {
        this.courseReportHelper = courseReportHelper;
    }

    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setCourseCategoryService(CourseCategoryService courseCategoryService) {
        this.courseCategoryService = courseCategoryService;
    }

    public void setCQPermissionHelper(CQPermissionHelper cqPermissionHelper) {
        this.cqPermissionHelper = cqPermissionHelper;
    }

    public CQPermissionHelper getCQPermissionHelper() {
        return this.cqPermissionHelper;
    }

    public void setConfluencePermissionHelper(ConfluencePermissionHelper confluencePermissionHelper) {
        this.confluencePermissionHelper = confluencePermissionHelper;
    }

    public void setAccessModeCompatService(AccessModeCompatService accessModeCompatService) {
        this.accessModeCompatService = accessModeCompatService;
    }

    public void setBlueprintManager(BlueprintManager blueprintManager) {
        this.blueprintManager = blueprintManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }
}

