/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.action.course;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.web.context.StaticHttpContext;
import com.stiltsoft.confluence.quiz.action.DefaultViewContentAction;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseAnswers;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseModule;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseSettings;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseModuleService;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseSettingsService;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseStateEntityService;
import com.stiltsoft.confluence.quiz.ao.service.course.DefaultCourseModuleService;
import com.stiltsoft.confluence.quiz.entity.MailParams;
import com.stiltsoft.confluence.quiz.entity.course.CourseEnrollWrapper;
import com.stiltsoft.confluence.quiz.entity.quiz.question.Question;
import com.stiltsoft.confluence.quiz.utils.QuizEncrypter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.MutablePair;

public class ViewModuleAction
extends DefaultViewContentAction {
    private static final String COURSE_ENROLL_DELETED_TEMPLATE = "course-enroll-deleted";
    private CourseStateEntityService courseStateEntityService;
    private CourseModuleService courseModuleService;
    private Question modulePage;
    private CourseAnswers answers;
    private CourseSettingsService courseSettingsService;

    public void setCourseStateEntityService(CourseStateEntityService courseStateEntityService) {
        this.courseStateEntityService = courseStateEntityService;
    }

    public void setCourseModuleService(CourseModuleService courseModuleService) {
        this.courseModuleService = courseModuleService;
    }

    public String doDefault() throws Exception {
        Object[] courseAnswers;
        CourseSettings settings;
        List<Long> allowedModuleIds;
        MailParams params = this.getParam();
        if (!this.cqPermissionHelper.isUserAuthorized(params)) {
            return "login";
        }
        Optional<CourseEnrollWrapper> wrapperOpt = this.courseStateEntityService.getCourseEnrollWrapper(params.getUid(), params.getQid(), params.getRid());
        if (!wrapperOpt.isPresent()) {
            return COURSE_ENROLL_DELETED_TEMPLATE;
        }
        CourseEnrollWrapper courseEnrollWrapper = wrapperOpt.get();
        if (courseEnrollWrapper.getStatus() == 4) {
            return "overdue";
        }
        CourseModule[] allModules = this.courseModuleService.getCourseStateInitialModules(Long.valueOf(courseEnrollWrapper.getID()));
        CourseModule[] activeModules = courseEnrollWrapper.getCourseModules();
        Object module = null;
        Long moduleId = this.getQuestionId();
        if (moduleId != null && (allowedModuleIds = this.getAllowedModuleIds(settings = this.courseSettingsService.getOrCreate(courseEnrollWrapper.getCourseId()), allModules, (CourseAnswers[])(courseAnswers = this.courseStateEntityService.getAnswers(params.getQid(), params.getUid(), courseEnrollWrapper.getStartDate())), activeModules)).contains(moduleId)) {
            module = Arrays.stream(allModules).filter(m -> moduleId.equals(m.getModuleId())).findAny().orElse(null);
        }
        if (module == null) {
            CourseAnswers[] watchingAnswers = this.courseStateEntityService.findWatchingAnswer(params.getUid(), params.getQid(), params.getAid(), courseEnrollWrapper.getStartDate());
            if (watchingAnswers.length > 0) {
                for (CourseModule courseModule : allModules) {
                    if (!courseModule.getModuleId().equals(watchingAnswers[0].getModuleId())) continue;
                    module = courseModule;
                    break;
                }
            }
            if (module == null) {
                module = activeModules.length > 0 ? activeModules[0] : allModules[0];
            }
        }
        this.answers = this.courseStateEntityService.getAnswer(params.getUid(), params.getQid(), params.getAid(), module.getModuleId(), courseEnrollWrapper.getStartDate())[0];
        MutablePair<String, AbstractPage> pair = this.quizPageManager.renderPage(module.getModuleId(), this.answers.getPageVersion(), this.getAuthor(courseEnrollWrapper.getAuthor()), params);
        AbstractPage page = (AbstractPage)pair.getRight();
        String body = (String)pair.getLeft();
        this.answers = this.courseStateEntityService.startAnswer(params.getUid(), params.getQid(), params.getAid(), module.getModuleId(), page.getVersion(), courseEnrollWrapper);
        if (courseEnrollWrapper.getStatus() == 1) {
            this.courseStateEntityService.moveToModule(params.getUid(), params.getQid(), params.getAid(), module.getModuleId(), courseEnrollWrapper);
        }
        if (module.getType().equals(DefaultCourseModuleService.QUIZ_MODULE)) {
            params.setQid(module.getModuleId());
            params.setRid(this.answers.getQuizStateId());
            new StaticHttpContext().getResponse().sendRedirect(this.getGlobalSettings().getBaseUrl() + "/quiz/course/viewQuiz.action?qsd=" + GeneralUtil.urlEncode((String)QuizEncrypter.encrypt(params)));
        }
        this.modulePage = new Question(body, module.getModuleId(), courseEnrollWrapper.getStartDate());
        return "success";
    }

    public Question getModule() {
        return this.modulePage;
    }

    public CourseAnswers getAnswers() {
        return this.answers;
    }

    public void setCourseSettingsService(CourseSettingsService courseSettingsService) {
        this.courseSettingsService = courseSettingsService;
    }

    private List<Long> getAllowedModuleIds(CourseSettings settings, CourseModule[] allModules, CourseAnswers[] courseAnswers, CourseModule[] activeModules) {
        if (settings.getOrder() == null || settings.getOrder() == 0) {
            List<Long> ids = Arrays.stream(courseAnswers).map(CourseAnswers::getModuleId).collect(Collectors.toList());
            if (activeModules.length > 0 && Arrays.stream(courseAnswers).noneMatch(a -> a.getProgress() == 1)) {
                ids.add(0, activeModules[0].getModuleId());
            }
            return ids;
        }
        return Arrays.stream(allModules).map(CourseModule::getModuleId).collect(Collectors.toList());
    }
}

